/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.spigot;

import lombok.Generated;
import net.skinsrestorer.bukkit.utils.SchedulerProvider;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.ServerConfig;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SpigotPassengerUtil {
    private final SchedulerProvider scheduler;
    private final SettingsManager settings;

    public static boolean isAvailable() {
        try {
            Entity.class.getMethod("getPassengers", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void ejectPassengers(Player player) {
        Entity vehicle = player.getVehicle();
        if (this.settings.getProperty(ServerConfig.DISMOUNT_PLAYER_ON_UPDATE).booleanValue() && vehicle != null) {
            vehicle.removePassenger((Entity)player);
            if (this.settings.getProperty(ServerConfig.REMOUNT_PLAYER_ON_UPDATE).booleanValue()) {
                this.scheduler.runSyncToEntityDelayed((Entity)player, () -> {
                    if (vehicle.isValid()) {
                        vehicle.addPassenger((Entity)player);
                    }
                }, 1L);
            }
        }
        if (this.settings.getProperty(ServerConfig.DISMOUNT_PASSENGERS_ON_UPDATE).booleanValue() && !player.isEmpty()) {
            for (Entity passenger : player.getPassengers()) {
                player.removePassenger(passenger);
            }
        }
    }

    @Inject
    @Generated
    public SpigotPassengerUtil(SchedulerProvider scheduler, SettingsManager settings) {
        this.scheduler = scheduler;
        this.settings = settings;
    }
}

