/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cooldown;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.skinsrestorer.shadow.cloud.processors.cache.CloudCache;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfile;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfileFactory;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@API(status=API.Status.STABLE, since="1.0.0")
@NestMembers(value={CacheCooldownRepository.class, MapCooldownRepository.class, AbstractCooldownRepository.class, MappingCooldownRepository.class})
public interface CooldownRepository<K> {
    public static <C, K> @NonNull CooldownRepository<C> mapping(@NonNull Function<C, K> mappingFunction, @NonNull CooldownRepository<K> otherRepository) {
        return new MappingCooldownRepository<C, K>(Objects.requireNonNull(mappingFunction, "mappingFunction"), Objects.requireNonNull(otherRepository, "otherRepository"));
    }

    public static <K> @NonNull CooldownRepository<K> forCache(@NonNull CloudCache<K, CooldownProfile> cache) {
        return new CacheCooldownRepository<K>(Objects.requireNonNull(cache, "cache"));
    }

    public static <K> @NonNull CooldownRepository<K> forMap(@NonNull Map<K, CooldownProfile> map) {
        return new MapCooldownRepository<K>(Objects.requireNonNull(map, "map"));
    }

    public @NonNull CooldownProfile getProfile(@NonNull K var1, @NonNull CooldownProfileFactory var2);

    public @Nullable CooldownProfile getProfileIfExists(@NonNull K var1);

    public void deleteProfile(@NonNull K var1);

    public void deleteCooldown(@NonNull K var1, @NonNull CooldownGroup var2);

    @NestHost(value=CooldownRepository.class)
    public static final class MappingCooldownRepository<C, K>
    implements CooldownRepository<C> {
        private final Function<C, K> mappingFunction;
        private final CooldownRepository<K> otherRepository;

        MappingCooldownRepository(@NonNull Function<C, K> mappingFunction, @NonNull CooldownRepository<K> otherRepository) {
            this.mappingFunction = mappingFunction;
            this.otherRepository = otherRepository;
        }

        @Override
        public @NonNull CooldownProfile getProfile(@NonNull C key, @NonNull CooldownProfileFactory profileFactory) {
            return this.otherRepository.getProfile(this.mappingFunction.apply(key), profileFactory);
        }

        @Override
        public @Nullable CooldownProfile getProfileIfExists(@NonNull C key) {
            return this.otherRepository.getProfileIfExists(this.mappingFunction.apply(key));
        }

        @Override
        public void deleteProfile(@NonNull C key) {
            this.otherRepository.deleteProfile(this.mappingFunction.apply(key));
        }

        @Override
        public void deleteCooldown(@NonNull C key, @NonNull CooldownGroup group) {
            this.otherRepository.deleteCooldown(this.mappingFunction.apply(key), group);
        }
    }

    @NestHost(value=CooldownRepository.class)
    public static final class CacheCooldownRepository<K>
    extends AbstractCooldownRepository<K> {
        private final CloudCache<K, CooldownProfile> cache;

        CacheCooldownRepository(@NonNull CloudCache<K, CooldownProfile> cache) {
            this.cache = cache;
        }

        @Override
        public synchronized @NonNull CooldownProfile getProfile(@NonNull K key, @NonNull CooldownProfileFactory profileFactory) {
            CooldownProfile profile = this.cache.getIfPresent(key);
            if (profile == null) {
                profile = profileFactory.create();
                this.cache.put(key, profile);
            }
            return profile;
        }

        @Override
        public synchronized @Nullable CooldownProfile getProfileIfExists(@NonNull K key) {
            return this.cache.getIfPresent(key);
        }

        @Override
        public synchronized void deleteProfile(@NonNull K key) {
            this.cache.delete(key);
        }
    }

    @NestHost(value=CooldownRepository.class)
    public static final class MapCooldownRepository<K>
    extends AbstractCooldownRepository<K> {
        private final Map<K, CooldownProfile> map;

        MapCooldownRepository(@NonNull Map<K, CooldownProfile> map) {
            this.map = map;
        }

        @Override
        public synchronized @NonNull CooldownProfile getProfile(@NonNull K key, @NonNull CooldownProfileFactory profileFactory) {
            return this.map.computeIfAbsent(key, k -> profileFactory.create());
        }

        @Override
        public synchronized @Nullable CooldownProfile getProfileIfExists(@NonNull K key) {
            return this.map.get(key);
        }

        @Override
        public synchronized void deleteProfile(@NonNull K key) {
            this.map.remove(key);
        }
    }

    @NestHost(value=CooldownRepository.class)
    public static abstract class AbstractCooldownRepository<K>
    implements CooldownRepository<K> {
        @Override
        public synchronized void deleteCooldown(@NonNull K key, @NonNull CooldownGroup group) {
            CooldownProfile profile = this.getProfileIfExists(key);
            if (profile == null) {
                return;
            }
            profile.deleteCooldown(group);
            if (profile.isEmpty()) {
                this.deleteProfile(key);
            }
        }
    }
}

