/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.translations;

import java.util.Locale;
import net.skinsrestorer.shadow.cloud.caption.Caption;
import net.skinsrestorer.shadow.cloud.caption.CaptionProvider;
import net.skinsrestorer.shadow.cloud.translations.LocaleExtractor;
import net.skinsrestorer.shadow.cloud.translations.ResourceBundleTranslationBundle;
import net.skinsrestorer.shadow.cloud.translations.TranslatedCaptionProvider;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public interface TranslationBundle<C>
extends CaptionProvider<C> {
    public static <C> @NonNull TranslationBundle<C> resourceBundle(@NonNull String baseName, @NonNull LocaleExtractor<C> localeExtractor) {
        return TranslationBundle.resourceBundle(baseName, localeExtractor, TranslationBundle.class.getClassLoader());
    }

    public static <C> @NonNull TranslationBundle<C> resourceBundle(@NonNull String baseName, @NonNull LocaleExtractor<C> localeExtractor, @NonNull ClassLoader classLoader) {
        return new ResourceBundleTranslationBundle<C>(baseName, localeExtractor, classLoader);
    }

    public static <C> @NonNull TranslationBundle<C> core(@NonNull LocaleExtractor<C> localeExtractor) {
        return new ResourceBundleTranslationBundle<C>("net.skinsrestorer.shadow.cloud.core.lang.messages", localeExtractor, TranslationBundle.class.getClassLoader());
    }

    public @NonNull LocaleExtractor<C> localeExtractor();

    public @Nullable TranslatedCaptionProvider<C> translations(@NonNull Locale var1);

    @Override
    default public @Nullable String provide(@NonNull Caption caption, @NonNull C recipient) {
        Locale locale = this.localeExtractor().extract(recipient);
        TranslatedCaptionProvider<C> translatedCaptionProvider = this.translations(locale);
        if (translatedCaptionProvider == null) {
            return null;
        }
        return translatedCaptionProvider.provide(caption, recipient);
    }
}

