/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.beanmapper.leafvaluehandler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.skinsrestorer.shadow.configme.beanmapper.leafvaluehandler.AbstractLeafValueHandler;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class NumberLeafValueHandler
extends AbstractLeafValueHandler {
    private static final Map<Class<?>, Function<Number, Number>> NUMBER_CLASSES_TO_CONVERSION = NumberLeafValueHandler.createMapOfTypeToTransformFunction();

    @Override
    @Nullable
    public Object convert(@Nullable Class<?> clazz, @Nullable Object value) {
        if (value instanceof Number) {
            Function<Number, Number> numberFunction = NUMBER_CLASSES_TO_CONVERSION.get(clazz);
            return numberFunction == null ? (Number)null : (Number)numberFunction.apply((Number)value);
        }
        return null;
    }

    @Override
    @Nullable
    public Object toExportValue(@Nullable Object value) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = value == null ? null : value.getClass();
        if (NUMBER_CLASSES_TO_CONVERSION.containsKey(clazz)) {
            return value;
        }
        return null;
    }

    @NotNull
    private static Map<Class<?>, Function<Number, Number>> createMapOfTypeToTransformFunction() {
        HashMap<Class<Double>, Function<Number, Number>> map = new HashMap<Class<Double>, Function<Number, Number>>();
        map.put(Byte.TYPE, Number::byteValue);
        map.put(Byte.class, Number::byteValue);
        map.put(Short.TYPE, Number::shortValue);
        map.put(Short.class, Number::shortValue);
        map.put(Integer.TYPE, Number::intValue);
        map.put(Integer.class, Number::intValue);
        map.put(Long.TYPE, Number::longValue);
        map.put(Long.class, Number::longValue);
        map.put(Float.TYPE, Number::floatValue);
        map.put(Float.class, Number::floatValue);
        map.put(Double.TYPE, Number::doubleValue);
        map.put(Double.class, Number::doubleValue);
        return Collections.unmodifiableMap(map);
    }
}

