/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Objects;
import net.skinsrestorer.shared.codec.BuiltInCodecs;
import net.skinsrestorer.shared.codec.NetworkId;
import net.skinsrestorer.shared.codec.SRInputReader;
import net.skinsrestorer.shared.codec.SROutputWriter;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="writer", type=Writer.class), @RecordComponents.Value(name="reader", type=Reader.class)})
@NestMembers(value={Reader.class, Writer.class})
public final class NetworkCodec<T>
extends J_L_Record {
    private final Writer<T> writer;
    private final Reader<T> reader;

    public NetworkCodec(Writer<T> writer, Reader<T> reader) {
        this.writer = writer;
        this.reader = reader;
    }

    public static <T> NetworkCodec<T> of(Writer<T> writer, Reader<T> reader) {
        return new NetworkCodec<T>(writer, reader);
    }

    public static <T> NetworkCodec<T> ofMapBackedDynamic(Map<String, T> idToValue, Function<T, String> dynamicMapper) {
        return NetworkCodec.ofMapBackedDynamic(idToValue, dynamicMapper, null);
    }

    public static <T> NetworkCodec<T> ofMapBackedDynamic(Map<String, T> idToValue, Function<T, String> dynamicMapper, @Nullable Function<String, String> messageSupplier) {
        Function<String, String> actualMessageSupplier = J_U_Objects.requireNonNullElse(messageSupplier, arg_0 -> NetworkCodec.lambda$ofMapBackedDynamic$0("Unknown id: %s", arg_0));
        return BuiltInCodecs.STRING_CODEC.map(dynamicMapper, id -> idToValue.computeIfAbsent((String)id, i -> {
            throw new IllegalArgumentException((String)actualMessageSupplier.apply((String)i));
        }));
    }

    public static <T extends Enum<T>> NetworkCodec<T> ofEnumDynamic(Class<T> clazz, Function<T, String> dynamicMapper) {
        return NetworkCodec.ofEnumDynamic(clazz, dynamicMapper, null);
    }

    public static <T extends Enum<T>> NetworkCodec<T> ofEnumDynamic(Class<T> clazz, Function<T, String> dynamicMapper, @Nullable Function<String, String> messageSupplier) {
        HashMap<String, Enum> idToValue = new HashMap<String, Enum>();
        for (Enum value : (Enum[])clazz.getEnumConstants()) {
            idToValue.put(dynamicMapper.apply(value), value);
        }
        return NetworkCodec.ofMapBackedDynamic(idToValue, dynamicMapper, messageSupplier);
    }

    public static <T extends Enum<T>> NetworkCodec<T> ofEnum(Class<T> clazz) {
        return NetworkCodec.ofEnum(clazz, null);
    }

    public static <T extends Enum<T>> NetworkCodec<T> ofEnum(Class<T> clazz, @Nullable Function<String, String> messageSupplier) {
        return NetworkCodec.ofEnumDynamic(clazz, rec$ -> ((NetworkId)rec$).getId(), messageSupplier);
    }

    public void write(SROutputWriter buf, T t) {
        this.writer.write(buf, t);
    }

    public T read(SRInputReader buf) {
        return this.reader.read(buf);
    }

    public <O> NetworkCodec<O> map(Function<O, T> to, Function<T, O> from) {
        return NetworkCodec.of((stream, o) -> this.writer.write(stream, to.apply(o)), stream -> from.apply(this.reader.read(stream)));
    }

    public NetworkCodec<Optional<T>> optional() {
        return NetworkCodec.of((os, optional) -> {
            BuiltInCodecs.BOOLEAN_CODEC.write(os, optional.isPresent());
            optional.ifPresent(t -> this.write(os, t));
        }, is -> BuiltInCodecs.BOOLEAN_CODEC.read(is) != false ? Optional.of(this.read(is)) : Optional.empty());
    }

    public NetworkCodec<List<T>> list() {
        return NetworkCodec.of((os, list) -> {
            BuiltInCodecs.INT_CODEC.write(os, list.size());
            for (Object entry : list) {
                this.write(os, entry);
            }
        }, is -> {
            int size = BuiltInCodecs.INT_CODEC.read(is);
            ArrayList<T> list = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.read(is));
            }
            return list;
        });
    }

    public <V> NetworkCodec<Map<T, V>> mappedTo(NetworkCodec<V> valueCodec) {
        return NetworkCodec.of((os, map) -> {
            BuiltInCodecs.INT_CODEC.write(os, map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.write(os, entry.getKey());
                valueCodec.write(os, entry.getValue());
            }
        }, is -> {
            int size = BuiltInCodecs.INT_CODEC.read(is);
            LinkedHashMap<T, T> map = new LinkedHashMap<T, T>(size);
            for (int i = 0; i < size; ++i) {
                T key = this.read(is);
                T value = valueCodec.read(is);
                map.put(key, value);
            }
            return map;
        });
    }

    public NetworkCodec<T> compressed() {
        return NetworkCodec.of((stream, t) -> {
            try (GZIPOutputStream gzip = new GZIPOutputStream(stream.wrapper());
                 DataOutputStream outputStream = new DataOutputStream(gzip);){
                this.writer.write(new SROutputWriter(outputStream), t);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, stream -> {
            try (GZIPInputStream gzip = new GZIPInputStream(stream.wrapper());){
                T t;
                try (DataInputStream inputStream = new DataInputStream(gzip);){
                    t = this.reader.read(new SRInputReader(inputStream));
                }
                return t;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public final String toString() {
        return NetworkCodec.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return NetworkCodec.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return NetworkCodec.jvmdowngrader$equals$equals(this, o);
    }

    public Writer<T> writer() {
        return this.writer;
    }

    public Reader<T> reader() {
        return this.reader;
    }

    private static /* synthetic */ String lambda$ofMapBackedDynamic$0(String rec$, Object xva$0) {
        return J_L_String.formatted("Unknown id: %s", xva$0);
    }

    private static String jvmdowngrader$toString$toString(NetworkCodec networkCodec) {
        NetworkCodec networkCodec2 = networkCodec;
        return "NetworkCodec[" + "writer=" + networkCodec.writer + ", " + "reader=" + networkCodec.reader + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(NetworkCodec networkCodec) {
        Object[] objectArray = new Object[]{networkCodec.writer, networkCodec.reader};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(NetworkCodec networkCodec, Object object) {
        if (networkCodec == object) {
            return true;
        }
        if (object != null && object instanceof NetworkCodec) {
            NetworkCodec networkCodec2 = (NetworkCodec)object;
            if (Objects.equals(networkCodec.writer, networkCodec2.writer) && Objects.equals(networkCodec.reader, networkCodec2.reader)) {
                return true;
            }
        }
        return false;
    }

    @NestHost(value=NetworkCodec.class)
    public static interface Writer<T> {
        public void write(SROutputWriter var1, T var2);
    }

    @NestHost(value=NetworkCodec.class)
    public static interface Reader<T> {
        public T read(SRInputReader var1);
    }
}

