/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.gui;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.codec.BuiltInCodecs;
import net.skinsrestorer.shared.codec.NetworkCodec;
import net.skinsrestorer.shared.codec.NetworkId;
import net.skinsrestorer.shared.codec.SRProxyPluginMessage;
import net.skinsrestorer.shared.gui.ClickEventType;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="rows", type=int.class), @RecordComponents.Value(name="title", type=ComponentString.class), @RecordComponents.Value(name="items", type=Map.class)})
@NestMembers(value={ClickEventAction.class, Item.class, MaterialType.class})
public final class SRInventory
extends J_L_Record {
    private final int rows;
    private final ComponentString title;
    private final Map<Integer, Item> items;
    public static final NetworkCodec<SRInventory> CODEC = NetworkCodec.of((stream, inventory) -> {
        BuiltInCodecs.INT_CODEC.write(stream, inventory.rows());
        ComponentString.CODEC.write(stream, inventory.title());
        BuiltInCodecs.INT_CODEC.mappedTo(Item.CODEC).write(stream, inventory.items());
    }, stream -> new SRInventory(BuiltInCodecs.INT_CODEC.read(stream), ComponentString.CODEC.read(stream), BuiltInCodecs.INT_CODEC.mappedTo(Item.CODEC).read(stream))).compressed();

    public SRInventory(int rows, ComponentString title, Map<Integer, Item> items) {
        this.rows = rows;
        this.title = title;
        this.items = items;
    }

    @Override
    public final String toString() {
        return SRInventory.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return SRInventory.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return SRInventory.jvmdowngrader$equals$equals(this, o);
    }

    public int rows() {
        return this.rows;
    }

    public ComponentString title() {
        return this.title;
    }

    public Map<Integer, Item> items() {
        return this.items;
    }

    private static String jvmdowngrader$toString$toString(SRInventory sRInventory) {
        SRInventory sRInventory2 = sRInventory;
        return "SRInventory[" + "rows=" + sRInventory.rows + ", " + "title=" + sRInventory.title + ", " + "items=" + sRInventory.items + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(SRInventory sRInventory) {
        Object[] objectArray = new Object[]{sRInventory.rows, sRInventory.title, sRInventory.items};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(SRInventory sRInventory, Object object) {
        if (sRInventory == object) {
            return true;
        }
        if (object != null && object instanceof SRInventory) {
            SRInventory sRInventory2 = (SRInventory)object;
            if (sRInventory.rows == sRInventory2.rows && Objects.equals(sRInventory.title, sRInventory2.title) && Objects.equals(sRInventory.items, sRInventory2.items)) {
                return true;
            }
        }
        return false;
    }

    @RecordComponents(value={@RecordComponents.Value(name="materialType", type=MaterialType.class), @RecordComponents.Value(name="displayName", type=ComponentString.class), @RecordComponents.Value(name="lore", type=List.class), @RecordComponents.Value(name="textureHash", type=Optional.class), @RecordComponents.Value(name="enchantmentGlow", type=boolean.class), @RecordComponents.Value(name="clickHandlers", type=Map.class)})
    @NestHost(value=SRInventory.class)
    public static final class Item
    extends J_L_Record {
        private final MaterialType materialType;
        private final ComponentString displayName;
        private final List<ComponentString> lore;
        private final Optional<String> textureHash;
        private final boolean enchantmentGlow;
        private final Map<ClickEventType, ClickEventAction> clickHandlers;
        public static final NetworkCodec<Item> CODEC = NetworkCodec.of((stream, item) -> {
            MaterialType.CODEC.write(stream, item.materialType());
            ComponentString.CODEC.write(stream, item.displayName());
            ComponentString.CODEC.list().write(stream, item.lore());
            BuiltInCodecs.STRING_CODEC.optional().write(stream, item.textureHash());
            BuiltInCodecs.BOOLEAN_CODEC.write(stream, item.enchantmentGlow());
            ClickEventType.CODEC.mappedTo(ClickEventAction.CODEC).write(stream, item.clickHandlers());
        }, stream -> new Item(MaterialType.CODEC.read(stream), ComponentString.CODEC.read(stream), ComponentString.CODEC.list().read(stream), BuiltInCodecs.STRING_CODEC.optional().read(stream), BuiltInCodecs.BOOLEAN_CODEC.read(stream), ClickEventType.CODEC.mappedTo(ClickEventAction.CODEC).read(stream)));

        public Item(MaterialType materialType, ComponentString displayName, List<ComponentString> lore, Optional<String> textureHash, boolean enchantmentGlow, Map<ClickEventType, ClickEventAction> clickHandlers) {
            this.materialType = materialType;
            this.displayName = displayName;
            this.lore = lore;
            this.textureHash = textureHash;
            this.enchantmentGlow = enchantmentGlow;
            this.clickHandlers = clickHandlers;
        }

        @Override
        public final String toString() {
            return Item.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return Item.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return Item.jvmdowngrader$equals$equals(this, o);
        }

        public MaterialType materialType() {
            return this.materialType;
        }

        public ComponentString displayName() {
            return this.displayName;
        }

        public List<ComponentString> lore() {
            return this.lore;
        }

        public Optional<String> textureHash() {
            return this.textureHash;
        }

        public boolean enchantmentGlow() {
            return this.enchantmentGlow;
        }

        public Map<ClickEventType, ClickEventAction> clickHandlers() {
            return this.clickHandlers;
        }

        private static String jvmdowngrader$toString$toString(Item item) {
            Item item2 = item;
            return "SRInventory$Item[" + "materialType=" + item.materialType + ", " + "displayName=" + item.displayName + ", " + "lore=" + item.lore + ", " + "textureHash=" + item.textureHash + ", " + "enchantmentGlow=" + item.enchantmentGlow + ", " + "clickHandlers=" + item.clickHandlers + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(Item item) {
            Object[] objectArray = new Object[]{item.materialType, item.displayName, item.lore, item.textureHash, item.enchantmentGlow, item.clickHandlers};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(Item item, Object object) {
            if (item == object) {
                return true;
            }
            if (object != null && object instanceof Item) {
                Item item2 = (Item)object;
                if (Objects.equals(item.materialType, item2.materialType) && Objects.equals(item.displayName, item2.displayName) && Objects.equals(item.lore, item2.lore) && Objects.equals(item.textureHash, item2.textureHash) && item.enchantmentGlow == item2.enchantmentGlow && Objects.equals(item.clickHandlers, item2.clickHandlers)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="actionChannelPayload", type=List.class), @RecordComponents.Value(name="closeInventory", type=boolean.class)})
    @NestHost(value=SRInventory.class)
    public static final class ClickEventAction
    extends J_L_Record {
        private final List<SRProxyPluginMessage.GUIActionChannelPayload> actionChannelPayload;
        private final boolean closeInventory;
        public static final NetworkCodec<ClickEventAction> CODEC = NetworkCodec.of((stream, action) -> {
            SRProxyPluginMessage.GUIActionChannelPayload.CODEC.list().write(stream, action.actionChannelPayload());
            BuiltInCodecs.BOOLEAN_CODEC.write(stream, action.closeInventory());
        }, stream -> new ClickEventAction(SRProxyPluginMessage.GUIActionChannelPayload.CODEC.list().read(stream), (boolean)BuiltInCodecs.BOOLEAN_CODEC.read(stream)));

        public ClickEventAction(SRProxyPluginMessage.GUIActionChannelPayload actionChannelPayload, boolean closeInventory) {
            this(J_U_List.of(actionChannelPayload), closeInventory);
        }

        public ClickEventAction(List<SRProxyPluginMessage.GUIActionChannelPayload> actionChannelPayload, boolean closeInventory) {
            this.actionChannelPayload = actionChannelPayload;
            this.closeInventory = closeInventory;
        }

        @Override
        public final String toString() {
            return ClickEventAction.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ClickEventAction.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ClickEventAction.jvmdowngrader$equals$equals(this, o);
        }

        public List<SRProxyPluginMessage.GUIActionChannelPayload> actionChannelPayload() {
            return this.actionChannelPayload;
        }

        public boolean closeInventory() {
            return this.closeInventory;
        }

        private static String jvmdowngrader$toString$toString(ClickEventAction clickEventAction) {
            ClickEventAction clickEventAction2 = clickEventAction;
            return "SRInventory$ClickEventAction[" + "actionChannelPayload=" + clickEventAction.actionChannelPayload + ", " + "closeInventory=" + clickEventAction.closeInventory + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(ClickEventAction clickEventAction) {
            Object[] objectArray = new Object[]{clickEventAction.actionChannelPayload, clickEventAction.closeInventory};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(ClickEventAction clickEventAction, Object object) {
            if (clickEventAction == object) {
                return true;
            }
            if (object != null && object instanceof ClickEventAction) {
                ClickEventAction clickEventAction2 = (ClickEventAction)object;
                if (Objects.equals(clickEventAction.actionChannelPayload, clickEventAction2.actionChannelPayload) && clickEventAction.closeInventory == clickEventAction2.closeInventory) {
                    return true;
                }
            }
            return false;
        }
    }

    @NestHost(value=SRInventory.class)
    public static enum MaterialType implements NetworkId
    {
        SKULL,
        ARROW,
        BARRIER,
        BOOKSHELF,
        ENDER_EYE,
        ENCHANTING_TABLE;

        public static final NetworkCodec<MaterialType> CODEC;

        @Override
        public String getId() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = NetworkCodec.ofEnum(MaterialType.class);
        }
    }
}

