/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import java.util.List;
import lombok.Generated;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.codec.SRProxyPluginMessage;
import net.skinsrestorer.shared.commands.library.SRCommandManager;
import net.skinsrestorer.shared.gui.SharedGUI;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.storage.GUIStorage;
import net.skinsrestorer.shared.storage.PlayerStorageImpl;
import net.skinsrestorer.shared.storage.model.player.FavouriteData;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.SRHelpers;

public class GUIActionListener {
    private final SRPlatformAdapter adapter;
    private final GUIStorage guiStorage;
    private final SharedGUI sharedGUI;
    private final SRCommandManager commandManager;
    private final PlayerStorageImpl playerStorage;

    public void handle(SRPlayer player, List<SRProxyPluginMessage.GUIActionChannelPayload> actionChannelPayload) {
        for (SRProxyPluginMessage.GUIActionChannelPayload payload : actionChannelPayload) {
            SRProxyPluginMessage.GUIActionChannelPayload.GUIActionPayload<?> actionPayload = payload.payload();
            if (actionPayload instanceof SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload) {
                SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload openPagePayload = (SRProxyPluginMessage.GUIActionChannelPayload.OpenPagePayload)actionPayload;
                this.adapter.openGUI(player, this.sharedGUI.createGUIPage(player, this.guiStorage.getGUIPage(player, openPagePayload.page(), openPagePayload.type())));
                continue;
            }
            if (actionPayload instanceof SRProxyPluginMessage.GUIActionChannelPayload.ClearSkinPayload) {
                this.commandManager.execute(player, "skin clear");
                continue;
            }
            if (actionPayload instanceof SRProxyPluginMessage.GUIActionChannelPayload.SetSkinPayload) {
                SRProxyPluginMessage.GUIActionChannelPayload.SetSkinPayload setSkinPayload = (SRProxyPluginMessage.GUIActionChannelPayload.SetSkinPayload)actionPayload;
                this.commandManager.execute(player, J_L_String.formatted("skin set \"%s\"", setSkinPayload.skinIdentifier().getIdentifier()));
                continue;
            }
            if (actionPayload instanceof SRProxyPluginMessage.GUIActionChannelPayload.AddFavouritePayload) {
                SRProxyPluginMessage.GUIActionChannelPayload.AddFavouritePayload addFavouritePayload = (SRProxyPluginMessage.GUIActionChannelPayload.AddFavouritePayload)actionPayload;
                this.playerStorage.addFavourite(player.getUniqueId(), FavouriteData.of(SRHelpers.getEpochSecond(), addFavouritePayload.skinIdentifier()));
                continue;
            }
            if (!(actionPayload instanceof SRProxyPluginMessage.GUIActionChannelPayload.RemoveFavouritePayload)) continue;
            SRProxyPluginMessage.GUIActionChannelPayload.RemoveFavouritePayload removeFavouritePayload = (SRProxyPluginMessage.GUIActionChannelPayload.RemoveFavouritePayload)actionPayload;
            this.playerStorage.removeFavourite(player.getUniqueId(), removeFavouritePayload.skinIdentifier());
        }
    }

    @Inject
    @Generated
    public GUIActionListener(SRPlatformAdapter adapter, GUIStorage guiStorage, SharedGUI sharedGUI, SRCommandManager commandManager, PlayerStorageImpl playerStorage) {
        this.adapter = adapter;
        this.guiStorage = guiStorage;
        this.sharedGUI = sharedGUI;
        this.commandManager = commandManager;
        this.playerStorage = playerStorage;
    }
}

