/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import lombok.Generated;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.codec.SRInputReader;
import net.skinsrestorer.shared.codec.SRProxyPluginMessage;
import net.skinsrestorer.shared.listeners.GUIActionListener;
import net.skinsrestorer.shared.listeners.event.SRProxyMessageEvent;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;

public final class SRProxyMessageAdapter {
    private final SRPlatformAdapter adapter;
    private final GUIActionListener guiActionListener;

    public void handlePluginMessage(SRProxyMessageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getChannel().equals("sr:messagechannel")) {
            return;
        }
        if (!event.isSenderServerConnection() || !event.isReceiverProxyPlayer()) {
            event.setCancelled(true);
            return;
        }
        this.adapter.runAsync(() -> {
            SRInputReader in = new SRInputReader(event.getData());
            SRProxyPluginMessage.ChannelPayload<?> msg = SRProxyPluginMessage.CODEC.read(in).channelPayload();
            if (msg instanceof SRProxyPluginMessage.GUIActionChannelPayloadList) {
                SRProxyPluginMessage.GUIActionChannelPayloadList actionChannelPayload = (SRProxyPluginMessage.GUIActionChannelPayloadList)msg;
                this.guiActionListener.handle(event.getPlayer(), actionChannelPayload.actions());
            }
        });
    }

    @Inject
    @Generated
    public SRProxyMessageAdapter(SRPlatformAdapter adapter, GUIActionListener guiActionListener) {
        this.adapter = adapter;
        this.guiActionListener = guiActionListener;
    }
}

