/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.shared.utils.SRHelpers;

public class ExpiringSet<E> {
    private final Map<E, Long> cache = new HashMap<E, Long>();
    private final long lifetime;

    public ExpiringSet(long duration, TimeUnit unit) {
        this.lifetime = unit.toSeconds(duration);
    }

    public void add(E item) {
        this.cleanup();
        this.cache.put(item, SRHelpers.getEpochSecond() + this.lifetime);
    }

    public boolean contains(E item) {
        this.cleanup();
        return this.cache.containsKey(item);
    }

    public void cleanup() {
        this.cache.entrySet().removeIf(entry -> (Long)entry.getValue() < SRHelpers.getEpochSecond());
    }
}

