/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.plugin.SRServerPlugin;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Service.class})
public class MetricsCounter {
    private final Injector injector;
    private final SettingsManager settingsManager;
    private final Map<Service, AtomicInteger> map = new EnumMap<Service, AtomicInteger>(Service.class);

    public String usesMySQL() {
        return String.valueOf(this.settingsManager.getProperty(DatabaseConfig.MYSQL_ENABLED));
    }

    public String isProxyMode() {
        SRServerPlugin serverPlugin = this.injector.getIfAvailable(SRServerPlugin.class);
        if (serverPlugin == null) {
            return null;
        }
        return String.valueOf(serverPlugin.isProxyMode());
    }

    public void increment(Service service) {
        this.getOrCreate(service).incrementAndGet();
    }

    public int collect(Service service) {
        return this.getOrCreate(service).getAndSet(0);
    }

    private AtomicInteger getOrCreate(Service service) {
        return this.map.computeIfAbsent(service, k -> new AtomicInteger());
    }

    @Inject
    @Generated
    public MetricsCounter(Injector injector, SettingsManager settingsManager) {
        this.injector = injector;
        this.settingsManager = settingsManager;
    }

    @NestHost(value=MetricsCounter.class)
    public static enum Service {
        MINE_SKIN,
        MINE_TOOLS,
        MOJANG,
        ECLIPSE_UUID,
        ECLIPSE_PROFILE;

    }
}

