/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.builder;

import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.builder.RuleFactory;
import io.papermc.asm.rules.builder.matcher.FieldMatcher;
import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.builder.matcher.TargetedMethodMatcher;
import io.papermc.asm.rules.field.FieldRewrites;
import io.papermc.asm.rules.method.MethodRewrites;
import io.papermc.asm.rules.method.StaticRewrites;
import io.papermc.asm.util.Builder;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

class RuleFactoryImpl
implements RuleFactory {
    final Set<ClassDesc> owners;
    final List<RewriteRule> rules = new ArrayList<RewriteRule>();

    RuleFactoryImpl(Set<ClassDesc> owners) {
        this.owners = Set.copyOf(owners);
    }

    private static <M, B extends Builder<M>> M build(Consumer<? super B> builderConsumer, Supplier<B> supplier) {
        Builder builder = (Builder)supplier.get();
        builderConsumer.accept(builder);
        return (M)builder.build();
    }

    @Override
    public void plainStaticRewrite(ClassDesc newOwner, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        this.addRule(new StaticRewrites.Plain(this.owners, (MethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::builder), newOwner));
    }

    @Override
    public void changeParamToSuper(ClassDesc legacyParamType, ClassDesc newParamType, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        this.addRule(new MethodRewrites.SuperTypeParam(this.owners, (MethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::builder), legacyParamType, newParamType));
    }

    @Override
    public void changeParamFuzzy(ClassDesc newParamType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(new StaticRewrites.FuzzyParam(this.owners, newParamType, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), RuleFactoryImpl.isStatic(staticHandler)));
    }

    @Override
    public void changeParamDirect(ClassDesc newParamType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(new StaticRewrites.DirectParam(this.owners, newParamType, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), RuleFactoryImpl.isStatic(staticHandler)));
    }

    @Override
    public void changeReturnTypeToSub(ClassDesc oldReturnType, ClassDesc newReturnType, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        this.addRule(new MethodRewrites.SubTypeReturn(this.owners, (MethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::builder), oldReturnType, newReturnType));
    }

    @Override
    public void changeReturnTypeDirect(ClassDesc newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeDirect(newReturnType, staticHandler, builderConsumer, false);
    }

    @Override
    public void changeReturnTypeDirectWithContext(ClassDesc newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.changeReturnTypeDirect(newReturnType, staticHandler, builderConsumer, true);
    }

    private void changeReturnTypeDirect(ClassDesc newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer, boolean includeOwnerContext) {
        TargetedMethodMatcher matcher = (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted);
        this.addRule(new StaticRewrites.DirectReturn(this.owners, newReturnType, matcher, RuleFactoryImpl.isStatic(staticHandler), includeOwnerContext));
    }

    @Override
    public void changeFieldToMethod(Consumer<? super FieldMatcher.Builder> builderConsumer, @Nullable String getterName, @Nullable String setterName, boolean isInterfaceMethod) {
        this.addRule(new FieldRewrites.ToMethodSameOwner(this.owners, (FieldMatcher)RuleFactoryImpl.build(builderConsumer, FieldMatcher::builder), getterName, setterName, isInterfaceMethod));
    }

    @Override
    public void addRule(RewriteRule rule) {
        this.rules.add(rule);
    }

    private static Method isStatic(Method staticHandler) {
        if (!Modifier.isStatic(staticHandler.getModifiers())) {
            throw new IllegalArgumentException(staticHandler + " isn't a static method");
        }
        return staticHandler;
    }

    @Override
    public RewriteRule build() {
        if (this.rules.size() == 1) {
            return this.rules.get(0);
        }
        return RewriteRule.chain(this.rules);
    }
}

