/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.builder.matcher;

import io.papermc.asm.rules.NameAndDescPredicate;
import io.papermc.asm.rules.builder.matcher.MethodMatcherImpl;
import io.papermc.asm.rules.builder.matcher.TargetedMethodMatcher;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

public interface MethodMatcher {
    public boolean matchesName(String var1);

    public boolean matches(String var1, String var2);

    public static Builder builder() {
        return new Builder();
    }

    public static TargetedMethodMatcher.Builder targeted() {
        return new TargetedMethodMatcher.Builder();
    }

    public static final class Builder
    implements io.papermc.asm.util.Builder<MethodMatcher> {
        private Predicate<String> byName = $ -> false;
        private NameAndDescPredicate bytecodeNameAndDesc = (n, d) -> false;

        private Builder() {
        }

        public MatchBuilder ctor() {
            return this.match("<init>");
        }

        public MatchBuilder match(String name) {
            return this.match(Collections.singleton(name));
        }

        public MatchBuilder match(String ... names) {
            return this.match(Set.of(names));
        }

        public MatchBuilder match(Collection<String> names) {
            return new MatchBuilder(names);
        }

        @Override
        public MethodMatcher build() {
            return new MethodMatcherImpl(this.byName, this.bytecodeNameAndDesc);
        }

        public final class MatchBuilder {
            private final Collection<String> names;
            private Predicate<? super MethodTypeDesc> bytecodeDescPredicate = $ -> false;

            private MatchBuilder(Collection<String> names) {
                this.names = names;
            }

            public Builder desc(String ... descriptors) {
                return this.desc((? super MethodTypeDesc desc) -> Arrays.stream(descriptors).anyMatch(d -> desc.descriptorString().equals(d)));
            }

            public Builder desc(Predicate<? super MethodTypeDesc> descPredicate) {
                this.bytecodeDescPredicate = descPredicate;
                return this.build();
            }

            public Builder build() {
                Builder.this.bytecodeNameAndDesc = Builder.this.bytecodeNameAndDesc.or((n, d) -> this.names.contains(n) && this.bytecodeDescPredicate.test(MethodTypeDesc.ofDescriptor(d)));
                Builder.this.byName = Builder.this.byName.or(this.names::contains);
                return Builder.this;
            }
        }
    }
}

