/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.OffsetDoubleList;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class CollisionUtil {
    public static final double COLLISION_EPSILON = 1.0E-7;
    public static final DoubleArrayList ZERO_ONE = DoubleArrayList.wrap((double[])new double[]{0.0, 1.0});
    private static final boolean DEBUG_SLICE_SHAPE = false;
    public static final int COLLISION_FLAG_LOAD_CHUNKS = 1;
    public static final int COLLISION_FLAG_COLLIDE_WITH_UNLOADED_CHUNKS = 2;
    public static final int COLLISION_FLAG_CHECK_BORDER = 4;
    public static final int COLLISION_FLAG_CHECK_ONLY = 8;

    public static boolean isSpecialCollidingBlock(BlockBehaviour.BlockStateBase block) {
        return block.hasLargeCollisionShape() || block.getBlock() == Blocks.MOVING_PISTON;
    }

    public static boolean isEmpty(AABB aabb) {
        return aabb.maxX - aabb.minX < 1.0E-7 || aabb.maxY - aabb.minY < 1.0E-7 || aabb.maxZ - aabb.minZ < 1.0E-7;
    }

    public static boolean isEmpty(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7;
    }

    public static AABB getBoxForChunk(int chunkX, int chunkZ) {
        double x = chunkX << 4;
        double z = chunkZ << 4;
        return new AABB(x - 3.0E-7, Double.NEGATIVE_INFINITY, z - 3.0E-7, x + 16.0000003, Double.POSITIVE_INFINITY, z + 16.0000003);
    }

    public static boolean voxelShapeIntersect(double minX1, double minY1, double minZ1, double maxX1, double maxY1, double maxZ1, double minX2, double minY2, double minZ2, double maxX2, double maxY2, double maxZ2) {
        return minX1 - maxX2 < -1.0E-7 && maxX1 - minX2 > 1.0E-7 && minY1 - maxY2 < -1.0E-7 && maxY1 - minY2 > 1.0E-7 && minZ1 - maxZ2 < -1.0E-7 && maxZ1 - minZ2 > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(AABB box, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return box.minX - maxX < -1.0E-7 && box.maxX - minX > 1.0E-7 && box.minY - maxY < -1.0E-7 && box.maxY - minY > 1.0E-7 && box.minZ - maxZ < -1.0E-7 && box.maxZ - minZ > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(AABB box1, AABB box2) {
        return box1.minX - box2.maxX < -1.0E-7 && box1.maxX - box2.minX > 1.0E-7 && box1.minY - box2.maxY < -1.0E-7 && box1.maxY - box2.minY > 1.0E-7 && box1.minZ - box2.maxZ < -1.0E-7 && box1.maxZ - box2.minZ > 1.0E-7;
    }

    public static double collideX(AABB target, AABB source, double source_move) {
        if (source.minY - target.maxY < -1.0E-7 && source.maxY - target.minY > 1.0E-7 && source.minZ - target.maxZ < -1.0E-7 && source.maxZ - target.minZ > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.minX - source.maxX;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.maxX - source.minX;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideY(AABB target, AABB source, double source_move) {
        if (source.minX - target.maxX < -1.0E-7 && source.maxX - target.minX > 1.0E-7 && source.minZ - target.maxZ < -1.0E-7 && source.maxZ - target.minZ > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.minY - source.maxY;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.maxY - source.minY;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideZ(AABB target, AABB source, double source_move) {
        if (source.minX - target.maxX < -1.0E-7 && source.maxX - target.minX > 1.0E-7 && source.minY - target.maxY < -1.0E-7 && source.maxY - target.minY > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.minZ - source.maxZ;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.maxZ - source.minZ;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static int findFloor(double[] values, double offset, double value, int startIndex, int endIndex) {
        Objects.checkFromToIndex(startIndex, endIndex + 1, values.length);
        do {
            int middle;
            double middleVal;
            if (value < (middleVal = values[middle = startIndex + endIndex >>> 1] + offset)) {
                endIndex = middle - 1;
                continue;
            }
            startIndex = middle + 1;
        } while (startIndex <= endIndex);
        return startIndex - 1;
    }

    private static VoxelShape sliceShapeVanilla(VoxelShape src, Direction.Axis axis, int index) {
        return new SliceShape(src, axis, index);
    }

    private static DoubleList offsetList(double[] src, double by) {
        DoubleArrayList wrap = DoubleArrayList.wrap((double[])src);
        if (by == 0.0) {
            return wrap;
        }
        return new OffsetDoubleList((DoubleList)wrap, by);
    }

    private static VoxelShape sliceShapeOptimised(VoxelShape src, Direction.Axis axis, int index) {
        int shape_ez;
        int shape_sz;
        int shape_ey;
        int shape_sy;
        int shape_ex;
        int shape_sx;
        DoubleList list_z;
        DoubleList list_y;
        DoubleArrayList list_x;
        double off_x = src.moonrise$offsetX();
        double off_y = src.moonrise$offsetY();
        double off_z = src.moonrise$offsetZ();
        double[] coords_x = src.moonrise$rootCoordinatesX();
        double[] coords_y = src.moonrise$rootCoordinatesY();
        double[] coords_z = src.moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = src.moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        long[] bitset = cached_shape_data.voxelSet();
        switch (axis) {
            case X: {
                if (index < 0 || index >= size_x) {
                    return Shapes.empty();
                }
                if (coords_x.length == 2 && coords_x[0] + off_x == 0.0 && coords_x[1] + off_x == 1.0) {
                    return src;
                }
                if (coords_y.length == 2 && coords_z.length == 2 && coords_y[0] + off_y == 0.0 && coords_y[1] + off_y == 1.0 && coords_z[0] + off_z == 0.0 && coords_z[1] + off_z == 1.0) {
                    int bitIdx = 0 + 0 * size_z + index * (size_z * size_y);
                    return (bitset[bitIdx >>> 6] & 1L << bitIdx) == 0L ? Shapes.empty() : Shapes.block();
                }
                list_x = ZERO_ONE;
                list_y = CollisionUtil.offsetList(coords_y, off_y);
                list_z = CollisionUtil.offsetList(coords_z, off_z);
                shape_sx = index;
                shape_ex = index + 1;
                shape_sy = 0;
                shape_ey = size_y;
                shape_sz = 0;
                shape_ez = size_z;
                break;
            }
            case Y: {
                if (index < 0 || index >= size_y) {
                    return Shapes.empty();
                }
                if (coords_y.length == 2 && coords_y[0] + off_y == 0.0 && coords_y[1] + off_y == 1.0) {
                    return src;
                }
                if (coords_x.length == 2 && coords_z.length == 2 && coords_x[0] + off_x == 0.0 && coords_x[1] + off_x == 1.0 && coords_z[0] + off_z == 0.0 && coords_z[1] + off_z == 1.0) {
                    int bitIdx = 0 + index * size_z + 0 * (size_z * size_y);
                    return (bitset[bitIdx >>> 6] & 1L << bitIdx) == 0L ? Shapes.empty() : Shapes.block();
                }
                list_x = CollisionUtil.offsetList(coords_x, off_x);
                list_y = ZERO_ONE;
                list_z = CollisionUtil.offsetList(coords_z, off_z);
                shape_sx = 0;
                shape_ex = size_x;
                shape_sy = index;
                shape_ey = index + 1;
                shape_sz = 0;
                shape_ez = size_z;
                break;
            }
            case Z: {
                if (index < 0 || index >= size_z) {
                    return Shapes.empty();
                }
                if (coords_z.length == 2 && coords_z[0] + off_z == 0.0 && coords_z[1] + off_z == 1.0) {
                    return src;
                }
                if (coords_x.length == 2 && coords_y.length == 2 && coords_x[0] + off_x == 0.0 && coords_x[1] + off_x == 1.0 && coords_y[0] + off_y == 0.0 && coords_y[1] + off_y == 1.0) {
                    int bitIdx = index + 0 * size_z + 0 * (size_z * size_y);
                    return (bitset[bitIdx >>> 6] & 1L << bitIdx) == 0L ? Shapes.empty() : Shapes.block();
                }
                list_x = CollisionUtil.offsetList(coords_x, off_x);
                list_y = CollisionUtil.offsetList(coords_y, off_y);
                list_z = ZERO_ONE;
                shape_sx = 0;
                shape_ex = size_x;
                shape_sy = 0;
                shape_ey = size_y;
                shape_sz = index;
                shape_ez = index + 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
            }
        }
        int local_len_x = shape_ex - shape_sx;
        int local_len_y = shape_ey - shape_sy;
        int local_len_z = shape_ez - shape_sz;
        BitSetDiscreteVoxelShape shape = new BitSetDiscreteVoxelShape(local_len_x, local_len_y, local_len_z);
        int bitset_mul_x = size_z * size_y;
        int idx_off = shape_sz + shape_sy * size_z + shape_sx * bitset_mul_x;
        int shape_mul_x = local_len_y * local_len_z;
        for (int x = 0; x < local_len_x; ++x) {
            boolean setX = false;
            for (int y = 0; y < local_len_y; ++y) {
                boolean setY = false;
                for (int z = 0; z < local_len_z; ++z) {
                    int unslicedIdx = idx_off + z + y * size_z + x * bitset_mul_x;
                    if ((bitset[unslicedIdx >>> 6] & 1L << unslicedIdx) == 0L) continue;
                    setY = true;
                    setX = true;
                    shape.zMin = Math.min(shape.zMin, z);
                    shape.zMax = Math.max(shape.zMax, z + 1);
                    shape.storage.set(z + y * local_len_z + x * shape_mul_x);
                }
                if (!setY) continue;
                shape.yMin = Math.min(shape.yMin, y);
                shape.yMax = Math.max(shape.yMax, y + 1);
            }
            if (!setX) continue;
            shape.xMin = Math.min(shape.xMin, x);
            shape.xMax = Math.max(shape.xMax, x + 1);
        }
        return shape.isEmpty() ? Shapes.empty() : new ArrayVoxelShape((DiscreteVoxelShape)shape, (DoubleList)list_x, list_y, list_z);
    }

    public static VoxelShape sliceShape(VoxelShape src, Direction.Axis axis, int index) {
        VoxelShape ret = CollisionUtil.sliceShapeOptimised(src, axis, index);
        return ret;
    }

    public static boolean voxelShapeIntersectNoEmpty(VoxelShape voxel, AABB aabb) {
        if (voxel.isEmpty()) {
            return false;
        }
        double off_x = voxel.moonrise$offsetX();
        double off_y = voxel.moonrise$offsetY();
        double off_z = voxel.moonrise$offsetZ();
        double[] coords_x = voxel.moonrise$rootCoordinatesX();
        double[] coords_y = voxel.moonrise$rootCoordinatesY();
        double[] coords_z = voxel.moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = voxel.moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, off_x, aabb.minX + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return false;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, off_x, aabb.maxX - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return false;
        }
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, off_y, aabb.minY + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return false;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, off_y, aabb.maxY - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return false;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, off_z, aabb.minZ + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return false;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, off_z, aabb.maxZ - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return false;
        }
        long[] bitset = cached_shape_data.voxelSet();
        int mul_x = size_y * size_z;
        for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
            for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double collideX(VoxelShape target, AABB source, double source_move) {
        AABB single_aabb = target.moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideX(single_aabb, source, source_move);
        }
        double off_x = target.moonrise$offsetX();
        double off_y = target.moonrise$offsetY();
        double off_z = target.moonrise$offsetZ();
        double[] coords_x = target.moonrise$rootCoordinatesX();
        double[] coords_y = target.moonrise$rootCoordinatesY();
        double[] coords_z = target.moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = target.moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, off_y, source.minY + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return source_move;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, off_y, source.maxY - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return source_move;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, off_z, source.minZ + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return source_move;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, off_z, source.maxZ - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.maxX;
            int ceil_max_x = CollisionUtil.findFloor(coords_x, off_x, source_max - 1.0E-7, 0, size_x) + 1;
            int mul_x = size_y * size_z;
            for (int curr_x = ceil_max_x; curr_x < size_x; ++curr_x) {
                double max_dist = coords_x[curr_x] + off_x - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                    for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.minX;
        int floor_min_x = CollisionUtil.findFloor(coords_x, off_x, source_min + 1.0E-7, 0, size_x);
        int mul_x = size_y * size_z;
        for (int curr_x = floor_min_x - 1; curr_x >= 0; --curr_x) {
            double max_dist = coords_x[curr_x + 1] + off_x - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static double collideY(VoxelShape target, AABB source, double source_move) {
        AABB single_aabb = target.moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideY(single_aabb, source, source_move);
        }
        double off_x = target.moonrise$offsetX();
        double off_y = target.moonrise$offsetY();
        double off_z = target.moonrise$offsetZ();
        double[] coords_x = target.moonrise$rootCoordinatesX();
        double[] coords_y = target.moonrise$rootCoordinatesY();
        double[] coords_z = target.moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = target.moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, off_x, source.minX + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return source_move;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, off_x, source.maxX - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return source_move;
        }
        int floor_min_z = Math.max(0, CollisionUtil.findFloor(coords_z, off_z, source.minZ + 1.0E-7, 0, size_z));
        if (floor_min_z >= size_z) {
            return source_move;
        }
        int ceil_max_z = Math.min(size_z, CollisionUtil.findFloor(coords_z, off_z, source.maxZ - 1.0E-7, floor_min_z, size_z) + 1);
        if (floor_min_z >= ceil_max_z) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.maxY;
            int ceil_max_y = CollisionUtil.findFloor(coords_y, off_y, source_max - 1.0E-7, 0, size_y) + 1;
            int mul_x = size_y * size_z;
            for (int curr_y = ceil_max_y; curr_y < size_y; ++curr_y) {
                double max_dist = coords_y[curr_y] + off_y - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                    for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.minY;
        int floor_min_y = CollisionUtil.findFloor(coords_y, off_y, source_min + 1.0E-7, 0, size_y);
        int mul_x = size_y * size_z;
        for (int curr_y = floor_min_y - 1; curr_y >= 0; --curr_y) {
            double max_dist = coords_y[curr_y + 1] + off_y - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                for (int curr_z = floor_min_z; curr_z < ceil_max_z; ++curr_z) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static double collideZ(VoxelShape target, AABB source, double source_move) {
        AABB single_aabb = target.moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return CollisionUtil.collideZ(single_aabb, source, source_move);
        }
        double off_x = target.moonrise$offsetX();
        double off_y = target.moonrise$offsetY();
        double off_z = target.moonrise$offsetZ();
        double[] coords_x = target.moonrise$rootCoordinatesX();
        double[] coords_y = target.moonrise$rootCoordinatesY();
        double[] coords_z = target.moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = target.moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int floor_min_x = Math.max(0, CollisionUtil.findFloor(coords_x, off_x, source.minX + 1.0E-7, 0, size_x));
        if (floor_min_x >= size_x) {
            return source_move;
        }
        int ceil_max_x = Math.min(size_x, CollisionUtil.findFloor(coords_x, off_x, source.maxX - 1.0E-7, floor_min_x, size_x) + 1);
        if (floor_min_x >= ceil_max_x) {
            return source_move;
        }
        int floor_min_y = Math.max(0, CollisionUtil.findFloor(coords_y, off_y, source.minY + 1.0E-7, 0, size_y));
        if (floor_min_y >= size_y) {
            return source_move;
        }
        int ceil_max_y = Math.min(size_y, CollisionUtil.findFloor(coords_y, off_y, source.maxY - 1.0E-7, floor_min_y, size_y) + 1);
        if (floor_min_y >= ceil_max_y) {
            return source_move;
        }
        long[] bitset = cached_shape_data.voxelSet();
        if (source_move > 0.0) {
            double source_max = source.maxZ;
            int ceil_max_z = CollisionUtil.findFloor(coords_z, off_z, source_max - 1.0E-7, 0, size_z) + 1;
            int mul_x = size_y * size_z;
            for (int curr_z = ceil_max_z; curr_z < size_z; ++curr_z) {
                double max_dist = coords_z[curr_z] + off_z - source_max;
                if (max_dist >= source_move) {
                    return source_move;
                }
                if (max_dist >= -1.0E-7) {
                    max_dist = Math.min(max_dist, source_move);
                }
                for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                    for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                        int index = curr_z + curr_y * size_z + curr_x * mul_x;
                        if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                        return max_dist;
                    }
                }
            }
            return source_move;
        }
        double source_min = source.minZ;
        int floor_min_z = CollisionUtil.findFloor(coords_z, off_z, source_min + 1.0E-7, 0, size_z);
        int mul_x = size_y * size_z;
        for (int curr_z = floor_min_z - 1; curr_z >= 0; --curr_z) {
            double max_dist = coords_z[curr_z + 1] + off_z - source_min;
            if (max_dist <= source_move) {
                return source_move;
            }
            if (max_dist <= 1.0E-7) {
                max_dist = Math.max(max_dist, source_move);
            }
            for (int curr_x = floor_min_x; curr_x < ceil_max_x; ++curr_x) {
                for (int curr_y = floor_min_y; curr_y < ceil_max_y; ++curr_y) {
                    int index = curr_z + curr_y * size_z + curr_x * mul_x;
                    if ((bitset[index >>> 6] & 1L << index) == 0L) continue;
                    return max_dist;
                }
            }
        }
        return source_move;
    }

    public static boolean strictlyContains(VoxelShape voxel, Vec3 point) {
        return CollisionUtil.strictlyContains(voxel, point.x, point.y, point.z);
    }

    public static boolean strictlyContains(VoxelShape voxel, double x, double y, double z) {
        AABB single_aabb = voxel.moonrise$getSingleAABBRepresentation();
        if (single_aabb != null) {
            return single_aabb.contains(x, y, z);
        }
        if (voxel.isEmpty()) {
            return false;
        }
        double off_x = voxel.moonrise$offsetX();
        double off_y = voxel.moonrise$offsetY();
        double off_z = voxel.moonrise$offsetZ();
        double[] coords_x = voxel.moonrise$rootCoordinatesX();
        double[] coords_y = voxel.moonrise$rootCoordinatesY();
        double[] coords_z = voxel.moonrise$rootCoordinatesZ();
        CachedShapeData cached_shape_data = voxel.moonrise$getCachedVoxelData();
        int size_x = cached_shape_data.sizeX();
        int size_y = cached_shape_data.sizeY();
        int size_z = cached_shape_data.sizeZ();
        int index_x = CollisionUtil.findFloor(coords_x, off_x, x, 0, size_x);
        if (index_x < 0 || index_x >= size_x) {
            return false;
        }
        int index_y = CollisionUtil.findFloor(coords_y, off_y, y, 0, size_y);
        if (index_y < 0 || index_y >= size_y) {
            return false;
        }
        int index_z = CollisionUtil.findFloor(coords_z, off_z, z, 0, size_z);
        if (index_z < 0 || index_z >= size_z) {
            return false;
        }
        int index = index_z + index_y * size_z + index_x * (size_z * size_y);
        long[] bitset = cached_shape_data.voxelSet();
        return (bitset[index >>> 6] & 1L << index) != 0L;
    }

    private static int makeBitset(boolean ft, boolean tf, boolean tt) {
        return (ft ? 1 : 0) << 1 | (tf ? 1 : 0) << 2 | (tt ? 1 : 0) << 3;
    }

    private static BitSetDiscreteVoxelShape merge(CachedShapeData shapeDataFirst, CachedShapeData shapeDataSecond, MergedVoxelCoordinateList mergedX, MergedVoxelCoordinateList mergedY, MergedVoxelCoordinateList mergedZ, int booleanOp) {
        int sizeX = mergedX.voxels;
        int sizeY = mergedY.voxels;
        int sizeZ = mergedZ.voxels;
        long[] s1Voxels = shapeDataFirst.voxelSet();
        long[] s2Voxels = shapeDataSecond.voxelSet();
        int s1Mul1 = shapeDataFirst.sizeZ();
        int s1Mul2 = s1Mul1 * shapeDataFirst.sizeY();
        int s2Mul1 = shapeDataSecond.sizeZ();
        int s2Mul2 = s2Mul1 * shapeDataSecond.sizeY();
        BitSetDiscreteVoxelShape ret = new BitSetDiscreteVoxelShape(sizeX, sizeY, sizeZ);
        boolean empty = true;
        int mergedIdx = 0;
        for (int idxX = 0; idxX < sizeX; ++idxX) {
            int s1x = mergedX.firstIndices[idxX];
            int s2x = mergedX.secondIndices[idxX];
            boolean setX = false;
            for (int idxY = 0; idxY < sizeY; ++idxY) {
                int s1y = mergedY.firstIndices[idxY];
                int s2y = mergedY.secondIndices[idxY];
                boolean setY = false;
                for (int idxZ = 0; idxZ < sizeZ; ++idxZ) {
                    int n;
                    int isS1Full;
                    int s1z = mergedZ.firstIndices[idxZ];
                    int s2z = mergedZ.secondIndices[idxZ];
                    if ((s1x | s1y | s1z) < 0) {
                        v0 = 0;
                    } else {
                        int idx1 = s1z + s1y * s1Mul1 + s1x * s1Mul2;
                        v0 = isS1Full = (int)(s1Voxels[idx1 >>> 6] >>> idx1 & 1L);
                    }
                    if ((s2x | s2y | s2z) < 0) {
                        n = 0;
                    } else {
                        int idx2 = s2z + s2y * s2Mul1 + s2x * s2Mul2;
                        n = (int)(s2Voxels[idx2 >>> 6] >>> idx2 & 1L);
                    }
                    int isS2Full = n;
                    boolean res = (booleanOp & 1 << (isS2Full | isS1Full << 1)) != 0;
                    setY |= res;
                    setX |= res;
                    if (res) {
                        empty = false;
                        ret.zMin = Math.min(ret.zMin, idxZ);
                        ret.zMax = Math.max(ret.zMax, idxZ + 1);
                        ret.storage.set(mergedIdx);
                    }
                    ++mergedIdx;
                }
                if (!setY) continue;
                ret.yMin = Math.min(ret.yMin, idxY);
                ret.yMax = Math.max(ret.yMax, idxY + 1);
            }
            if (!setX) continue;
            ret.xMin = Math.min(ret.xMin, idxX);
            ret.xMax = Math.max(ret.xMax, idxX + 1);
        }
        return empty ? null : ret;
    }

    private static boolean isMergeEmpty(CachedShapeData shapeDataFirst, CachedShapeData shapeDataSecond, MergedVoxelCoordinateList mergedX, MergedVoxelCoordinateList mergedY, MergedVoxelCoordinateList mergedZ, int booleanOp) {
        int sizeX = mergedX.voxels;
        int sizeY = mergedY.voxels;
        int sizeZ = mergedZ.voxels;
        long[] s1Voxels = shapeDataFirst.voxelSet();
        long[] s2Voxels = shapeDataSecond.voxelSet();
        int s1Mul1 = shapeDataFirst.sizeZ();
        int s1Mul2 = s1Mul1 * shapeDataFirst.sizeY();
        int s2Mul1 = shapeDataSecond.sizeZ();
        int s2Mul2 = s2Mul1 * shapeDataSecond.sizeY();
        for (int idxX = 0; idxX < sizeX; ++idxX) {
            int s1x = mergedX.firstIndices[idxX];
            int s2x = mergedX.secondIndices[idxX];
            for (int idxY = 0; idxY < sizeY; ++idxY) {
                int s1y = mergedY.firstIndices[idxY];
                int s2y = mergedY.secondIndices[idxY];
                for (int idxZ = 0; idxZ < sizeZ; ++idxZ) {
                    boolean res;
                    int n;
                    int isS1Full;
                    int s1z = mergedZ.firstIndices[idxZ];
                    int s2z = mergedZ.secondIndices[idxZ];
                    if ((s1x | s1y | s1z) < 0) {
                        v0 = 0;
                    } else {
                        int idx1 = s1z + s1y * s1Mul1 + s1x * s1Mul2;
                        v0 = isS1Full = (int)(s1Voxels[idx1 >>> 6] >>> idx1 & 1L);
                    }
                    if ((s2x | s2y | s2z) < 0) {
                        n = 0;
                    } else {
                        int idx2 = s2z + s2y * s2Mul1 + s2x * s2Mul2;
                        n = (int)(s2Voxels[idx2 >>> 6] >>> idx2 & 1L);
                    }
                    int isS2Full = n;
                    boolean bl = res = (booleanOp & 1 << (isS2Full | isS1Full << 1)) != 0;
                    if (!res) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static VoxelShape joinOptimized(VoxelShape first, VoxelShape second, BooleanOp operator) {
        return CollisionUtil.joinUnoptimized(first, second, operator).optimize();
    }

    public static VoxelShape joinUnoptimized(VoxelShape first, VoxelShape second, BooleanOp operator) {
        CachedShapeData shapeDataSecond;
        MergedVoxelCoordinateList mergedX;
        boolean ff = operator.apply(false, false);
        if (ff) {
            throw new UnsupportedOperationException("Ambiguous operator: (false, false) -> true");
        }
        boolean tt = operator.apply(true, true);
        if (first == second) {
            return tt ? first : Shapes.empty();
        }
        boolean ft = operator.apply(false, true);
        boolean tf = operator.apply(true, false);
        if (first.isEmpty()) {
            return ft ? second : Shapes.empty();
        }
        if (second.isEmpty()) {
            return tf ? first : Shapes.empty();
        }
        if (!tt) {
            boolean hasAABBS;
            AABB aabbF = first.moonrise$getSingleAABBRepresentation();
            AABB aabbS = second.moonrise$getSingleAABBRepresentation();
            boolean hasAABBF = aabbF != null;
            boolean bl = hasAABBS = aabbS != null;
            boolean intersect = hasAABBF | hasAABBS ? (hasAABBF & hasAABBS ? CollisionUtil.voxelShapeIntersect(aabbF, aabbS) : (hasAABBF ? CollisionUtil.voxelShapeIntersectNoEmpty(second, aabbF) : CollisionUtil.voxelShapeIntersectNoEmpty(first, aabbS))) : CollisionUtil.voxelShapeIntersect(first.bounds(), second.bounds());
            if (!intersect) {
                if (!tf & !ft) {
                    return Shapes.empty();
                }
                if (!tf | !ft) {
                    return tf ? first : second;
                }
            }
        }
        if ((mergedX = MergedVoxelCoordinateList.merge(first.moonrise$rootCoordinatesX(), first.moonrise$offsetX(), second.moonrise$rootCoordinatesX(), second.moonrise$offsetX(), ft, tf)) == null) {
            return Shapes.empty();
        }
        MergedVoxelCoordinateList mergedY = MergedVoxelCoordinateList.merge(first.moonrise$rootCoordinatesY(), first.moonrise$offsetY(), second.moonrise$rootCoordinatesY(), second.moonrise$offsetY(), ft, tf);
        if (mergedY == null) {
            return Shapes.empty();
        }
        MergedVoxelCoordinateList mergedZ = MergedVoxelCoordinateList.merge(first.moonrise$rootCoordinatesZ(), first.moonrise$offsetZ(), second.moonrise$rootCoordinatesZ(), second.moonrise$offsetZ(), ft, tf);
        if (mergedZ == null) {
            return Shapes.empty();
        }
        CachedShapeData shapeDataFirst = first.moonrise$getCachedVoxelData();
        BitSetDiscreteVoxelShape mergedShape = CollisionUtil.merge(shapeDataFirst, shapeDataSecond = second.moonrise$getCachedVoxelData(), mergedX, mergedY, mergedZ, CollisionUtil.makeBitset(ft, tf, tt));
        if (mergedShape == null) {
            return Shapes.empty();
        }
        return new ArrayVoxelShape((DiscreteVoxelShape)mergedShape, mergedX.wrapCoords(), mergedY.wrapCoords(), mergedZ.wrapCoords());
    }

    public static boolean isJoinNonEmpty(VoxelShape first, VoxelShape second, BooleanOp operator) {
        CachedShapeData shapeDataSecond;
        MergedVoxelCoordinateList mergedX;
        boolean hasAABBS;
        boolean secondEmpty;
        boolean ff = operator.apply(false, false);
        if (ff) {
            throw new UnsupportedOperationException("Ambiguous operator: (false, false) -> true");
        }
        boolean firstEmpty = first.isEmpty();
        if (firstEmpty | (secondEmpty = second.isEmpty())) {
            return operator.apply(!firstEmpty, !secondEmpty);
        }
        boolean tt = operator.apply(true, true);
        if (first == second) {
            return tt;
        }
        boolean ft = operator.apply(false, true);
        boolean tf = operator.apply(true, false);
        AABB aabbF = first.moonrise$getSingleAABBRepresentation();
        AABB aabbS = second.moonrise$getSingleAABBRepresentation();
        boolean hasAABBF = aabbF != null;
        boolean bl = hasAABBS = aabbS != null;
        if (hasAABBF | hasAABBS) {
            boolean intersect = hasAABBF & hasAABBS ? CollisionUtil.voxelShapeIntersect(aabbF, aabbS) : (hasAABBF ? CollisionUtil.voxelShapeIntersectNoEmpty(second, aabbF) : CollisionUtil.voxelShapeIntersectNoEmpty(first, aabbS));
            if (!intersect) {
                return tf | ft;
            }
            if (tt) {
                return true;
            }
        } else {
            boolean intersect = CollisionUtil.voxelShapeIntersect(first.bounds(), second.bounds());
            if (!intersect) {
                return tf | ft;
            }
        }
        if ((mergedX = MergedVoxelCoordinateList.merge(first.moonrise$rootCoordinatesX(), first.moonrise$offsetX(), second.moonrise$rootCoordinatesX(), second.moonrise$offsetX(), ft, tf)) == null) {
            return false;
        }
        MergedVoxelCoordinateList mergedY = MergedVoxelCoordinateList.merge(first.moonrise$rootCoordinatesY(), first.moonrise$offsetY(), second.moonrise$rootCoordinatesY(), second.moonrise$offsetY(), ft, tf);
        if (mergedY == null) {
            return false;
        }
        MergedVoxelCoordinateList mergedZ = MergedVoxelCoordinateList.merge(first.moonrise$rootCoordinatesZ(), first.moonrise$offsetZ(), second.moonrise$rootCoordinatesZ(), second.moonrise$offsetZ(), ft, tf);
        if (mergedZ == null) {
            return false;
        }
        CachedShapeData shapeDataFirst = first.moonrise$getCachedVoxelData();
        return !CollisionUtil.isMergeEmpty(shapeDataFirst, shapeDataSecond = second.moonrise$getCachedVoxelData(), mergedX, mergedY, mergedZ, CollisionUtil.makeBitset(ft, tf, tt));
    }

    public static boolean equals(DiscreteVoxelShape shape1, DiscreteVoxelShape shape2) {
        boolean isEmpty2;
        CachedShapeData cachedShapeData1 = shape1.moonrise$getOrCreateCachedShapeData();
        CachedShapeData cachedShapeData2 = shape2.moonrise$getOrCreateCachedShapeData();
        boolean isEmpty1 = cachedShapeData1.isEmpty();
        if (isEmpty1 & (isEmpty2 = cachedShapeData2.isEmpty())) {
            return true;
        }
        if (isEmpty1 ^ isEmpty2) {
            return false;
        }
        if (cachedShapeData1.hasSingleAABB() != cachedShapeData2.hasSingleAABB()) {
            return false;
        }
        if (cachedShapeData1.sizeX() != cachedShapeData2.sizeX()) {
            return false;
        }
        if (cachedShapeData1.sizeY() != cachedShapeData2.sizeY()) {
            return false;
        }
        if (cachedShapeData1.sizeZ() != cachedShapeData2.sizeZ()) {
            return false;
        }
        return Arrays.equals(cachedShapeData1.voxelSet(), cachedShapeData2.voxelSet());
    }

    public static boolean equals(VoxelShape shape1, VoxelShape shape2) {
        if (shape1.isEmpty() & shape2.isEmpty()) {
            return true;
        }
        if (shape1.isEmpty() ^ shape2.isEmpty()) {
            return false;
        }
        if (!CollisionUtil.equals(shape1.shape, shape2.shape)) {
            return false;
        }
        return shape1.getCoords(Direction.Axis.X).equals((Object)shape2.getCoords(Direction.Axis.X)) && shape1.getCoords(Direction.Axis.Y).equals((Object)shape2.getCoords(Direction.Axis.Y)) && shape1.getCoords(Direction.Axis.Z).equals((Object)shape2.getCoords(Direction.Axis.Z));
    }

    public static boolean areAnyFull(DiscreteVoxelShape shape) {
        if (shape.isEmpty()) {
            return false;
        }
        int sizeX = shape.getXSize();
        int sizeY = shape.getYSize();
        int sizeZ = shape.getZSize();
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    if (!shape.isFull(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String shapeMismatch(DiscreteVoxelShape shape1, DiscreteVoxelShape shape2) {
        boolean isEmpty2;
        CachedShapeData cachedShapeData1 = shape1.moonrise$getOrCreateCachedShapeData();
        CachedShapeData cachedShapeData2 = shape2.moonrise$getOrCreateCachedShapeData();
        boolean isEmpty1 = cachedShapeData1.isEmpty();
        if (isEmpty1 & (isEmpty2 = cachedShapeData2.isEmpty())) {
            return null;
        }
        if (isEmpty1 ^ isEmpty2) {
            return null;
        }
        if (cachedShapeData1.sizeX() != cachedShapeData2.sizeX()) {
            return "size x: " + cachedShapeData1.sizeX() + " != " + cachedShapeData2.sizeX();
        }
        if (cachedShapeData1.sizeY() != cachedShapeData2.sizeY()) {
            return "size y: " + cachedShapeData1.sizeY() + " != " + cachedShapeData2.sizeY();
        }
        if (cachedShapeData1.sizeZ() != cachedShapeData2.sizeZ()) {
            return "size z: " + cachedShapeData1.sizeZ() + " != " + cachedShapeData2.sizeZ();
        }
        StringBuilder ret = new StringBuilder();
        int sizeX = cachedShapeData1.sizeX();
        int sizeY = cachedShapeData1.sizeY();
        int sizeZ = cachedShapeData1.sizeZ();
        boolean first = true;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    boolean isFull2;
                    boolean isFull1 = shape1.isFull(x, y, z);
                    if (isFull1 == (isFull2 = shape2.isFull(x, y, z))) continue;
                    if (first) {
                        first = false;
                    } else {
                        ret.append(", ");
                    }
                    ret.append("(").append(x).append(",").append(y).append(",").append(z).append("): shape1: ").append(isFull1).append(", shape2: ").append(isFull2);
                }
            }
        }
        return ret.isEmpty() ? null : ret.toString();
    }

    public static AABB offsetX(AABB box, double dx) {
        return new AABB(box.minX + dx, box.minY, box.minZ, box.maxX + dx, box.maxY, box.maxZ);
    }

    public static AABB offsetY(AABB box, double dy) {
        return new AABB(box.minX, box.minY + dy, box.minZ, box.maxX, box.maxY + dy, box.maxZ);
    }

    public static AABB offsetZ(AABB box, double dz) {
        return new AABB(box.minX, box.minY, box.minZ + dz, box.maxX, box.maxY, box.maxZ + dz);
    }

    public static AABB expandRight(AABB box, double dx) {
        return new AABB(box.minX, box.minY, box.minZ, box.maxX + dx, box.maxY, box.maxZ);
    }

    public static AABB expandLeft(AABB box, double dx) {
        return new AABB(box.minX - dx, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public static AABB expandUpwards(AABB box, double dy) {
        return new AABB(box.minX, box.minY, box.minZ, box.maxX, box.maxY + dy, box.maxZ);
    }

    public static AABB expandDownwards(AABB box, double dy) {
        return new AABB(box.minX, box.minY - dy, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public static AABB expandForwards(AABB box, double dz) {
        return new AABB(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ + dz);
    }

    public static AABB expandBackwards(AABB box, double dz) {
        return new AABB(box.minX, box.minY, box.minZ - dz, box.maxX, box.maxY, box.maxZ);
    }

    public static AABB cutRight(AABB box, double dx) {
        return new AABB(box.maxX, box.minY, box.minZ, box.maxX + dx, box.maxY, box.maxZ);
    }

    public static AABB cutLeft(AABB box, double dx) {
        return new AABB(box.minX + dx, box.minY, box.minZ, box.minX, box.maxY, box.maxZ);
    }

    public static AABB cutUpwards(AABB box, double dy) {
        return new AABB(box.minX, box.maxY, box.minZ, box.maxX, box.maxY + dy, box.maxZ);
    }

    public static AABB cutDownwards(AABB box, double dy) {
        return new AABB(box.minX, box.minY + dy, box.minZ, box.maxX, box.minY, box.maxZ);
    }

    public static AABB cutForwards(AABB box, double dz) {
        return new AABB(box.minX, box.minY, box.maxZ, box.maxX, box.maxY, box.maxZ + dz);
    }

    public static AABB cutBackwards(AABB box, double dz) {
        return new AABB(box.minX, box.minY, box.minZ + dz, box.maxX, box.maxY, box.minZ);
    }

    public static double performAABBCollisionsX(AABB currentBoundingBox, double value, List<AABB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            AABB target = potentialCollisions.get(i);
            value = CollisionUtil.collideX(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performAABBCollisionsY(AABB currentBoundingBox, double value, List<AABB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            AABB target = potentialCollisions.get(i);
            value = CollisionUtil.collideY(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performAABBCollisionsZ(AABB currentBoundingBox, double value, List<AABB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            AABB target = potentialCollisions.get(i);
            value = CollisionUtil.collideZ(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsX(AABB currentBoundingBox, double value, List<VoxelShape> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            VoxelShape target = potentialCollisions.get(i);
            value = CollisionUtil.collideX(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsY(AABB currentBoundingBox, double value, List<VoxelShape> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            VoxelShape target = potentialCollisions.get(i);
            value = CollisionUtil.collideY(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performVoxelCollisionsZ(AABB currentBoundingBox, double value, List<VoxelShape> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i = 0; i < len; ++i) {
            VoxelShape target = potentialCollisions.get(i);
            value = CollisionUtil.collideZ(target, currentBoundingBox, value);
        }
        return value;
    }

    public static Vec3 performVoxelCollisions(Vec3 moveVector, AABB axisalignedbb, List<VoxelShape> potentialCollisions) {
        boolean xSmaller;
        double x = moveVector.x;
        double y = moveVector.y;
        double z = moveVector.z;
        if (y != 0.0 && (y = CollisionUtil.performVoxelCollisionsY(axisalignedbb, y, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y);
        }
        boolean bl = xSmaller = Math.abs(x) < Math.abs(z);
        if (xSmaller && z != 0.0 && (z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z);
        }
        if (x != 0.0) {
            x = CollisionUtil.performVoxelCollisionsX(axisalignedbb, x, potentialCollisions);
            if (!xSmaller && x != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x);
            }
        }
        if (!xSmaller && z != 0.0) {
            z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, potentialCollisions);
        }
        return new Vec3(x, y, z);
    }

    public static Vec3 performAABBCollisions(Vec3 moveVector, AABB axisalignedbb, List<AABB> potentialCollisions) {
        boolean xSmaller;
        double x = moveVector.x;
        double y = moveVector.y;
        double z = moveVector.z;
        if (y != 0.0 && (y = CollisionUtil.performAABBCollisionsY(axisalignedbb, y, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y);
        }
        boolean bl = xSmaller = Math.abs(x) < Math.abs(z);
        if (xSmaller && z != 0.0 && (z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z);
        }
        if (x != 0.0) {
            x = CollisionUtil.performAABBCollisionsX(axisalignedbb, x, potentialCollisions);
            if (!xSmaller && x != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x);
            }
        }
        if (!xSmaller && z != 0.0) {
            z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, potentialCollisions);
        }
        return new Vec3(x, y, z);
    }

    public static Vec3 performCollisions(Vec3 moveVector, AABB axisalignedbb, List<VoxelShape> voxels, List<AABB> aabbs) {
        boolean xSmaller;
        if (voxels.isEmpty()) {
            return CollisionUtil.performAABBCollisions(moveVector, axisalignedbb, aabbs);
        }
        double x = moveVector.x;
        double y = moveVector.y;
        double z = moveVector.z;
        if (y != 0.0) {
            y = CollisionUtil.performAABBCollisionsY(axisalignedbb, y, aabbs);
            if ((y = CollisionUtil.performVoxelCollisionsY(axisalignedbb, y, voxels)) != 0.0) {
                axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y);
            }
        }
        boolean bl = xSmaller = Math.abs(x) < Math.abs(z);
        if (xSmaller && z != 0.0) {
            z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, aabbs);
            if ((z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, voxels)) != 0.0) {
                axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z);
            }
        }
        if (x != 0.0) {
            x = CollisionUtil.performAABBCollisionsX(axisalignedbb, x, aabbs);
            x = CollisionUtil.performVoxelCollisionsX(axisalignedbb, x, voxels);
            if (!xSmaller && x != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x);
            }
        }
        if (!xSmaller && z != 0.0) {
            z = CollisionUtil.performAABBCollisionsZ(axisalignedbb, z, aabbs);
            z = CollisionUtil.performVoxelCollisionsZ(axisalignedbb, z, voxels);
        }
        return new Vec3(x, y, z);
    }

    public static boolean isCollidingWithBorder(WorldBorder worldborder, AABB boundingBox) {
        return CollisionUtil.isCollidingWithBorder(worldborder, boundingBox.minX, boundingBox.maxX, boundingBox.minZ, boundingBox.maxZ);
    }

    public static boolean isCollidingWithBorder(WorldBorder worldborder, double boxMinX, double boxMaxX, double boxMinZ, double boxMaxZ) {
        double borderMinX = Math.floor(worldborder.getMinX());
        double borderMaxX = Math.ceil(worldborder.getMaxX());
        double borderMinZ = Math.floor(worldborder.getMinZ());
        double borderMaxZ = Math.ceil(worldborder.getMaxZ());
        return borderMinX - boxMinX > 1.0E-7 || borderMaxX - boxMaxX < -1.0E-7 || borderMinZ - boxMinZ > 1.0E-7 || borderMaxZ - boxMaxZ < -1.0E-7;
    }

    private static double min(double x, double y) {
        return x < y ? x : y;
    }

    private static double max(double x, double y) {
        return x > y ? x : y;
    }

    public static boolean getCollisionsForBlocksOrWorldBorder(Level world, Entity entity, AABB aabb, List<VoxelShape> intoVoxel, List<AABB> intoAABB, int collisionFlags, BiPredicate<BlockState, BlockPos> predicate) {
        WorldBorder worldBorder;
        boolean checkOnly = (collisionFlags & 8) != 0;
        boolean ret = false;
        if ((collisionFlags & 4) != 0 && CollisionUtil.isCollidingWithBorder(worldBorder = world.getWorldBorder(), aabb) && entity != null && worldBorder.isInsideCloseToBorder(entity, aabb)) {
            if (checkOnly) {
                return true;
            }
            VoxelShape borderShape = worldBorder.getCollisionShape();
            intoVoxel.add(borderShape);
            ret = true;
        }
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = Mth.floor(aabb.minX - 1.0E-7) - 1;
        int maxBlockX = Mth.floor(aabb.maxX + 1.0E-7) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, Mth.floor(aabb.minY - 1.0E-7) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection(world) << 4) + 16, Mth.floor(aabb.maxY + 1.0E-7) + 1);
        int minBlockZ = Mth.floor(aabb.minZ - 1.0E-7) - 1;
        int maxBlockZ = Mth.floor(aabb.maxZ + 1.0E-7) + 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        LazyEntityCollisionContext collisionShape = new LazyEntityCollisionContext(entity);
        boolean useEntityCollisionShape = LazyEntityCollisionContext.useEntityCollisionShape(world, entity);
        if (minBlockY > maxBlockY) {
            return ret;
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        boolean loadChunks = (collisionFlags & 1) != 0;
        ChunkSource chunkSource = world.getChunkSource();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkAccess chunk = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, loadChunks);
                if (chunk == null) {
                    if ((collisionFlags & 2) == 0) continue;
                    if (checkOnly) {
                        return true;
                    }
                    intoAABB.add(CollisionUtil.getBoxForChunk(currChunkX, currChunkZ));
                    ret = true;
                    continue;
                }
                LevelChunkSection[] sections = chunk.getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    boolean hasSpecial = section.moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    PalettedContainer<BlockState> blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape blockCollisionOffset;
                                BlockState blockData;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                int n = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (blockData = blocks.get(localBlockIndex)).moonrise$emptyContextCollisionShape()) continue;
                                VoxelShape blockCollision = blockData.moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.hasLargeCollisionShape() || edgeCount == 2 && blockData.getBlock() != Blocks.MOVING_PISTON)) continue;
                                mutablePos.set(blockX, blockY, blockZ);
                                if (useEntityCollisionShape) {
                                    blockCollision = collisionShape.getCollisionShape(blockData, world, mutablePos);
                                } else if (blockCollision == null) {
                                    blockCollision = blockData.getCollisionShape(world, mutablePos, collisionShape);
                                }
                                AABB singleAABB = blockCollision.moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(aabb, singleAABB = singleAABB.move(blockX, blockY, blockZ)) || predicate != null && !predicate.test(blockData, mutablePos)) continue;
                                    if (checkOnly) {
                                        return true;
                                    }
                                    ret = true;
                                    intoAABB.add(singleAABB);
                                    continue;
                                }
                                if (blockCollision.isEmpty() || !CollisionUtil.voxelShapeIntersectNoEmpty(blockCollisionOffset = blockCollision.move(blockX, blockY, blockZ), aabb) || predicate != null && !predicate.test(blockData, mutablePos)) continue;
                                if (checkOnly) {
                                    return true;
                                }
                                ret = true;
                                intoVoxel.add(blockCollisionOffset);
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    public static boolean getEntityHardCollisions(Level world, Entity entity, AABB aabb, List<AABB> into, int collisionFlags, Predicate<Entity> predicate) {
        boolean checkOnly = (collisionFlags & 8) != 0;
        boolean ret = false;
        aabb = aabb.inflate(-1.0E-7, -1.0E-7, -1.0E-7);
        List<Entity> entities = entity != null && entity.moonrise$isHardColliding() ? world.getEntities(entity, aabb, predicate) : world.moonrise$getHardCollidingEntities(entity, aabb, predicate);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            Entity otherEntity = entities.get(i);
            if (otherEntity.isSpectator() || (entity != null || !otherEntity.canBeCollidedWith()) && (entity == null || !entity.canCollideWith(otherEntity))) continue;
            if (checkOnly) {
                return true;
            }
            into.add(otherEntity.getBoundingBox());
            ret = true;
        }
        return ret;
    }

    public static boolean getCollisions(Level world, Entity entity, AABB aabb, List<VoxelShape> intoVoxel, List<AABB> intoAABB, int collisionFlags, BiPredicate<BlockState, BlockPos> blockPredicate, Predicate<Entity> entityPredicate) {
        if ((collisionFlags & 8) != 0) {
            return CollisionUtil.getCollisionsForBlocksOrWorldBorder(world, entity, aabb, intoVoxel, intoAABB, collisionFlags, blockPredicate) || CollisionUtil.getEntityHardCollisions(world, entity, aabb, intoAABB, collisionFlags, entityPredicate);
        }
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(world, entity, aabb, intoVoxel, intoAABB, collisionFlags, blockPredicate) | CollisionUtil.getEntityHardCollisions(world, entity, aabb, intoAABB, collisionFlags, entityPredicate);
    }

    private CollisionUtil() {
        throw new RuntimeException();
    }

    private static final class MergedVoxelCoordinateList {
        private static final int[][] SIMPLE_INDICES_CACHE = new int[64][];
        public final double[] coordinates;
        public final double coordinateOffset;
        public final int[] firstIndices;
        public final int[] secondIndices;
        public final int voxels;

        private static int[] getIndices(int length) {
            int[] ret = new int[length];
            for (int i = 1; i < length; ++i) {
                ret[i] = i;
            }
            return ret;
        }

        private MergedVoxelCoordinateList(double[] coordinates, double coordinateOffset, int[] firstIndices, int[] secondIndices, int voxels) {
            this.coordinates = coordinates;
            this.coordinateOffset = coordinateOffset;
            this.firstIndices = firstIndices;
            this.secondIndices = secondIndices;
            this.voxels = voxels;
        }

        public DoubleList wrapCoords() {
            if (this.coordinateOffset == 0.0) {
                return DoubleArrayList.wrap((double[])this.coordinates, (int)(this.voxels + 1));
            }
            return new OffsetDoubleList((DoubleList)DoubleArrayList.wrap((double[])this.coordinates, (int)(this.voxels + 1)), this.coordinateOffset);
        }

        public static MergedVoxelCoordinateList getForSingle(double[] coordinates, double offset) {
            int voxels = coordinates.length - 1;
            int[] indices = voxels < SIMPLE_INDICES_CACHE.length ? SIMPLE_INDICES_CACHE[voxels] : MergedVoxelCoordinateList.getIndices(voxels);
            return new MergedVoxelCoordinateList(coordinates, offset, indices, indices, voxels);
        }

        public static MergedVoxelCoordinateList merge(double[] firstCoordinates, double firstOffset, double[] secondCoordinates, double secondOffset, boolean ft, boolean tf) {
            if (firstCoordinates == secondCoordinates && firstOffset == secondOffset) {
                return MergedVoxelCoordinateList.getForSingle(firstCoordinates, firstOffset);
            }
            int firstCount = firstCoordinates.length;
            int secondCount = secondCoordinates.length;
            int voxelsFirst = firstCount - 1;
            int voxelsSecond = secondCount - 1;
            int maxCount = firstCount + secondCount;
            double[] coordinates = new double[maxCount];
            int[] firstIndices = new int[maxCount];
            int[] secondIndices = new int[maxCount];
            boolean notTF = !tf;
            boolean notFT = !ft;
            int firstIndex = 0;
            int secondIndex = 0;
            int resultSize = 0;
            double last = Double.NaN;
            while (true) {
                double select;
                boolean secondZero;
                boolean noneLeftSecond;
                boolean noneLeftFirst = firstIndex >= firstCount;
                boolean bl = noneLeftSecond = secondIndex >= secondCount;
                if (noneLeftFirst & noneLeftSecond | noneLeftSecond & notTF | noneLeftFirst & notFT) break;
                boolean firstZero = firstIndex == 0;
                boolean bl2 = secondZero = secondIndex == 0;
                if (noneLeftFirst) {
                    select = secondCoordinates[secondIndex] + secondOffset;
                    ++secondIndex;
                } else if (noneLeftSecond) {
                    select = firstCoordinates[firstIndex] + firstOffset;
                    ++firstIndex;
                } else {
                    boolean breakFirst = notTF & secondZero;
                    boolean breakSecond = notFT & firstZero;
                    double first = firstCoordinates[firstIndex] + firstOffset;
                    double second = secondCoordinates[secondIndex] + secondOffset;
                    boolean useFirst = first < second + 1.0E-7;
                    boolean cont = useFirst & breakFirst | !useFirst & breakSecond;
                    select = useFirst ? first : second;
                    firstIndex += useFirst ? 1 : 0;
                    secondIndex += 1 ^ (useFirst ? 1 : 0);
                    if (cont) continue;
                }
                int prevFirst = firstIndex - 1;
                prevFirst = prevFirst >= voxelsFirst ? -1 : prevFirst;
                int prevSecond = secondIndex - 1;
                int n = prevSecond = prevSecond >= voxelsSecond ? -1 : prevSecond;
                if (last >= select - 1.0E-7) {
                    firstIndices[resultSize - 1] = prevFirst;
                    secondIndices[resultSize - 1] = prevSecond;
                    continue;
                }
                firstIndices[resultSize] = prevFirst;
                secondIndices[resultSize] = prevSecond;
                coordinates[resultSize] = select;
                ++resultSize;
                last = select;
            }
            return resultSize <= 1 ? null : new MergedVoxelCoordinateList(coordinates, 0.0, firstIndices, secondIndices, resultSize - 1);
        }

        static {
            for (int i = 0; i < SIMPLE_INDICES_CACHE.length; ++i) {
                MergedVoxelCoordinateList.SIMPLE_INDICES_CACHE[i] = MergedVoxelCoordinateList.getIndices(i);
            }
        }
    }

    public static final class LazyEntityCollisionContext
    extends EntityCollisionContext {
        private CollisionContext delegate;
        private boolean delegated;

        public LazyEntityCollisionContext(Entity entity) {
            super(false, false, 0.0, null, null, entity);
        }

        public static boolean useEntityCollisionShape(Level world, Entity entity) {
            return entity instanceof AbstractMinecart && AbstractMinecart.useExperimentalMovement(world);
        }

        public boolean isDelegated() {
            boolean delegated = this.delegated;
            this.delegated = false;
            return delegated;
        }

        public CollisionContext getDelegate() {
            this.delegated = true;
            Entity entity = super.getEntity();
            return this.delegate == null ? (this.delegate = entity == null ? CollisionContext.empty() : CollisionContext.of(entity)) : this.delegate;
        }

        @Override
        public Entity getEntity() {
            this.getDelegate();
            return super.getEntity();
        }

        @Override
        public boolean isDescending() {
            return this.getDelegate().isDescending();
        }

        @Override
        public boolean isPlacement() {
            return this.getDelegate().isPlacement();
        }

        @Override
        public boolean isAbove(VoxelShape shape, BlockPos pos, boolean defaultValue) {
            return this.getDelegate().isAbove(shape, pos, defaultValue);
        }

        @Override
        public boolean isHoldingItem(Item item) {
            return this.getDelegate().isHoldingItem(item);
        }

        @Override
        public boolean canStandOnFluid(FluidState state, FluidState fluidState) {
            return this.getDelegate().canStandOnFluid(state, fluidState);
        }

        @Override
        public VoxelShape getCollisionShape(BlockState blockState, CollisionGetter collisionGetter, BlockPos blockPos) {
            return this.getDelegate().getCollisionShape(blockState, collisionGetter, blockPos);
        }
    }
}

