/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.gui;

import java.awt.Color;

public class GraphColor {
    private static final Color[] colorLine = new Color[101];
    private static final Color[] colorFill = new Color[101];

    public static Color getLineColor(int percent) {
        return colorLine[percent];
    }

    public static Color getFillColor(int percent) {
        return colorFill[percent];
    }

    private static Color createColor(int percent) {
        int green;
        int red;
        if (percent <= 50) {
            return new Color(65280);
        }
        int value = 510 - (int)(Math.min(Math.max(0.0f, (float)(percent - 50) / 50.0f), 1.0f) * 510.0f);
        if (value < 255) {
            red = 255;
            green = (int)(Math.sqrt(value) * 16.0);
        } else {
            green = 255;
            red = 255 - (value -= 255) * value / 255;
        }
        return new Color(red, green, 0);
    }

    static {
        for (int i = 0; i < 101; ++i) {
            Color color = GraphColor.createColor(i);
            GraphColor.colorLine[i] = new Color(color.getRed() / 2, color.getGreen() / 2, color.getBlue() / 2, 255);
            GraphColor.colorFill[i] = new Color(colorLine[i].getRed(), colorLine[i].getGreen(), colorLine[i].getBlue(), 125);
        }
    }
}

