/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.advancement;

import io.papermc.paper.advancement.AdvancementDisplay;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PaperAdvancementDisplay(DisplayInfo handle) implements AdvancementDisplay
{
    @NotNull
    public AdvancementDisplay.Frame frame() {
        return PaperAdvancementDisplay.asPaperFrame(this.handle.getType());
    }

    @NotNull
    public Component title() {
        return PaperAdventure.asAdventure(this.handle.getTitle());
    }

    @NotNull
    public Component description() {
        return PaperAdventure.asAdventure(this.handle.getDescription());
    }

    @NotNull
    public ItemStack icon() {
        return CraftItemStack.asBukkitCopy(this.handle.getIcon());
    }

    public boolean doesShowToast() {
        return this.handle.shouldShowToast();
    }

    public boolean doesAnnounceToChat() {
        return this.handle.shouldAnnounceChat();
    }

    public boolean isHidden() {
        return this.handle.isHidden();
    }

    @Nullable
    public NamespacedKey backgroundPath() {
        return this.handle.getBackground().map(asset -> CraftNamespacedKey.fromMinecraft(asset.id())).orElse(null);
    }

    @NotNull
    public Component displayName() {
        return PaperAdventure.asAdventure(Advancement.decorateName(Objects.requireNonNull(this.handle, "cannot build display name for null handle, invalid state")));
    }

    @NotNull
    public static AdvancementDisplay.Frame asPaperFrame(@NotNull AdvancementType frameType) {
        return switch (frameType) {
            default -> throw new MatchException(null, null);
            case AdvancementType.TASK -> AdvancementDisplay.Frame.TASK;
            case AdvancementType.CHALLENGE -> AdvancementDisplay.Frame.CHALLENGE;
            case AdvancementType.GOAL -> AdvancementDisplay.Frame.GOAL;
        };
    }
}

