/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.antixray;

import io.papermc.paper.antixray.BitStorageReader;
import io.papermc.paper.antixray.BitStorageWriter;
import io.papermc.paper.antixray.ChunkPacketBlockController;
import io.papermc.paper.antixray.ChunkPacketInfo;
import io.papermc.paper.antixray.ChunkPacketInfoAntiXray;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.EngineMode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import org.bukkit.Bukkit;
import org.bukkit.World;

public final class ChunkPacketBlockControllerAntiXray
extends ChunkPacketBlockController {
    private static final Palette<BlockState> GLOBAL_BLOCKSTATE_PALETTE = new GlobalPalette<BlockState>(Block.BLOCK_STATE_REGISTRY);
    private static final LevelChunkSection EMPTY_SECTION = null;
    private final Executor executor;
    private final EngineMode engineMode;
    private final int maxBlockHeight;
    private final int updateRadius;
    private final boolean usePermission;
    private final BlockState[] presetBlockStates;
    private final BlockState[] presetBlockStatesFull;
    private final BlockState[] presetBlockStatesStone;
    private final BlockState[] presetBlockStatesDeepslate;
    private final BlockState[] presetBlockStatesNetherrack;
    private final BlockState[] presetBlockStatesEndStone;
    private final int[] presetBlockStateBitsGlobal;
    private final int[] presetBlockStateBitsStoneGlobal;
    private final int[] presetBlockStateBitsDeepslateGlobal;
    private final int[] presetBlockStateBitsNetherrackGlobal;
    private final int[] presetBlockStateBitsEndStoneGlobal;
    private final boolean[] solidGlobal = new boolean[Block.BLOCK_STATE_REGISTRY.size()];
    private final boolean[] obfuscateGlobal = new boolean[Block.BLOCK_STATE_REGISTRY.size()];
    private final LevelChunkSection[] emptyNearbyChunkSections = new LevelChunkSection[]{EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION};
    private final int maxBlockHeightUpdatePosition;
    private final ThreadLocal<int[]> presetBlockStateBits = ThreadLocal.withInitial(() -> new int[this.getPresetBlockStatesFullLength()]);
    private static final ThreadLocal<boolean[]> SOLID = ThreadLocal.withInitial(() -> new boolean[Block.BLOCK_STATE_REGISTRY.size()]);
    private static final ThreadLocal<boolean[]> OBFUSCATE = ThreadLocal.withInitial(() -> new boolean[Block.BLOCK_STATE_REGISTRY.size()]);
    private static final ThreadLocal<boolean[][]> CURRENT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT_NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);

    public ChunkPacketBlockControllerAntiXray(Level level, Executor executor) {
        List<Block> toObfuscate;
        this.executor = executor;
        WorldConfiguration.Anticheat.AntiXray paperWorldConfig = level.paperConfig().anticheat.antiXray;
        this.engineMode = paperWorldConfig.engineMode;
        this.maxBlockHeight = paperWorldConfig.maxBlockHeight >> 4 << 4;
        this.updateRadius = paperWorldConfig.updateRadius;
        this.usePermission = paperWorldConfig.usePermission;
        if (this.engineMode == EngineMode.HIDE) {
            toObfuscate = paperWorldConfig.hiddenBlocks;
            this.presetBlockStates = null;
            this.presetBlockStatesFull = null;
            this.presetBlockStatesStone = new BlockState[]{Blocks.STONE.defaultBlockState()};
            this.presetBlockStatesDeepslate = new BlockState[]{Blocks.DEEPSLATE.defaultBlockState()};
            this.presetBlockStatesNetherrack = new BlockState[]{Blocks.NETHERRACK.defaultBlockState()};
            this.presetBlockStatesEndStone = new BlockState[]{Blocks.END_STONE.defaultBlockState()};
            this.presetBlockStateBitsGlobal = null;
            this.presetBlockStateBitsStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor(Blocks.STONE.defaultBlockState())};
            this.presetBlockStateBitsDeepslateGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor(Blocks.DEEPSLATE.defaultBlockState())};
            this.presetBlockStateBitsNetherrackGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor(Blocks.NETHERRACK.defaultBlockState())};
            this.presetBlockStateBitsEndStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor(Blocks.END_STONE.defaultBlockState())};
        } else {
            BlockState[] blockStateArray;
            toObfuscate = new ArrayList<Block>(paperWorldConfig.replacementBlocks);
            LinkedList<BlockState> presetBlockStateList = new LinkedList<BlockState>();
            for (Block block : paperWorldConfig.hiddenBlocks) {
                if (block instanceof EntityBlock) continue;
                toObfuscate.add(block);
                presetBlockStateList.add(block.defaultBlockState());
            }
            LinkedHashSet<BlockState> presetBlockStateSet = new LinkedHashSet<BlockState>();
            presetBlockStateSet.addAll(presetBlockStateList);
            if (presetBlockStateSet.isEmpty()) {
                BlockState[] blockStateArray2 = new BlockState[1];
                v1 = blockStateArray2;
                blockStateArray2[0] = Blocks.DIAMOND_ORE.defaultBlockState();
            } else {
                v1 = this.presetBlockStates = presetBlockStateSet.toArray(new BlockState[0]);
            }
            if (presetBlockStateSet.isEmpty()) {
                BlockState[] blockStateArray3 = new BlockState[1];
                blockStateArray = blockStateArray3;
                blockStateArray3[0] = Blocks.DIAMOND_ORE.defaultBlockState();
            } else {
                blockStateArray = presetBlockStateList.toArray(new BlockState[0]);
            }
            this.presetBlockStatesFull = blockStateArray;
            this.presetBlockStatesStone = null;
            this.presetBlockStatesDeepslate = null;
            this.presetBlockStatesNetherrack = null;
            this.presetBlockStatesEndStone = null;
            this.presetBlockStateBitsGlobal = new int[this.presetBlockStatesFull.length];
            for (int i = 0; i < this.presetBlockStatesFull.length; ++i) {
                this.presetBlockStateBitsGlobal[i] = GLOBAL_BLOCKSTATE_PALETTE.idFor(this.presetBlockStatesFull[i]);
            }
            this.presetBlockStateBitsStoneGlobal = null;
            this.presetBlockStateBitsDeepslateGlobal = null;
            this.presetBlockStateBitsNetherrackGlobal = null;
            this.presetBlockStateBitsEndStoneGlobal = null;
        }
        for (Block block : toObfuscate) {
            if (block == null || block.defaultBlockState().isAir()) continue;
            for (BlockState blockState : block.getStateDefinition().getPossibleStates()) {
                this.obfuscateGlobal[ChunkPacketBlockControllerAntiXray.GLOBAL_BLOCKSTATE_PALETTE.idFor((BlockState)blockState)] = true;
            }
        }
        EmptyLevelChunk emptyChunk = new EmptyLevelChunk(level, new ChunkPos(0, 0), MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS));
        BlockPos zeroPos = new BlockPos(0, 0, 0);
        for (int i = 0; i < this.solidGlobal.length; ++i) {
            BlockState blockState;
            blockState = GLOBAL_BLOCKSTATE_PALETTE.valueFor(i);
            if (blockState == null) continue;
            this.solidGlobal[i] = blockState.isRedstoneConductor(emptyChunk, zeroPos) && !blockState.is(Blocks.SPAWNER) && !blockState.is(Blocks.BARRIER) && !blockState.is(Blocks.SHULKER_BOX) && !blockState.is(Blocks.SLIME_BLOCK) && !blockState.is(Blocks.MANGROVE_ROOTS) || paperWorldConfig.lavaObscures && blockState == Blocks.LAVA.defaultBlockState();
        }
        this.maxBlockHeightUpdatePosition = this.maxBlockHeight + this.updateRadius - 1;
    }

    private int getPresetBlockStatesFullLength() {
        return this.engineMode == EngineMode.HIDE ? 1 : this.presetBlockStatesFull.length;
    }

    @Override
    public BlockState[] getPresetBlockStates(Level level, ChunkPos chunkPos, int chunkSectionY) {
        int bottomBlockY = chunkSectionY << 4;
        if (bottomBlockY < this.maxBlockHeight) {
            if (this.engineMode == EngineMode.HIDE) {
                return switch (level.getWorld().getEnvironment()) {
                    case World.Environment.NETHER -> this.presetBlockStatesNetherrack;
                    case World.Environment.THE_END -> this.presetBlockStatesEndStone;
                    default -> bottomBlockY < 0 ? this.presetBlockStatesDeepslate : this.presetBlockStatesStone;
                };
            }
            return this.presetBlockStates;
        }
        return null;
    }

    @Override
    public boolean shouldModify(ServerPlayer player, LevelChunk chunk) {
        return !this.usePermission || !player.getBukkitEntity().hasPermission("paper.antixray.bypass");
    }

    public ChunkPacketInfoAntiXray getChunkPacketInfo(ClientboundLevelChunkWithLightPacket chunkPacket, LevelChunk chunk) {
        return new ChunkPacketInfoAntiXray(chunkPacket, chunk, this);
    }

    @Override
    public void modifyBlocks(ClientboundLevelChunkWithLightPacket chunkPacket, ChunkPacketInfo<BlockState> chunkPacketInfo) {
        if (!(chunkPacketInfo instanceof ChunkPacketInfoAntiXray)) {
            chunkPacket.setReady(true);
            return;
        }
        if (!Bukkit.isPrimaryThread()) {
            MinecraftServer.getServer().scheduleOnMain(() -> this.modifyBlocks(chunkPacket, chunkPacketInfo));
            return;
        }
        LevelChunk chunk = chunkPacketInfo.getChunk();
        int x = chunk.getPos().x;
        int z = chunk.getPos().z;
        Level level = chunk.getLevel();
        ((ChunkPacketInfoAntiXray)chunkPacketInfo).setNearbyChunks(level.getChunkIfLoaded(x - 1, z), level.getChunkIfLoaded(x + 1, z), level.getChunkIfLoaded(x, z - 1), level.getChunkIfLoaded(x, z + 1));
        this.executor.execute((Runnable)((Object)chunkPacketInfo));
    }

    public void obfuscate(ChunkPacketInfoAntiXray chunkPacketInfoAntiXray) {
        int[] presetBlockStateBits = this.presetBlockStateBits.get();
        boolean[] solid = SOLID.get();
        boolean[] obfuscate = OBFUSCATE.get();
        boolean[][] current = CURRENT.get();
        boolean[][] next = NEXT.get();
        boolean[][] nextNext = NEXT_NEXT.get();
        BitStorageReader bitStorageReader = new BitStorageReader();
        BitStorageWriter bitStorageWriter = new BitStorageWriter();
        LevelChunkSection[] nearbyChunkSections = new LevelChunkSection[4];
        LevelChunk chunk = chunkPacketInfoAntiXray.getChunk();
        Level level = chunk.getLevel();
        int maxChunkSectionIndex = Math.min((this.maxBlockHeight >> 4) - chunk.getMinSectionY(), chunk.getSectionsCount()) - 1;
        boolean[] solidTemp = null;
        boolean[] obfuscateTemp = null;
        bitStorageReader.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        bitStorageWriter.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        final int numberOfBlocks = presetBlockStateBits.length;
        LayeredIntSupplier random = numberOfBlocks == 1 ? () -> 0 : (this.engineMode == EngineMode.OBFUSCATE_LAYER ? new LayeredIntSupplier(){
            private int state;
            private int next;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public void nextLayer() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                this.next = (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }

            @Override
            public int getAsInt() {
                return this.next;
            }
        } : new LayeredIntSupplier(){
            private int state;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public int getAsInt() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                return (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }
        });
        for (int chunkSectionIndex = 0; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
            int x;
            int z;
            int[] presetBlockStateBitsTemp;
            if (!chunkPacketInfoAntiXray.isWritten(chunkSectionIndex) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == null) continue;
            if (chunkPacketInfoAntiXray.getPalette(chunkSectionIndex) instanceof GlobalPalette) {
                if (this.engineMode == EngineMode.HIDE) {
                    presetBlockStateBitsTemp = switch (level.getWorld().getEnvironment()) {
                        case World.Environment.NETHER -> this.presetBlockStateBitsNetherrackGlobal;
                        case World.Environment.THE_END -> this.presetBlockStateBitsEndStoneGlobal;
                        default -> chunkSectionIndex + chunk.getMinSectionY() < 0 ? this.presetBlockStateBitsDeepslateGlobal : this.presetBlockStateBitsStoneGlobal;
                    };
                } else {
                    presetBlockStateBitsTemp = this.presetBlockStateBitsGlobal;
                }
            } else {
                BlockState[] presetBlockStatesFull = chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == this.presetBlockStates ? this.presetBlockStatesFull : (BlockState[])chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex);
                presetBlockStateBitsTemp = presetBlockStateBits;
                for (int i = 0; i < presetBlockStateBitsTemp.length; ++i) {
                    presetBlockStateBitsTemp[i] = chunkPacketInfoAntiXray.getPalette(chunkSectionIndex).idFor(presetBlockStatesFull[i]);
                }
            }
            bitStorageWriter.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
            if (chunkSectionIndex == 0 || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex - 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex - 1) == null) {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
                solidTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), solid, this.solidGlobal);
                obfuscateTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), obfuscate, this.obfuscateGlobal);
                LevelChunkSection belowChunkSection = null;
                boolean skipFirstLayer = chunkSectionIndex == 0 || (belowChunkSection = chunk.getSections()[chunkSectionIndex - 1]) == EMPTY_SECTION;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        current[z][x] = true;
                        next[z][x] = skipFirstLayer || this.isTransparent(belowChunkSection, x, 15, z);
                    }
                }
                bitStorageWriter.setBits(0);
                this.obfuscateLayer(-1, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, this.emptyNearbyChunkSections, random);
            }
            bitStorageWriter.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
            nearbyChunkSections[0] = chunkPacketInfoAntiXray.getNearbyChunks()[0] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[0].getSections()[chunkSectionIndex];
            nearbyChunkSections[1] = chunkPacketInfoAntiXray.getNearbyChunks()[1] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[1].getSections()[chunkSectionIndex];
            nearbyChunkSections[2] = chunkPacketInfoAntiXray.getNearbyChunks()[2] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[2].getSections()[chunkSectionIndex];
            nearbyChunkSections[3] = chunkPacketInfoAntiXray.getNearbyChunks()[3] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[3].getSections()[chunkSectionIndex];
            for (int y = 0; y < 15; ++y) {
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                random.nextLayer();
                this.obfuscateLayer(y, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, nearbyChunkSections, random);
            }
            if (chunkSectionIndex == maxChunkSectionIndex || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex + 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex + 1) == null) {
                LevelChunkSection aboveChunkSection;
                if (chunkSectionIndex != chunk.getSectionsCount() - 1 && (aboveChunkSection = chunk.getSections()[chunkSectionIndex + 1]) != EMPTY_SECTION) {
                    boolean[][] temp = current;
                    current = next;
                    next = nextNext;
                    nextNext = temp;
                    for (z = 0; z < 16; ++z) {
                        for (x = 0; x < 16; ++x) {
                            if (!this.isTransparent(aboveChunkSection, x, 0, z)) continue;
                            current[z][x] = true;
                        }
                    }
                    bitStorageReader.setBits(0);
                    solid[0] = true;
                    random.nextLayer();
                    this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, nearbyChunkSections, random);
                }
            } else {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex + 1));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex + 1));
                solidTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), solid, this.solidGlobal);
                obfuscateTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), obfuscate, this.obfuscateGlobal);
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                random.nextLayer();
                this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, nearbyChunkSections, random);
            }
            bitStorageWriter.flush();
        }
        chunkPacketInfoAntiXray.getChunkPacket().setReady(true);
    }

    private void obfuscateLayer(int y, BitStorageReader bitStorageReader, BitStorageWriter bitStorageWriter, boolean[] solid, boolean[] obfuscate, int[] presetBlockStateBits, boolean[][] current, boolean[][] next, boolean[][] nextNext, LevelChunkSection[] nearbyChunkSections, IntSupplier random) {
        int x;
        int bits = bitStorageReader.read();
        nextNext[0][0] = !solid[bits];
        if (nextNext[0][0]) {
            bitStorageWriter.skip();
            next[0][1] = true;
            next[1][0] = true;
        } else if (current[0][0] || this.isTransparent(nearbyChunkSections[2], 0, y, 15) || this.isTransparent(nearbyChunkSections[0], 15, y, 0)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[0][0] = true;
        }
        for (x = 1; x < 15; ++x) {
            bits = bitStorageReader.read();
            nextNext[0][x] = !solid[bits];
            if (nextNext[0][x]) {
                bitStorageWriter.skip();
                next[0][x - 1] = true;
                next[0][x + 1] = true;
                next[1][x] = true;
            } else if (current[0][x] || this.isTransparent(nearbyChunkSections[2], x, y, 15)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (obfuscate[bits]) continue;
            next[0][x] = true;
        }
        bits = bitStorageReader.read();
        nextNext[0][15] = !solid[bits];
        if (nextNext[0][15]) {
            bitStorageWriter.skip();
            next[0][14] = true;
            next[1][15] = true;
        } else if (current[0][15] || this.isTransparent(nearbyChunkSections[2], 15, y, 15) || this.isTransparent(nearbyChunkSections[1], 0, y, 0)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[0][15] = true;
        }
        for (int z = 1; z < 15; ++z) {
            bits = bitStorageReader.read();
            nextNext[z][0] = !solid[bits];
            if (nextNext[z][0]) {
                bitStorageWriter.skip();
                next[z][1] = true;
                next[z - 1][0] = true;
                next[z + 1][0] = true;
            } else if (current[z][0] || this.isTransparent(nearbyChunkSections[0], 15, y, z)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (!obfuscate[bits]) {
                next[z][0] = true;
            }
            for (int x2 = 1; x2 < 15; ++x2) {
                bits = bitStorageReader.read();
                nextNext[z][x2] = !solid[bits];
                if (nextNext[z][x2]) {
                    bitStorageWriter.skip();
                    next[z][x2 - 1] = true;
                    next[z][x2 + 1] = true;
                    next[z - 1][x2] = true;
                    next[z + 1][x2] = true;
                } else if (current[z][x2]) {
                    bitStorageWriter.skip();
                } else {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                }
                if (obfuscate[bits]) continue;
                next[z][x2] = true;
            }
            bits = bitStorageReader.read();
            nextNext[z][15] = !solid[bits];
            if (nextNext[z][15]) {
                bitStorageWriter.skip();
                next[z][14] = true;
                next[z - 1][15] = true;
                next[z + 1][15] = true;
            } else if (current[z][15] || this.isTransparent(nearbyChunkSections[1], 0, y, z)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (obfuscate[bits]) continue;
            next[z][15] = true;
        }
        bits = bitStorageReader.read();
        nextNext[15][0] = !solid[bits];
        if (nextNext[15][0]) {
            bitStorageWriter.skip();
            next[15][1] = true;
            next[14][0] = true;
        } else if (current[15][0] || this.isTransparent(nearbyChunkSections[3], 0, y, 0) || this.isTransparent(nearbyChunkSections[0], 15, y, 15)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[15][0] = true;
        }
        for (x = 1; x < 15; ++x) {
            bits = bitStorageReader.read();
            nextNext[15][x] = !solid[bits];
            if (nextNext[15][x]) {
                bitStorageWriter.skip();
                next[15][x - 1] = true;
                next[15][x + 1] = true;
                next[14][x] = true;
            } else if (current[15][x] || this.isTransparent(nearbyChunkSections[3], x, y, 0)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (obfuscate[bits]) continue;
            next[15][x] = true;
        }
        bits = bitStorageReader.read();
        nextNext[15][15] = !solid[bits];
        if (nextNext[15][15]) {
            bitStorageWriter.skip();
            next[15][14] = true;
            next[14][15] = true;
        } else if (current[15][15] || this.isTransparent(nearbyChunkSections[3], 15, y, 0) || this.isTransparent(nearbyChunkSections[1], 0, y, 15)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[15][15] = true;
        }
    }

    private boolean isTransparent(LevelChunkSection chunkSection, int x, int y, int z) {
        if (chunkSection == EMPTY_SECTION) {
            return true;
        }
        try {
            return !this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.idFor(chunkSection.getBlockState(x, y, z))];
        }
        catch (MissingPaletteEntryException e) {
            return true;
        }
    }

    private boolean[] readPalette(Palette<BlockState> palette, boolean[] temp, boolean[] global) {
        if (palette instanceof GlobalPalette) {
            return global;
        }
        try {
            for (int i = 0; i < palette.getSize(); ++i) {
                temp[i] = global[GLOBAL_BLOCKSTATE_PALETTE.idFor(palette.valueFor(i))];
            }
        }
        catch (MissingPaletteEntryException missingPaletteEntryException) {
            // empty catch block
        }
        return temp;
    }

    @Override
    public void onBlockChange(Level level, BlockPos blockPos, BlockState newBlockState, BlockState oldBlockState, int flags, int maxUpdateDepth) {
        if (oldBlockState != null && this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.idFor(oldBlockState)] && !this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.idFor(newBlockState)] && blockPos.getY() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(level, blockPos);
        }
    }

    @Override
    public void onPlayerLeftClickBlock(ServerPlayerGameMode serverPlayerGameMode, BlockPos blockPos, ServerboundPlayerActionPacket.Action action, Direction direction, int worldHeight, int sequence) {
        if (blockPos.getY() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(serverPlayerGameMode.level, blockPos);
        }
    }

    private void updateNearbyBlocks(Level level, BlockPos blockPos) {
        if (this.updateRadius >= 2) {
            BlockPos temp = blockPos.west();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.west());
            this.updateBlock(level, temp.below());
            this.updateBlock(level, temp.above());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.east();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.east());
            this.updateBlock(level, temp.below());
            this.updateBlock(level, temp.above());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.below();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.below());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.above();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.above());
            this.updateBlock(level, temp.north());
            this.updateBlock(level, temp.south());
            temp = blockPos.north();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.north());
            temp = blockPos.south();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.south());
        } else if (this.updateRadius == 1) {
            this.updateBlock(level, blockPos.west());
            this.updateBlock(level, blockPos.east());
            this.updateBlock(level, blockPos.below());
            this.updateBlock(level, blockPos.above());
            this.updateBlock(level, blockPos.north());
            this.updateBlock(level, blockPos.south());
        }
    }

    private void updateBlock(Level level, BlockPos blockPos) {
        BlockState blockState = level.getBlockStateIfLoaded(blockPos);
        if (blockState != null && this.obfuscateGlobal[GLOBAL_BLOCKSTATE_PALETTE.idFor(blockState)]) {
            ((ServerLevel)level).getChunkSource().blockChanged(blockPos);
        }
    }

    @FunctionalInterface
    private static interface LayeredIntSupplier
    extends IntSupplier {
        default public void nextLayer() {
        }
    }
}

