/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.ApiMirrorRootNode;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandRegistrationFlag;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PluginCommandMeta;
import io.papermc.paper.command.brigadier.bukkit.BukkitCommandNode;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.registrar.PaperRegistrar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperCommands
implements Commands,
PaperRegistrar<LifecycleEventOwner> {
    public static final PaperCommands INSTANCE = new PaperCommands();
    private @Nullable LifecycleEventOwner currentContext;
    private @Nullable CommandDispatcher<CommandSourceStack> dispatcher;
    private @Nullable CommandBuildContext buildContext;
    private boolean invalid = false;

    @Override
    public void setCurrentContext(@Nullable LifecycleEventOwner context) {
        this.currentContext = context;
    }

    public void setDispatcher(final net.minecraft.commands.Commands commands, CommandBuildContext commandBuildContext) {
        this.invalid = false;
        this.dispatcher = new CommandDispatcher<CommandSourceStack>(new ApiMirrorRootNode(this){

            @Override
            public CommandDispatcher<net.minecraft.commands.CommandSourceStack> getDispatcher() {
                return commands.getDispatcher();
            }
        });
        this.buildContext = commandBuildContext;
    }

    public void setValid() {
        this.invalid = false;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    public CommandDispatcher<CommandSourceStack> getDispatcherInternal() {
        Preconditions.checkState((this.dispatcher != null ? 1 : 0) != 0, (Object)"the dispatcher hasn't been set yet");
        return this.dispatcher;
    }

    public CommandBuildContext getBuildContext() {
        Preconditions.checkState((this.buildContext != null ? 1 : 0) != 0, (Object)"the build context hasn't been set yet");
        return this.buildContext;
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        Preconditions.checkState((!this.invalid && this.dispatcher != null ? 1 : 0) != 0, (Object)"cannot access the dispatcher in this context");
        return this.dispatcher;
    }

    public @Unmodifiable Set<String> register(LiteralCommandNode<CommandSourceStack> node, @Nullable String description, Collection<String> aliases) {
        return this.register(Objects.requireNonNull(this.currentContext, "No lifecycle owner context is set").getPluginMeta(), node, description, aliases);
    }

    public @Unmodifiable Set<String> register(PluginMeta pluginMeta, LiteralCommandNode<CommandSourceStack> node, @Nullable String description, Collection<String> aliases) {
        return this.registerWithFlags(pluginMeta, node, description, aliases, Set.of());
    }

    public @Unmodifiable Set<String> registerWithFlags(PluginMeta pluginMeta, LiteralCommandNode<CommandSourceStack> node, @Nullable String description, Collection<String> aliases, Set<CommandRegistrationFlag> flags) {
        PluginCommandMeta meta = new PluginCommandMeta(pluginMeta, description);
        String identifier = pluginMeta.getName().toLowerCase(Locale.ROOT);
        String literal = node.getLiteral();
        LiteralCommandNode<CommandSourceStack> pluginLiteral = PaperBrigadier.copyLiteral(identifier + ":" + literal, node);
        HashSet<String> registeredLabels = new HashSet<String>(aliases.size() * 2 + 2);
        if (this.registerIntoDispatcher(pluginLiteral, true)) {
            registeredLabels.add(pluginLiteral.getLiteral());
        }
        if (this.registerIntoDispatcher(node, true)) {
            registeredLabels.add(literal);
        }
        ArrayList<String> registeredAliases = new ArrayList<String>(aliases.size() * 2);
        for (String alias : aliases) {
            if (this.registerCopy(alias, pluginLiteral, meta)) {
                registeredAliases.add(alias);
            }
            if (!this.registerCopy(identifier + ":" + alias, pluginLiteral, meta)) continue;
            registeredAliases.add(identifier + ":" + alias);
        }
        node.pluginCommandMeta = pluginLiteral.pluginCommandMeta = new PluginCommandMeta(pluginMeta, description, registeredAliases);
        registeredLabels.addAll(registeredAliases);
        return registeredLabels.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(registeredLabels);
    }

    private boolean registerCopy(String aliasLiteral, LiteralCommandNode<CommandSourceStack> redirectTo, PluginCommandMeta meta) {
        LiteralCommandNode<CommandSourceStack> node = PaperBrigadier.copyLiteral(aliasLiteral, redirectTo);
        node.pluginCommandMeta = meta;
        return this.registerIntoDispatcher(node, false);
    }

    private boolean registerIntoDispatcher(LiteralCommandNode<CommandSourceStack> node, boolean override) {
        CommandNode existingChild = this.getDispatcher().getRoot().getChild(node.getLiteral());
        if (existingChild != null && existingChild.pluginCommandMeta == null && !(existingChild instanceof BukkitCommandNode)) {
            override = true;
        }
        if (existingChild == null || override) {
            if (override) {
                this.getDispatcher().getRoot().removeCommand(node.getLiteral());
            }
            this.getDispatcher().getRoot().addChild(node);
            return true;
        }
        return false;
    }

    public @Unmodifiable Set<String> register(String label, @Nullable String description, Collection<String> aliases, BasicCommand basicCommand) {
        return this.register(Objects.requireNonNull(this.currentContext, "No lifecycle owner context is set").getPluginMeta(), label, description, aliases, basicCommand);
    }

    public @Unmodifiable Set<String> register(PluginMeta pluginMeta, String label, @Nullable String description, Collection<String> aliases, BasicCommand basicCommand) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)label).requires(stack -> basicCommand.canUse(stack.getSender()))).then(Commands.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((context, suggestionsBuilder) -> {
            Object[] args = StringUtils.split((String)suggestionsBuilder.getRemaining());
            if (suggestionsBuilder.getRemaining().endsWith(" ")) {
                args = (String[])ArrayUtils.add((Object[])args, (Object)"");
            }
            SuggestionsBuilder offsetSuggestionsBuilder = suggestionsBuilder.createOffset(suggestionsBuilder.getInput().lastIndexOf(32) + 1);
            Collection suggestions = basicCommand.suggest((CommandSourceStack)context.getSource(), (String[])args);
            suggestions.forEach(arg_0 -> ((SuggestionsBuilder)offsetSuggestionsBuilder).suggest(arg_0));
            return offsetSuggestionsBuilder.buildFuture();
        }).executes(stack -> {
            basicCommand.execute((CommandSourceStack)stack.getSource(), StringUtils.split((String)((String)stack.getArgument("args", String.class)), (char)' '));
            return 1;
        }))).executes(stack -> {
            basicCommand.execute((CommandSourceStack)stack.getSource(), new String[0]);
            return 1;
        });
        return this.register(pluginMeta, builder.build(), description, aliases);
    }
}

