/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.transformation.world.versioned;

import io.papermc.paper.configuration.Configurations;
import net.minecraft.world.level.GameRules;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public final class V31_SpawnLoadedRangeToGameRule
implements TransformAction {
    private static final int VERSION = 31;
    private static final String SPAWN = "spawn";
    private static final String KEEP_SPAWN_LOADED_RANGE = "keep-spawn-loaded-range";
    private static final String KEEP_SPAWN_LOADED = "keep-spawn-loaded";
    private final GameRules gameRules;
    private final ConfigurationNode defaultsNode;

    private V31_SpawnLoadedRangeToGameRule(GameRules gameRules, ConfigurationNode defaultsNode) {
        this.gameRules = gameRules;
        this.defaultsNode = defaultsNode;
    }

    public Object @Nullable [] visitPath(NodePath path, ConfigurationNode value) {
        ConfigurationNode worldSpawnNode = value.node(new Object[]{SPAWN});
        ConfigurationNode worldLoadedNode = worldSpawnNode.node(new Object[]{KEEP_SPAWN_LOADED});
        boolean keepLoaded = worldLoadedNode.getBoolean(this.defaultsNode.node(new Object[]{SPAWN, KEEP_SPAWN_LOADED}).getBoolean());
        worldLoadedNode.raw(null);
        ConfigurationNode worldRangeNode = worldSpawnNode.node(new Object[]{KEEP_SPAWN_LOADED_RANGE});
        int range = worldRangeNode.getInt(this.defaultsNode.node(new Object[]{SPAWN, KEEP_SPAWN_LOADED_RANGE}).getInt());
        worldRangeNode.raw(null);
        if (worldSpawnNode.empty()) {
            worldSpawnNode.raw(null);
        }
        if (!keepLoaded) {
            this.gameRules.getRule(GameRules.RULE_SPAWN_CHUNK_RADIUS).set(0, null);
        } else {
            this.gameRules.getRule(GameRules.RULE_SPAWN_CHUNK_RADIUS).set(range, null);
        }
        return null;
    }

    public static void apply(ConfigurationTransformation.VersionedBuilder builder, Configurations.ContextMap contextMap, @Nullable ConfigurationNode defaultsNode) {
        if (defaultsNode != null) {
            builder.addVersion(31, ConfigurationTransformation.builder().addAction(NodePath.path(), (TransformAction)new V31_SpawnLoadedRangeToGameRule(contextMap.require(Configurations.GAME_RULES), defaultsNode)).build());
        } else {
            builder.addVersion(31, ConfigurationTransformation.empty());
        }
    }
}

