/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.BundleContents;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.inventory.ItemStack;

public record PaperBundleContents(net.minecraft.world.item.component.BundleContents impl) implements BundleContents,
Handleable<net.minecraft.world.item.component.BundleContents>
{
    @Override
    public net.minecraft.world.item.component.BundleContents getHandle() {
        return this.impl;
    }

    public List<ItemStack> contents() {
        return MCUtil.transformUnmodifiable((List)this.impl.items(), CraftItemStack::asBukkitCopy);
    }

    static final class BuilderImpl
    implements BundleContents.Builder {
        private final List<net.minecraft.world.item.ItemStack> items = new ObjectArrayList();

        BuilderImpl() {
        }

        public BundleContents.Builder add(ItemStack stack) {
            Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"stack cannot be null");
            Preconditions.checkArgument((!stack.isEmpty() ? 1 : 0) != 0, (Object)"stack cannot be empty");
            this.items.add(CraftItemStack.asNMSCopy(stack));
            return this;
        }

        public BundleContents.Builder addAll(List<ItemStack> stacks) {
            stacks.forEach(this::add);
            return this;
        }

        public BundleContents build() {
            if (this.items.isEmpty()) {
                return new PaperBundleContents(net.minecraft.world.item.component.BundleContents.EMPTY);
            }
            return new PaperBundleContents(new net.minecraft.world.item.component.BundleContents((List<net.minecraft.world.item.ItemStack>)new ObjectArrayList(this.items)));
        }
    }
}

