/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.item.MapDecorations;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.component.MapDecorations;
import org.bukkit.craftbukkit.map.CraftMapCursor;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.map.MapCursor;
import org.jspecify.annotations.Nullable;

public record PaperMapDecorations(net.minecraft.world.item.component.MapDecorations impl) implements MapDecorations,
Handleable<net.minecraft.world.item.component.MapDecorations>
{
    @Override
    public net.minecraft.world.item.component.MapDecorations getHandle() {
        return this.impl;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MapDecorations.DecorationEntry decoration(String id) {
        MapDecorations.Entry decoration = this.impl.decorations().get(id);
        if (decoration == null) {
            return null;
        }
        return new PaperDecorationEntry(decoration);
    }

    public Map<String, MapDecorations.DecorationEntry> decorations() {
        if (this.impl.decorations().isEmpty()) {
            return Collections.emptyMap();
        }
        Set<Map.Entry<String, MapDecorations.Entry>> entries = this.impl.decorations().entrySet();
        Object2ObjectOpenHashMap decorations = new Object2ObjectOpenHashMap(entries.size());
        for (Map.Entry<String, MapDecorations.Entry> entry : entries) {
            decorations.put(entry.getKey(), new PaperDecorationEntry(entry.getValue()));
        }
        return Collections.unmodifiableMap(decorations);
    }

    public record PaperDecorationEntry(MapDecorations.Entry entry) implements MapDecorations.DecorationEntry
    {
        public static MapDecorations.DecorationEntry toApi(MapCursor.Type type, double x, double z, float rotation) {
            return new PaperDecorationEntry(new MapDecorations.Entry(CraftMapCursor.CraftType.bukkitToMinecraftHolder(type), x, z, rotation));
        }

        public MapCursor.Type type() {
            return CraftMapCursor.CraftType.minecraftHolderToBukkit(this.entry.type());
        }

        public double x() {
            return this.entry.x();
        }

        public double z() {
            return this.entry.z();
        }

        public float rotation() {
            return this.entry.rotation();
        }
    }

    static final class BuilderImpl
    implements MapDecorations.Builder {
        private final Map<String, MapDecorations.Entry> entries = new Object2ObjectOpenHashMap();

        BuilderImpl() {
        }

        public MapDecorations.Builder put(String id, MapDecorations.DecorationEntry entry) {
            this.entries.put(id, new MapDecorations.Entry(CraftMapCursor.CraftType.bukkitToMinecraftHolder(entry.type()), entry.x(), entry.z(), entry.rotation()));
            return this;
        }

        public MapDecorations.Builder putAll(Map<String, MapDecorations.DecorationEntry> entries) {
            entries.forEach(this::put);
            return this;
        }

        public MapDecorations build() {
            if (this.entries.isEmpty()) {
                return new PaperMapDecorations(net.minecraft.world.item.component.MapDecorations.EMPTY);
            }
            return new PaperMapDecorations(new net.minecraft.world.item.component.MapDecorations((Map<String, MapDecorations.Entry>)new Object2ObjectOpenHashMap(this.entries)));
        }
    }
}

