/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import com.google.common.collect.Collections2;
import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.datapack.DatapackManager;
import io.papermc.paper.datapack.PaperDatapack;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperDatapackManager
implements DatapackManager {
    private final PackRepository repository;

    public PaperDatapackManager(PackRepository repository) {
        this.repository = repository;
    }

    public void refreshPacks() {
        this.repository.reload();
    }

    public @Nullable Datapack getPack(@NonNull String name) {
        @Nullable Pack pack = this.repository.getPack(name);
        if (pack == null) {
            return null;
        }
        return new PaperDatapack(pack, this.repository.getSelectedPacks().contains(pack));
    }

    public Collection<Datapack> getPacks() {
        Collection<Pack> enabledPacks = this.repository.getSelectedPacks();
        return this.transformPacks(this.repository.getAvailablePacks(), enabledPacks::contains);
    }

    public Collection<Datapack> getEnabledPacks() {
        return this.transformPacks(this.repository.getSelectedPacks(), pack -> true);
    }

    private Collection<Datapack> transformPacks(Collection<Pack> packs, Predicate<Pack> enabled) {
        return Collections.unmodifiableCollection(Collections2.transform(packs, pack -> new PaperDatapack((Pack)pack, enabled.test((Pack)pack))));
    }
}

