/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.inventory.recipe;

import io.papermc.paper.inventory.recipe.ItemOrExact;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public final class StackedContentsExtrasMap {
    private final StackedContents<ItemOrExact> contents;
    public Object2IntMap<ItemOrExact.Item> regularRemoved = new Object2IntOpenHashMap();
    public final ObjectSet<ItemStack> exactIngredients = new ObjectOpenCustomHashSet(ItemStackLinkedSet.TYPE_AND_TAG);

    public StackedContentsExtrasMap(StackedContents<ItemOrExact> contents) {
        this.contents = contents;
    }

    public void initialize(Recipe<?> recipe) {
        this.exactIngredients.clear();
        for (Ingredient ingredient : recipe.placementInfo().ingredients()) {
            if (!ingredient.isExact()) continue;
            this.exactIngredients.addAll(ingredient.itemStacks());
        }
    }

    public void accountInput(CraftingInput input) {
        for (ItemStack item : input.items()) {
            ItemOrExact.Item asItem;
            if (item.isEmpty() || !this.accountStack(item, 1) || !this.contents.amounts.containsKey((Object)(asItem = new ItemOrExact.Item(item)))) continue;
            int amount = this.contents.amounts.removeInt((Object)asItem);
            this.regularRemoved.put((Object)asItem, amount);
        }
    }

    public void resetExtras() {
        for (ItemStack extra : this.exactIngredients) {
            this.contents.amounts.removeInt((Object)new ItemOrExact.Exact(extra));
        }
        for (Object2IntMap.Entry entry : this.regularRemoved.object2IntEntrySet()) {
            this.contents.amounts.addTo((Object)((ItemOrExact)entry.getKey()), entry.getIntValue());
        }
        this.exactIngredients.clear();
        this.regularRemoved.clear();
    }

    public boolean accountStack(ItemStack stack, int count) {
        if (this.exactIngredients.contains((Object)stack)) {
            this.contents.account(new ItemOrExact.Exact(stack), count);
            return true;
        }
        return false;
    }
}

