/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader;

import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.classloader.PaperSimplePluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import io.papermc.paper.plugin.provider.configuration.PaperPluginMeta;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperPluginClassLoader
extends PaperSimplePluginClassLoader
implements ConfiguredPluginClassLoader {
    private final URLClassLoader libraryLoader;
    private final Set<String> seenIllegalAccess = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Logger logger;
    @Nullable
    private JavaPlugin loadedJavaPlugin;
    @Nullable
    private PluginClassLoaderGroup group;

    public PaperPluginClassLoader(Logger logger, Path source, JarFile file, PaperPluginMeta configuration, ClassLoader parentLoader, URLClassLoader libraryLoader) throws IOException {
        super(source, file, configuration, parentLoader);
        this.libraryLoader = libraryLoader;
        this.logger = logger;
        if (this.configuration().hasOpenClassloader()) {
            this.group = PaperClassLoaderStorage.instance().registerOpenGroup((ConfiguredPluginClassLoader)this);
        }
    }

    private PaperPluginMeta configuration() {
        return (PaperPluginMeta)this.configuration;
    }

    public void refreshClassloaderDependencyTree(DependencyContext dependencyContext) {
        if (this.configuration().hasOpenClassloader()) {
            return;
        }
        if (this.group != null) {
            PaperClassLoaderStorage.instance().unregisterClassloader((ConfiguredPluginClassLoader)this);
        }
        this.group = PaperClassLoaderStorage.instance().registerAccessBackedGroup((ConfiguredPluginClassLoader)this, classLoader -> dependencyContext.isTransitiveDependency(this.configuration, classLoader.getConfiguration()));
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (resource == null && this.libraryLoader != null) {
            return this.libraryLoader.getResource(name);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList resources = new ArrayList();
        this.addEnumeration(resources, this.findResources(name));
        if (this.libraryLoader != null) {
            this.addEnumeration(resources, this.libraryLoader.getResources(name));
        }
        return Collections.enumeration(resources);
    }

    private <T> void addEnumeration(List<T> list, Enumeration<T> enumeration) {
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, true, true);
    }

    public PluginMeta getConfiguration() {
        return this.configuration;
    }

    public Class<?> loadClass(@NotNull String name, boolean resolve, boolean checkGroup, boolean checkLibraries) throws ClassNotFoundException {
        try {
            Class<?> result = super.loadClass(name, resolve);
            if (checkGroup || result.getClassLoader() == this) {
                return result;
            }
        }
        catch (ClassNotFoundException result) {
            // empty catch block
        }
        if (checkLibraries) {
            try {
                return this.libraryLoader.loadClass(name);
            }
            catch (ClassNotFoundException result) {
                // empty catch block
            }
        }
        if (checkGroup) {
            if (this.group == null) {
                throw new IllegalStateException("Tried to resolve class while group was not yet initialized");
            }
            Class clazz = this.group.getClassByName(name, resolve, (ConfiguredPluginClassLoader)this);
            if (clazz != null) {
                return clazz;
            }
        }
        throw new ClassNotFoundException(name);
    }

    public void init(JavaPlugin plugin) {
        PluginMeta config = this.configuration;
        PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile(config.getName(), config.getName(), config.getProvidedPlugins(), config.getMainClass(), "", config.getPluginDependencies(), config.getPluginSoftDependencies(), config.getLoadBeforePlugins(), config.getVersion(), Map.of(), config.getDescription(), config.getAuthors(), config.getContributors(), config.getWebsite(), config.getLoggerPrefix(), config.getLoadOrder(), config.getPermissions(), config.getPermissionDefault(), Set.of(), config.getAPIVersion(), List.of());
        File dataFolder = new File(Bukkit.getPluginsFolder(), pluginDescriptionFile.getName());
        plugin.init(Bukkit.getServer(), pluginDescriptionFile, dataFolder, this.source.toFile(), (ClassLoader)this, config, this.logger);
        this.loadedJavaPlugin = plugin;
    }

    @Nullable
    public JavaPlugin getPlugin() {
        return this.loadedJavaPlugin;
    }

    @Override
    public String toString() {
        return "PaperPluginClassLoader{libraryLoader=" + String.valueOf(this.libraryLoader) + ", seenIllegalAccess=" + String.valueOf(this.seenIllegalAccess) + ", loadedJavaPlugin=" + String.valueOf(this.loadedJavaPlugin) + "}";
    }

    @Override
    public void close() throws IOException {
        try (JarFile jarFile = this.jar;
             URLClassLoader uRLClassLoader = this.libraryLoader;){
            super.close();
        }
    }

    @Nullable
    public PluginClassLoaderGroup getGroup() {
        return this.group;
    }

    static {
        PaperPluginClassLoader.registerAsParallelCapable();
    }
}

