/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.strategy;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class JohnsonSimpleCycles<V> {
    private Graph<V> graph;
    private Consumer<List<V>> cycleConsumer = null;
    private BiConsumer<V, V> cycleVertexSuccessorConsumer = null;
    private V[] iToV = null;
    private Map<V, Integer> vToI = null;
    private Set<V> blocked = null;
    private Map<V, Set<V>> bSets = null;
    private ArrayDeque<V> stack = null;
    private List<Set<V>> foundSCCs = null;
    private int index = 0;
    private Map<V, Integer> vIndex = null;
    private Map<V, Integer> vLowlink = null;
    private ArrayDeque<V> path = null;
    private Set<V> pathSet = null;

    public JohnsonSimpleCycles(Graph<V> graph) {
        Preconditions.checkState((boolean)graph.isDirected(), (Object)"Graph must be directed");
        this.graph = graph;
    }

    public List<List<V>> findAndRemoveSimpleCycles() {
        ArrayList<List<V>> result = new ArrayList<List<V>>();
        this.findSimpleCycles(result::add, (v, s) -> ((MutableGraph)this.graph).removeEdge(v, s));
        return result;
    }

    public void findSimpleCycles(Consumer<List<V>> consumer, BiConsumer<V, V> vertexSuccessorConsumer) {
        Pair<Graph<V>, Integer> minSCCGResult;
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.cycleVertexSuccessorConsumer = vertexSuccessorConsumer;
        this.initState(consumer);
        int size = this.graph.nodes().size();
        for (int startIndex = 0; startIndex < size && (minSCCGResult = this.findMinSCSG(startIndex)) != null; ++startIndex) {
            startIndex = (Integer)minSCCGResult.getSecond();
            Graph scg = (Graph)minSCCGResult.getFirst();
            V startV = this.toV(startIndex);
            for (Object v : scg.successors(startV)) {
                this.blocked.remove(v);
                this.getBSet(v).clear();
            }
            this.findCyclesInSCG(startIndex, startIndex, scg);
        }
        this.clearState();
    }

    private Pair<Graph<V>, Integer> findMinSCSG(int startIndex) {
        this.initMinSCGState();
        List<Set<V>> foundSCCs = this.findSCCS(startIndex);
        int minIndexFound = Integer.MAX_VALUE;
        Set<V> minSCC = null;
        for (Set<V> set : foundSCCs) {
            for (V v : set) {
                int t = this.toI(v);
                if (t >= minIndexFound) continue;
                minIndexFound = t;
                minSCC = set;
            }
        }
        if (minSCC == null) {
            return null;
        }
        MutableGraph dependencyGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        for (Object v : minSCC) {
            for (Object w : minSCC) {
                if (!this.graph.hasEdgeConnecting(v, w)) continue;
                dependencyGraph.putEdge(v, w);
            }
        }
        Pair pair = Pair.of((Object)dependencyGraph, (Object)minIndexFound);
        this.clearMinSCCState();
        return pair;
    }

    private List<Set<V>> findSCCS(int startIndex) {
        for (Object v : this.graph.nodes()) {
            int vI = this.toI(v);
            if (vI < startIndex || this.vIndex.containsKey(v)) continue;
            this.getSCCs(startIndex, vI);
        }
        List<Set<V>> result = this.foundSCCs;
        this.foundSCCs = null;
        return result;
    }

    private void getSCCs(int startIndex, int vertexIndex) {
        V vertex = this.toV(vertexIndex);
        this.vIndex.put((Integer)vertex, this.index);
        this.vLowlink.put((Integer)vertex, this.index);
        ++this.index;
        this.path.push(vertex);
        this.pathSet.add(vertex);
        Set edges = this.graph.successors(vertex);
        for (Object successor : edges) {
            int successorIndex = this.toI(successor);
            if (successorIndex < startIndex) continue;
            if (!this.vIndex.containsKey(successor)) {
                this.getSCCs(startIndex, successorIndex);
                this.vLowlink.put((Integer)vertex, Math.min(this.vLowlink.get(vertex), this.vLowlink.get(successor)));
                continue;
            }
            if (!this.pathSet.contains(successor)) continue;
            this.vLowlink.put((Integer)vertex, Math.min(this.vLowlink.get(vertex), this.vIndex.get(successor)));
        }
        if (this.vLowlink.get(vertex).equals(this.vIndex.get(vertex))) {
            V temp;
            HashSet<V> result = new HashSet<V>();
            do {
                temp = this.path.pop();
                this.pathSet.remove(temp);
                result.add(temp);
            } while (!vertex.equals(temp));
            if (result.size() == 1) {
                Object v = result.iterator().next();
                if (this.graph.edges().contains(vertex)) {
                    this.foundSCCs.add(result);
                }
            } else {
                this.foundSCCs.add(result);
            }
        }
    }

    private boolean findCyclesInSCG(int startIndex, int vertexIndex, Graph<V> scg) {
        boolean foundCycle = false;
        V vertex = this.toV(vertexIndex);
        this.stack.push(vertex);
        this.blocked.add(vertex);
        for (Object successor : scg.successors(vertex)) {
            int successorIndex = this.toI(successor);
            if (successorIndex == startIndex) {
                ArrayList cycle = new ArrayList(this.stack.size());
                this.stack.descendingIterator().forEachRemaining(cycle::add);
                this.cycleConsumer.accept(cycle);
                this.cycleVertexSuccessorConsumer.accept(vertex, successor);
                continue;
            }
            if (this.blocked.contains(successor)) continue;
            boolean gotCycle = this.findCyclesInSCG(startIndex, successorIndex, scg);
            foundCycle = foundCycle || gotCycle;
        }
        if (foundCycle) {
            this.unblock(vertex);
        } else {
            for (Object w : scg.successors(vertex)) {
                Set<V> bSet = this.getBSet(w);
                bSet.add(vertex);
            }
        }
        this.stack.pop();
        return foundCycle;
    }

    private void unblock(V vertex) {
        this.blocked.remove(vertex);
        Set<V> bSet = this.getBSet(vertex);
        while (bSet.size() > 0) {
            V w = bSet.iterator().next();
            bSet.remove(w);
            if (!this.blocked.contains(w)) continue;
            this.unblock(w);
        }
    }

    private void initState(Consumer<List<V>> consumer) {
        this.cycleConsumer = consumer;
        this.iToV = this.graph.nodes().toArray();
        this.vToI = new HashMap<V, Integer>();
        this.blocked = new HashSet<V>();
        this.bSets = new HashMap<V, Set<V>>();
        this.stack = new ArrayDeque();
        for (int i = 0; i < this.iToV.length; ++i) {
            this.vToI.put((Integer)this.iToV[i], i);
        }
    }

    private void clearState() {
        this.cycleConsumer = null;
        this.iToV = null;
        this.vToI = null;
        this.blocked = null;
        this.bSets = null;
        this.stack = null;
    }

    private void initMinSCGState() {
        this.index = 0;
        this.foundSCCs = new ArrayList<Set<V>>();
        this.vIndex = new HashMap<V, Integer>();
        this.vLowlink = new HashMap<V, Integer>();
        this.path = new ArrayDeque();
        this.pathSet = new HashSet<V>();
    }

    private void clearMinSCCState() {
        this.index = 0;
        this.foundSCCs = null;
        this.vIndex = null;
        this.vLowlink = null;
        this.path = null;
        this.pathSet = null;
    }

    private Integer toI(V vertex) {
        return this.vToI.get(vertex);
    }

    private V toV(Integer i) {
        return this.iToV[i];
    }

    private Set<V> getBSet(V v) {
        return this.bSets.computeIfAbsent((Set)v, (Function<Set, Set<Set>>)((Function<Object, Set>)k -> new HashSet()));
    }
}

