/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public class PaperEnchantmentRegistryEntry
implements EnchantmentRegistryEntry {
    protected @Nullable Component description;
    protected @Nullable HolderSet<Item> supportedItems;
    protected @Nullable HolderSet<Item> primaryItems;
    protected OptionalInt weight = OptionalInt.empty();
    protected OptionalInt maxLevel = OptionalInt.empty();
    protected @Nullable Enchantment.Cost minimumCost;
    protected @Nullable Enchantment.Cost maximumCost;
    protected OptionalInt anvilCost = OptionalInt.empty();
    protected @Nullable List<EquipmentSlotGroup> activeSlots;
    protected HolderSet<Enchantment> exclusiveWith = HolderSet.empty();
    protected DataComponentMap effects;
    protected final Conversions conversions;

    public PaperEnchantmentRegistryEntry(Conversions conversions, @Nullable Enchantment internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.effects = DataComponentMap.EMPTY;
            return;
        }
        this.description = internal.description();
        Enchantment.EnchantmentDefinition definition = internal.definition();
        this.supportedItems = definition.supportedItems();
        this.primaryItems = definition.primaryItems().orElse(null);
        this.weight = OptionalInt.of(definition.weight());
        this.maxLevel = OptionalInt.of(definition.maxLevel());
        this.minimumCost = definition.minCost();
        this.maximumCost = definition.maxCost();
        this.anvilCost = OptionalInt.of(definition.anvilCost());
        this.activeSlots = definition.slots();
        this.exclusiveWith = internal.exclusiveSet();
        this.effects = internal.effects();
    }

    public net.kyori.adventure.text.Component description() {
        return this.conversions.asAdventure(Checks.asConfigured(this.description, "description"));
    }

    public RegistryKeySet<ItemType> supportedItems() {
        return PaperRegistrySets.convertToApi(RegistryKey.ITEM, Checks.asConfigured(this.supportedItems, "supportedItems"));
    }

    public @Nullable RegistryKeySet<ItemType> primaryItems() {
        return this.primaryItems == null ? null : PaperRegistrySets.convertToApi(RegistryKey.ITEM, this.primaryItems);
    }

    public @Range(from=1L, to=1024L) int weight() {
        return Checks.asConfigured(this.weight, "weight");
    }

    public @Range(from=1L, to=255L) int maxLevel() {
        return Checks.asConfigured(this.maxLevel, "maxLevel");
    }

    public EnchantmentRegistryEntry.EnchantmentCost minimumCost() {
        Enchantment.Cost cost = Checks.asConfigured(this.minimumCost, "minimumCost");
        return EnchantmentRegistryEntry.EnchantmentCost.of((int)cost.base(), (int)cost.perLevelAboveFirst());
    }

    public EnchantmentRegistryEntry.EnchantmentCost maximumCost() {
        Enchantment.Cost cost = Checks.asConfigured(this.maximumCost, "maximumCost");
        return EnchantmentRegistryEntry.EnchantmentCost.of((int)cost.base(), (int)cost.perLevelAboveFirst());
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int anvilCost() {
        return Checks.asConfigured(this.anvilCost, "anvilCost");
    }

    public List<org.bukkit.inventory.EquipmentSlotGroup> activeSlots() {
        return Collections.unmodifiableList(Lists.transform(Checks.asConfigured(this.activeSlots, "activeSlots"), CraftEquipmentSlot::getSlotGroup));
    }

    public RegistryKeySet<org.bukkit.enchantments.Enchantment> exclusiveWith() {
        return PaperRegistrySets.convertToApi(RegistryKey.ENCHANTMENT, this.exclusiveWith);
    }

    public static final class PaperBuilder
    extends PaperEnchantmentRegistryEntry
    implements EnchantmentRegistryEntry.Builder,
    PaperRegistryBuilder<Enchantment, org.bukkit.enchantments.Enchantment> {
        public PaperBuilder(Conversions conversions, @Nullable Enchantment internal) {
            super(conversions, internal);
        }

        public EnchantmentRegistryEntry.Builder description(net.kyori.adventure.text.Component description) {
            this.description = this.conversions.asVanilla(Checks.asArgument(description, "description"));
            return this;
        }

        public EnchantmentRegistryEntry.Builder supportedItems(RegistryKeySet<ItemType> supportedItems) {
            this.supportedItems = PaperRegistrySets.convertToNms(Registries.ITEM, this.conversions.lookup(), Checks.asArgument(supportedItems, "supportedItems"));
            return this;
        }

        public EnchantmentRegistryEntry.Builder primaryItems(@Nullable RegistryKeySet<ItemType> primaryItems) {
            this.primaryItems = primaryItems == null ? null : PaperRegistrySets.convertToNms(Registries.ITEM, this.conversions.lookup(), primaryItems);
            return this;
        }

        public EnchantmentRegistryEntry.Builder weight(@Range(from=1L, to=1024L) int weight) {
            this.weight = OptionalInt.of(Checks.asArgumentRange(weight, "weight", 1, 1024));
            return this;
        }

        public EnchantmentRegistryEntry.Builder maxLevel(@Range(from=1L, to=255L) int maxLevel) {
            this.maxLevel = OptionalInt.of(Checks.asArgumentRange(maxLevel, "maxLevel", 1, 255));
            return this;
        }

        public EnchantmentRegistryEntry.Builder minimumCost(EnchantmentRegistryEntry.EnchantmentCost minimumCost) {
            EnchantmentRegistryEntry.EnchantmentCost validCost = Checks.asArgument(minimumCost, "minimumCost");
            this.minimumCost = Enchantment.dynamicCost(validCost.baseCost(), validCost.additionalPerLevelCost());
            return this;
        }

        public EnchantmentRegistryEntry.Builder maximumCost(EnchantmentRegistryEntry.EnchantmentCost maximumCost) {
            EnchantmentRegistryEntry.EnchantmentCost validCost = Checks.asArgument(maximumCost, "maximumCost");
            this.maximumCost = Enchantment.dynamicCost(validCost.baseCost(), validCost.additionalPerLevelCost());
            return this;
        }

        public EnchantmentRegistryEntry.Builder anvilCost(@Range(from=0L, to=0x7FFFFFFFL) int anvilCost) {
            this.anvilCost = OptionalInt.of(Checks.asArgumentMin(anvilCost, "anvilCost", 0));
            return this;
        }

        public EnchantmentRegistryEntry.Builder activeSlots(Iterable<org.bukkit.inventory.EquipmentSlotGroup> activeSlots) {
            this.activeSlots = Lists.newArrayList((Iterable)Iterables.transform(Checks.asArgument(activeSlots, "activeSlots"), CraftEquipmentSlot::getNMSGroup));
            return this;
        }

        public EnchantmentRegistryEntry.Builder exclusiveWith(RegistryKeySet<org.bukkit.enchantments.Enchantment> exclusiveWith) {
            this.exclusiveWith = PaperRegistrySets.convertToNms(Registries.ENCHANTMENT, this.conversions.lookup(), Checks.asArgument(exclusiveWith, "exclusiveWith"));
            return this;
        }

        @Override
        public Enchantment build() {
            Enchantment.EnchantmentDefinition def = new Enchantment.EnchantmentDefinition(Checks.asConfigured(this.supportedItems, "supportedItems"), Optional.ofNullable(this.primaryItems), this.weight(), this.maxLevel(), Checks.asConfigured(this.minimumCost, "minimumCost"), Checks.asConfigured(this.maximumCost, "maximumCost"), this.anvilCost(), Collections.unmodifiableList(Checks.asConfigured(this.activeSlots, "activeSlots")));
            return new Enchantment(Checks.asConfigured(this.description, "description"), def, this.exclusiveWith, this.effects);
        }
    }
}

