/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;

public record SelectorPattern(String pattern, EntitySelector resolved) {
    public static final Codec<SelectorPattern> CODEC = Codec.STRING.comapFlatMap(SelectorPattern::parse, SelectorPattern::pattern);

    public static DataResult<SelectorPattern> parse(String pattern) {
        try {
            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(new StringReader(pattern), true);
            return DataResult.success((Object)new SelectorPattern(pattern, entitySelectorParser.parse()));
        }
        catch (CommandSyntaxException var2) {
            return DataResult.error(() -> "Invalid selector component");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SelectorPattern)) return false;
        SelectorPattern selectorPattern = (SelectorPattern)other;
        if (!this.pattern.equals(selectorPattern.pattern)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public String toString() {
        return this.pattern;
    }
}

