/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.EntryAction;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.ContinuationTask;
import net.minecraft.commands.execution.tasks.ExecuteCommand;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.network.chat.Component;

public class BuildContexts<T extends ExecutionCommandSource<T>> {
    @VisibleForTesting
    public static final DynamicCommandExceptionType ERROR_FORK_LIMIT_REACHED = new DynamicCommandExceptionType(forkLimit -> Component.translatableEscape("command.forkLimit", forkLimit));
    private final String commandInput;
    private final ContextChain<T> command;

    public BuildContexts(String commandInput, ContextChain<T> command) {
        this.commandInput = commandInput;
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(T originalSource, List<T> sources, ExecutionContext<T> context, Frame frame, ChainModifiers chainModifiers) {
        Command redirectModifier;
        ContextChain contextChain = this.command;
        ChainModifiers chainModifiers1 = chainModifiers;
        List<Object> list = sources;
        if (contextChain.getStage() != ContextChain.Stage.EXECUTE) {
            context.profiler().push(() -> "prepare " + this.commandInput);
            try {
                int forkLimit = context.forkLimit();
                while (contextChain.getStage() != ContextChain.Stage.EXECUTE) {
                    CommandContext topContext = contextChain.getTopContext();
                    if (topContext.isForked()) {
                        chainModifiers1 = chainModifiers1.setForked();
                    }
                    if ((redirectModifier = topContext.getRedirectModifier()) instanceof CustomModifierExecutor.ModifierAdapter) {
                        CustomModifierExecutor.ModifierAdapter customModifierExecutor = (CustomModifierExecutor.ModifierAdapter)redirectModifier;
                        customModifierExecutor.apply(originalSource, list, contextChain, chainModifiers1, ExecutionControl.create(context, frame));
                        return;
                    }
                    if (redirectModifier != null) {
                        context.incrementCost();
                        boolean isForked = chainModifiers1.isForked();
                        ObjectArrayList objectArrayList = new ObjectArrayList();
                        for (ExecutionCommandSource executionCommandSource : list) {
                            Collection collection;
                            block22: {
                                try {
                                    collection = ContextChain.runModifier((CommandContext)topContext, (Object)executionCommandSource, (commandContext, flag, i) -> {}, (boolean)isForked);
                                    if (objectArrayList.size() + collection.size() < forkLimit) break block22;
                                    originalSource.handleError(ERROR_FORK_LIMIT_REACHED.create((Object)forkLimit), isForked, context.tracer());
                                    return;
                                }
                                catch (CommandSyntaxException var20) {
                                    executionCommandSource.handleError(var20, isForked, context.tracer());
                                    if (isForked) continue;
                                    context.profiler().pop();
                                    return;
                                }
                            }
                            objectArrayList.addAll(collection);
                        }
                        list = objectArrayList;
                    }
                    contextChain = contextChain.nextStage();
                }
            }
            finally {
                context.profiler().pop();
            }
        }
        if (list.isEmpty()) {
            if (chainModifiers1.isReturn()) {
                context.queueNext(new CommandQueueEntry(frame, FallthroughTask.instance()));
            }
        } else {
            CommandContext topContext1 = contextChain.getTopContext();
            redirectModifier = topContext1.getCommand();
            if (redirectModifier instanceof CustomCommandExecutor.CommandAdapter) {
                CustomCommandExecutor.CommandAdapter customCommandExecutor = (CustomCommandExecutor.CommandAdapter)redirectModifier;
                ExecutionControl executionControl = ExecutionControl.create(context, frame);
                for (ExecutionCommandSource executionCommandSource : list) {
                    customCommandExecutor.run(executionCommandSource, contextChain, chainModifiers1, executionControl);
                }
            } else {
                if (chainModifiers1.isReturn()) {
                    ExecutionCommandSource executionCommandSource2 = (ExecutionCommandSource)list.get(0);
                    executionCommandSource2 = executionCommandSource2.withCallback(CommandResultCallback.chain(executionCommandSource2.callback(), frame.returnValueConsumer()));
                    list = List.of(executionCommandSource2);
                }
                ExecuteCommand executeCommand = new ExecuteCommand(this.commandInput, chainModifiers1, topContext1);
                ContinuationTask.schedule(context, frame, list, (frame1, argument) -> new CommandQueueEntry<ExecutionCommandSource>(frame1, executeCommand.bind(argument)));
            }
        }
    }

    protected void traceCommandStart(ExecutionContext<T> executionContext, Frame frame) {
        TraceCallbacks traceCallbacks = executionContext.tracer();
        if (traceCallbacks != null) {
            traceCallbacks.onCommand(frame.depth(), this.commandInput);
        }
    }

    public String toString() {
        return this.commandInput;
    }

    public static class Unbound<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements UnboundEntryAction<T> {
        public Unbound(String commandInput, ContextChain<T> command) {
            super(commandInput, command);
        }

        @Override
        public void execute(T source, ExecutionContext<T> executionContext, Frame frame) {
            this.traceCommandStart(executionContext, frame);
            this.execute(source, List.of(source), executionContext, frame, ChainModifiers.DEFAULT);
        }
    }

    public static class TopLevel<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final T source;

        public TopLevel(String commandInput, ContextChain<T> command, T source) {
            super(commandInput, command);
            this.source = source;
        }

        @Override
        public void execute(ExecutionContext<T> context, Frame frame) {
            this.traceCommandStart(context, frame);
            this.execute(this.source, List.of(this.source), context, frame, ChainModifiers.DEFAULT);
        }
    }

    public static class Continuation<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final ChainModifiers modifiers;
        private final T originalSource;
        private final List<T> sources;

        public Continuation(String commandInput, ContextChain<T> command, ChainModifiers modifiers, T originalSource, List<T> sources) {
            super(commandInput, command);
            this.originalSource = originalSource;
            this.sources = sources;
            this.modifiers = modifiers;
        }

        @Override
        public void execute(ExecutionContext<T> context, Frame frame) {
            this.execute(this.originalSource, this.sources, context, frame, this.modifiers);
        }
    }
}

