/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class DoubleArgumentInfo
implements ArgumentTypeInfo<DoubleArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
        boolean flag = template.min != -1.7976931348623157E308;
        boolean flag1 = template.max != Double.MAX_VALUE;
        buffer.writeByte(ArgumentUtils.createNumberFlags(flag, flag1));
        if (flag) {
            buffer.writeDouble(template.min);
        }
        if (flag1) {
            buffer.writeDouble(template.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
        byte _byte = buffer.readByte();
        double d = ArgumentUtils.numberHasMin(_byte) ? buffer.readDouble() : -1.7976931348623157E308;
        double d1 = ArgumentUtils.numberHasMax(_byte) ? buffer.readDouble() : Double.MAX_VALUE;
        return new Template(d, d1);
    }

    @Override
    public void serializeToJson(Template template, JsonObject json) {
        if (template.min != -1.7976931348623157E308) {
            json.addProperty("min", (Number)template.min);
        }
        if (template.max != Double.MAX_VALUE) {
            json.addProperty("max", (Number)template.max);
        }
    }

    @Override
    public Template unpack(DoubleArgumentType argument) {
        return new Template(argument.getMinimum(), argument.getMaximum());
    }

    public final class Template
    implements ArgumentTypeInfo.Template<DoubleArgumentType> {
        final double min;
        final double max;

        Template(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public DoubleArgumentType instantiate(CommandBuildContext context) {
            return DoubleArgumentType.doubleArg((double)this.min, (double)this.max);
        }

        @Override
        public ArgumentTypeInfo<DoubleArgumentType, ?> type() {
            return DoubleArgumentInfo.this;
        }
    }
}

