/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.entity.EntityAccess;

public class SectionPos
extends Vec3i {
    public static final int SECTION_BITS = 4;
    public static final int SECTION_SIZE = 16;
    public static final int SECTION_MASK = 15;
    public static final int SECTION_HALF_SIZE = 8;
    public static final int SECTION_MAX_INDEX = 15;
    private static final int PACKED_X_LENGTH = 22;
    private static final int PACKED_Y_LENGTH = 20;
    private static final int PACKED_Z_LENGTH = 22;
    private static final long PACKED_X_MASK = 0x3FFFFFL;
    private static final long PACKED_Y_MASK = 1048575L;
    private static final long PACKED_Z_MASK = 0x3FFFFFL;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET = 20;
    private static final int X_OFFSET = 42;
    private static final int RELATIVE_X_SHIFT = 8;
    private static final int RELATIVE_Y_SHIFT = 0;
    private static final int RELATIVE_Z_SHIFT = 4;

    SectionPos(int x, int y, int z) {
        super(x, y, z);
    }

    public static SectionPos of(int chunkX, int chunkY, int chunkZ) {
        return new SectionPos(chunkX, chunkY, chunkZ);
    }

    public static SectionPos of(BlockPos pos) {
        return new SectionPos(pos.getX() >> 4, pos.getY() >> 4, pos.getZ() >> 4);
    }

    public static SectionPos of(ChunkPos chunkPos, int y) {
        return new SectionPos(chunkPos.x, y, chunkPos.z);
    }

    public static SectionPos of(EntityAccess entity) {
        return SectionPos.of(entity.blockPosition());
    }

    public static SectionPos of(Position position) {
        return new SectionPos(SectionPos.blockToSectionCoord(position.x()), SectionPos.blockToSectionCoord(position.y()), SectionPos.blockToSectionCoord(position.z()));
    }

    public static SectionPos of(long packed) {
        return new SectionPos((int)(packed >> 42), (int)(packed << 44 >> 44), (int)(packed << 22 >> 42));
    }

    public static SectionPos bottomOf(ChunkAccess chunk) {
        return SectionPos.of(chunk.getPos(), chunk.getMinSectionY());
    }

    public static long offset(long packed, Direction direction) {
        return SectionPos.offset(packed, direction.getStepX(), direction.getStepY(), direction.getStepZ());
    }

    public static long getAdjacentFromBlockPos(int x, int y, int z, Direction direction) {
        return ((long)((x >> 4) + direction.getStepX()) & 0x3FFFFFL) << 42 | (long)((y >> 4) + direction.getStepY()) & 0xFFFFFL | ((long)((z >> 4) + direction.getStepZ()) & 0x3FFFFFL) << 20;
    }

    public static long getAdjacentFromSectionPos(int x, int y, int z, Direction direction) {
        return ((long)(x + direction.getStepX()) & 0x3FFFFFL) << 42 | (long)(y + direction.getStepY()) & 0xFFFFFL | ((long)(z + direction.getStepZ()) & 0x3FFFFFL) << 20;
    }

    public static long offset(long packed, int dx, int dy, int dz) {
        return ((long)((int)(packed >> 42) + dx) & 0x3FFFFFL) << 42 | (long)((int)(packed << 44 >> 44) + dy) & 0xFFFFFL | ((long)((int)(packed << 22 >> 42) + dz) & 0x3FFFFFL) << 20;
    }

    public static int posToSectionCoord(double pos) {
        return SectionPos.blockToSectionCoord(Mth.floor(pos));
    }

    public static int blockToSectionCoord(int blockCoord) {
        return blockCoord >> 4;
    }

    public static int blockToSectionCoord(double coord) {
        return Mth.floor(coord) >> 4;
    }

    public static int sectionRelative(int rel) {
        return rel & 0xF;
    }

    public static short sectionRelativePos(BlockPos pos) {
        return (short)((pos.getX() & 0xF) << 8 | (pos.getZ() & 0xF) << 4 | pos.getY() & 0xF);
    }

    public static int sectionRelativeX(short x) {
        return x >>> 8 & 0xF;
    }

    public static int sectionRelativeY(short y) {
        return y >>> 0 & 0xF;
    }

    public static int sectionRelativeZ(short z) {
        return z >>> 4 & 0xF;
    }

    public int relativeToBlockX(short x) {
        return this.minBlockX() + SectionPos.sectionRelativeX(x);
    }

    public int relativeToBlockY(short y) {
        return this.minBlockY() + SectionPos.sectionRelativeY(y);
    }

    public int relativeToBlockZ(short z) {
        return this.minBlockZ() + SectionPos.sectionRelativeZ(z);
    }

    public BlockPos relativeToBlockPos(short pos) {
        return new BlockPos(this.relativeToBlockX(pos), this.relativeToBlockY(pos), this.relativeToBlockZ(pos));
    }

    public static int sectionToBlockCoord(int sectionCoord) {
        return sectionCoord << 4;
    }

    public static int sectionToBlockCoord(int pos, int offset) {
        return SectionPos.sectionToBlockCoord(pos) + offset;
    }

    public static int x(long packed) {
        return (int)(packed << 0 >> 42);
    }

    public static int y(long packed) {
        return (int)(packed << 44 >> 44);
    }

    public static int z(long packed) {
        return (int)(packed << 22 >> 42);
    }

    public int x() {
        return this.getX();
    }

    public int y() {
        return this.getY();
    }

    public int z() {
        return this.getZ();
    }

    public final int minBlockX() {
        return this.getX() << 4;
    }

    public final int minBlockY() {
        return this.getY() << 4;
    }

    public final int minBlockZ() {
        return this.getZ() << 4;
    }

    public int maxBlockX() {
        return SectionPos.sectionToBlockCoord(this.x(), 15);
    }

    public int maxBlockY() {
        return SectionPos.sectionToBlockCoord(this.y(), 15);
    }

    public int maxBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z(), 15);
    }

    public static long blockToSection(long levelPos) {
        return ((long)((int)(levelPos >> 42)) & 0x3FFFFFL) << 42 | (long)((int)(levelPos << 52 >> 56)) & 0xFFFFFL | ((long)((int)(levelPos << 26 >> 42)) & 0x3FFFFFL) << 20;
    }

    public static long getZeroNode(int x, int z) {
        return SectionPos.getZeroNode(SectionPos.asLong(x, 0, z));
    }

    public static long getZeroNode(long pos) {
        return pos & 0xFFFFFFFFFFF00000L;
    }

    public static long sectionToChunk(long pos) {
        return ChunkPos.asLong(SectionPos.x(pos), SectionPos.z(pos));
    }

    public BlockPos origin() {
        return new BlockPos(SectionPos.sectionToBlockCoord(this.x()), SectionPos.sectionToBlockCoord(this.y()), SectionPos.sectionToBlockCoord(this.z()));
    }

    public BlockPos center() {
        int i = 8;
        return this.origin().offset(8, 8, 8);
    }

    public ChunkPos chunk() {
        return new ChunkPos(this.x(), this.z());
    }

    public static long asLong(BlockPos blockPos) {
        return SectionPos.asLong(SectionPos.blockToSectionCoord(blockPos.getX()), SectionPos.blockToSectionCoord(blockPos.getY()), SectionPos.blockToSectionCoord(blockPos.getZ()));
    }

    public static long blockPosAsSectionLong(int x, int y, int z) {
        return ((long)(x >> 4) & 0x3FFFFFL) << 42 | (long)(y >> 4) & 0xFFFFFL | ((long)(z >> 4) & 0x3FFFFFL) << 20;
    }

    public static long asLong(int x, int y, int z) {
        return ((long)x & 0x3FFFFFL) << 42 | (long)y & 0xFFFFFL | ((long)z & 0x3FFFFFL) << 20;
    }

    public long asLong() {
        return ((long)this.getX() & 0x3FFFFFL) << 42 | (long)this.getY() & 0xFFFFFL | ((long)this.getZ() & 0x3FFFFFL) << 20;
    }

    @Override
    public SectionPos offset(int dx, int dy, int dz) {
        return dx == 0 && dy == 0 && dz == 0 ? this : new SectionPos(this.x() + dx, this.y() + dy, this.z() + dz);
    }

    public Stream<BlockPos> blocksInside() {
        return BlockPos.betweenClosedStream(this.minBlockX(), this.minBlockY(), this.minBlockZ(), this.maxBlockX(), this.maxBlockY(), this.maxBlockZ());
    }

    public static Stream<SectionPos> cube(SectionPos center, int radius) {
        return SectionPos.betweenClosedStream(center.getX() - radius, center.getY() - radius, center.getZ() - radius, center.getX() + radius, center.getY() + radius, center.getZ() + radius);
    }

    public static Stream<SectionPos> aroundChunk(ChunkPos chunkPos, int radius, int minY, int maxY) {
        int i = chunkPos.x;
        int i1 = chunkPos.z;
        return SectionPos.betweenClosedStream(i - radius, minY, i1 - radius, i + radius, maxY, i1 + radius);
    }

    public static Stream<SectionPos> betweenClosedStream(final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<SectionPos>((long)((x2 - x1 + 1) * (y2 - y1 + 1) * (z2 - z1 + 1)), 64){
            final Cursor3D cursor;
            {
                super(arg0, arg1);
                this.cursor = new Cursor3D(x1, y1, z1, x2, y2, z2);
            }

            @Override
            public boolean tryAdvance(Consumer<? super SectionPos> consumer) {
                if (this.cursor.advance()) {
                    consumer.accept(new SectionPos(this.cursor.nextX(), this.cursor.nextY(), this.cursor.nextZ()));
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static void aroundAndAtBlockPos(BlockPos pos, LongConsumer consumer) {
        SectionPos.aroundAndAtBlockPos(pos.getX(), pos.getY(), pos.getZ(), consumer);
    }

    public static void aroundAndAtBlockPos(long pos, LongConsumer consumer) {
        SectionPos.aroundAndAtBlockPos(BlockPos.getX(pos), BlockPos.getY(pos), BlockPos.getZ(pos), consumer);
    }

    public static void aroundAndAtBlockPos(int x, int y, int z, LongConsumer consumer) {
        int sectionPosCoord = SectionPos.blockToSectionCoord(x - 1);
        int sectionPosCoord1 = SectionPos.blockToSectionCoord(x + 1);
        int sectionPosCoord2 = SectionPos.blockToSectionCoord(y - 1);
        int sectionPosCoord3 = SectionPos.blockToSectionCoord(y + 1);
        int sectionPosCoord4 = SectionPos.blockToSectionCoord(z - 1);
        int sectionPosCoord5 = SectionPos.blockToSectionCoord(z + 1);
        if (sectionPosCoord == sectionPosCoord1 && sectionPosCoord2 == sectionPosCoord3 && sectionPosCoord4 == sectionPosCoord5) {
            consumer.accept(SectionPos.asLong(sectionPosCoord, sectionPosCoord2, sectionPosCoord4));
        } else {
            for (int i = sectionPosCoord; i <= sectionPosCoord1; ++i) {
                for (int i1 = sectionPosCoord2; i1 <= sectionPosCoord3; ++i1) {
                    for (int i2 = sectionPosCoord4; i2 <= sectionPosCoord5; ++i2) {
                        consumer.accept(SectionPos.asLong(i, i1, i2));
                    }
                }
            }
        }
    }
}

