/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.papermc.paper.util.sanitizer.ItemComponentSanitizer;
import io.papermc.paper.util.sanitizer.ItemObfuscationSession;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;

public final class DataComponentPatch {
    public static final DataComponentPatch EMPTY = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> CODEC = Codec.dispatchedMap(PatchKey.CODEC, PatchKey::valueCodec).xmap(map -> {
        if (map.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap map1 = new Reference2ObjectArrayMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            PatchKey patchKey = (PatchKey)entry.getKey();
            if (patchKey.removed()) {
                map1.put(patchKey.type(), Optional.empty());
                continue;
            }
            map1.put(patchKey.type(), Optional.of(entry.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)map1);
    }, dataComponentPatch -> {
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(dataComponentPatch.map.size());
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(dataComponentPatch.map)) {
            DataComponentType dataComponentType = (DataComponentType)entry.getKey();
            if (dataComponentType.isTransient()) continue;
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                map.put((Object)new PatchKey(dataComponentType, false), optional.get());
                continue;
            }
            map.put((Object)new PatchKey(dataComponentType, true), (Object)Unit.INSTANCE);
        }
        return map;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> STREAM_CODEC = DataComponentPatch.createStreamCodec(new CodecGetter(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> componentType) {
            return componentType.streamCodec().cast();
        }
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> DELIMITED_STREAM_CODEC = DataComponentPatch.createStreamCodec(new CodecGetter(){

        public <T> StreamCodec<RegistryFriendlyByteBuf, T> apply(DataComponentType<T> componentType) {
            StreamCodec streamCodec = componentType.streamCodec().cast();
            return streamCodec.apply(ByteBufCodecs.lengthPrefixed(Integer.MAX_VALUE));
        }
    });
    private static final String REMOVED_PREFIX = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map;

    private static StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> createStreamCodec(final CodecGetter codecGetter) {
        return new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

            @Override
            public DataComponentPatch decode(RegistryFriendlyByteBuf buffer) {
                DataComponentType dataComponentType;
                int i1;
                int varInt = buffer.readVarInt();
                int varInt1 = buffer.readVarInt();
                if (varInt == 0 && varInt1 == 0) {
                    return EMPTY;
                }
                int i = varInt + varInt1;
                Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(Math.min(i, 65536));
                for (i1 = 0; i1 < varInt; ++i1) {
                    dataComponentType = (DataComponentType)DataComponentType.STREAM_CODEC.decode(buffer);
                    Object object = codecGetter.apply(dataComponentType).decode(buffer);
                    map.put((Object)dataComponentType, Optional.of(object));
                }
                for (i1 = 0; i1 < varInt1; ++i1) {
                    dataComponentType = (DataComponentType)DataComponentType.STREAM_CODEC.decode(buffer);
                    map.put((Object)dataComponentType, Optional.empty());
                }
                return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)map);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, DataComponentPatch value) {
                if (value.isEmpty()) {
                    buffer.writeVarInt(0);
                    buffer.writeVarInt(0);
                } else {
                    ItemObfuscationSession itemObfuscationSession = value.map.isEmpty() ? null : ItemObfuscationSession.currentSession();
                    int i = 0;
                    int i1 = 0;
                    for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(value.map)) {
                        if (((Optional)entry.getValue()).isPresent()) {
                            if (ItemComponentSanitizer.shouldDrop(itemObfuscationSession, (DataComponentType)entry.getKey())) continue;
                            ++i;
                            continue;
                        }
                        ++i1;
                    }
                    buffer.writeVarInt(i);
                    buffer.writeVarInt(i1);
                    for (Reference2ObjectMap.Entry entryx : Reference2ObjectMaps.fastIterable(value.map)) {
                        Optional<?> optional = (Optional<?>)entryx.getValue();
                        optional = ItemComponentSanitizer.override(itemObfuscationSession, (DataComponentType)entryx.getKey(), (Optional)entryx.getValue());
                        if (!optional.isPresent()) continue;
                        DataComponentType dataComponentType = (DataComponentType)entryx.getKey();
                        DataComponentType.STREAM_CODEC.encode(buffer, dataComponentType);
                        this.encodeComponent(buffer, dataComponentType, optional.get());
                    }
                    for (Reference2ObjectMap.Entry entryxx : Reference2ObjectMaps.fastIterable(value.map)) {
                        if (!((Optional)entryxx.getValue()).isEmpty()) continue;
                        DataComponentType dataComponentType1 = (DataComponentType)entryxx.getKey();
                        DataComponentType.STREAM_CODEC.encode(buffer, dataComponentType1);
                    }
                }
            }

            private <T> void encodeComponent(RegistryFriendlyByteBuf buffer, DataComponentType<T> component, Object value) {
                try {
                    codecGetter.apply(component).encode(buffer, value);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error encoding component " + String.valueOf(component), e);
                }
            }
        };
    }

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> map) {
        this.map = map;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public <T> Optional<? extends T> get(DataComponentType<? extends T> component) {
        return (Optional)this.map.get(component);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public DataComponentPatch forget(Predicate<DataComponentType<?>> predicate) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(this.map);
        map.keySet().removeIf(predicate);
        return map.isEmpty() ? EMPTY : new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)map);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public SplitResult split() {
        if (this.isEmpty()) {
            return SplitResult.EMPTY;
        }
        DataComponentMap.Builder builder = DataComponentMap.builder();
        Set set = Sets.newIdentityHashSet();
        this.map.forEach((component, value) -> {
            if (value.isPresent()) {
                builder.setUnchecked(component, value.get());
            } else {
                set.add(component);
            }
        });
        return new SplitResult(builder.build(), set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof DataComponentPatch)) return false;
        DataComponentPatch dataComponentPatch = (DataComponentPatch)other;
        if (!this.map.equals(dataComponentPatch.map)) return false;
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return DataComponentPatch.toString(this.map);
    }

    static String toString(Reference2ObjectMap<DataComponentType<?>, Optional<?>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean flag = true;
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(map)) {
            if (flag) {
                flag = false;
            } else {
                stringBuilder.append(", ");
            }
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=>");
                stringBuilder.append(optional.get());
                continue;
            }
            stringBuilder.append(REMOVED_PREFIX);
            stringBuilder.append(entry.getKey());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @FunctionalInterface
    static interface CodecGetter {
        public <T> StreamCodec<? super RegistryFriendlyByteBuf, T> apply(DataComponentType<T> var1);
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public void copy(DataComponentPatch orig) {
            this.map.putAll(orig.map);
        }

        public void clear(DataComponentType<?> type) {
            this.map.remove(type);
        }

        public boolean isSet(DataComponentType<?> type) {
            return this.map.containsKey(type);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Builder) {
                Builder patch = (Builder)object;
                return this.map.equals(patch.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public <T> Builder set(DataComponentType<T> component, T value) {
            this.map.put(component, Optional.of(value));
            return this;
        }

        public <T> Builder remove(DataComponentType<T> component) {
            this.map.put(component, Optional.empty());
            return this;
        }

        public <T> Builder set(TypedDataComponent<T> component) {
            return this.set(component.type(), component.value());
        }

        public DataComponentPatch build() {
            return this.map.isEmpty() ? EMPTY : new DataComponentPatch(this.map);
        }
    }

    public record SplitResult(DataComponentMap added, Set<DataComponentType<?>> removed) {
        public static final SplitResult EMPTY = new SplitResult(DataComponentMap.EMPTY, Set.of());
    }

    record PatchKey(DataComponentType<?> type, boolean removed) {
        public static final Codec<PatchKey> CODEC = Codec.STRING.flatXmap(str -> {
            ResourceLocation resourceLocation;
            DataComponentType<?> dataComponentType;
            boolean flag = str.startsWith(DataComponentPatch.REMOVED_PREFIX);
            if (flag) {
                str = str.substring(DataComponentPatch.REMOVED_PREFIX.length());
            }
            if ((dataComponentType = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(resourceLocation = ResourceLocation.tryParse(str))) == null) {
                return DataResult.error(() -> "No component with type: '" + String.valueOf(resourceLocation) + "'");
            }
            return dataComponentType.isTransient() ? DataResult.error(() -> "'" + String.valueOf(resourceLocation) + "' is not a persistent component") : DataResult.success((Object)new PatchKey(dataComponentType, flag));
        }, key -> {
            DataComponentType<?> dataComponentType = key.type();
            ResourceLocation key1 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(dataComponentType);
            return key1 == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(dataComponentType)) : DataResult.success((Object)(key.removed() ? DataComponentPatch.REMOVED_PREFIX + String.valueOf(key1) : key1.toString()));
        });

        public Codec<?> valueCodec() {
            return this.removed ? Codec.EMPTY.codec() : this.type.codecOrThrow();
        }
    }
}

