/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.MinecartDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.AABB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.craftbukkit.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public interface DispenseItemBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DispenseItemBehavior NOOP = (blockSource, item) -> item;

    public net.minecraft.world.item.ItemStack dispense(BlockSource var1, net.minecraft.world.item.ItemStack var2);

    public static void bootStrap() {
        DispenserBlock.registerProjectileBehavior(Items.ARROW);
        DispenserBlock.registerProjectileBehavior(Items.TIPPED_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.SPECTRAL_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.EGG);
        DispenserBlock.registerProjectileBehavior(Items.BLUE_EGG);
        DispenserBlock.registerProjectileBehavior(Items.BROWN_EGG);
        DispenserBlock.registerProjectileBehavior(Items.SNOWBALL);
        DispenserBlock.registerProjectileBehavior(Items.EXPERIENCE_BOTTLE);
        DispenserBlock.registerProjectileBehavior(Items.SPLASH_POTION);
        DispenserBlock.registerProjectileBehavior(Items.LINGERING_POTION);
        DispenserBlock.registerProjectileBehavior(Items.FIREWORK_ROCKET);
        DispenserBlock.registerProjectileBehavior(Items.FIRE_CHARGE);
        DispenserBlock.registerProjectileBehavior(Items.WIND_CHARGE);
        DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
                EntityType<?> type = ((SpawnEggItem)item.getItem()).getType(blockSource.level().registryAccess(), item);
                ServerLevel serverLevel = blockSource.level();
                net.minecraft.world.item.ItemStack singleItemStack = item.copyWithCount(1);
                CraftBlock block = CraftBlock.at(serverLevel, blockSource.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(singleItemStack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return item;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack);
                    if (dispenseBehavior != NOOP && dispenseBehavior != this) {
                        dispenseBehavior.dispense(blockSource, eventStack);
                        return item;
                    }
                    singleItemStack = CraftItemStack.unwrap(event.getItem());
                    type = ((SpawnEggItem)singleItemStack.getItem()).getType(serverLevel.registryAccess(), singleItemStack);
                }
                try {
                    type.spawn(blockSource.level(), singleItemStack, null, blockSource.pos().relative(direction), EntitySpawnReason.DISPENSER, direction != Direction.UP, false);
                }
                catch (Exception var6) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.pos(), (Object)var6);
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                if (shrink) {
                    item.shrink(1);
                }
                blockSource.level().gameEvent(null, GameEvent.ENTITY_PLACE, blockSource.pos());
                return item;
            }
        };
        for (SpawnEggItem spawnEggItem : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior(spawnEggItem, defaultDispenseItemBehavior);
        }
        DispenserBlock.registerBehavior(Items.ARMOR_STAND, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                net.minecraft.world.item.ItemStack newStack;
                Consumer<ArmorStand> consumer;
                ArmorStand armorStand;
                Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                ServerLevel serverLevel = blockSource.level();
                net.minecraft.world.item.ItemStack singleItemStack = item.copyWithCount(1);
                CraftBlock block = CraftBlock.at(serverLevel, blockSource.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(singleItemStack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return item;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack);
                    if (dispenseBehavior != NOOP && dispenseBehavior != this) {
                        dispenseBehavior.dispense(blockSource, eventStack);
                        return item;
                    }
                }
                if ((armorStand = EntityType.ARMOR_STAND.spawn(serverLevel, consumer = EntityType.appendDefaultStackConfig(armorStand1 -> armorStand1.setYRot(direction.toYRot()), serverLevel, newStack = CraftItemStack.unwrap(event.getItem()), null), blockPos, EntitySpawnReason.DISPENSER, false, false)) != null && shrink) {
                    item.shrink(1);
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior(Items.CHEST, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                for (AbstractChestedHorse abstractChestedHorse : blockSource.level().getEntitiesOfClass(AbstractChestedHorse.class, new AABB(blockPos), abstractChestedHorse1 -> abstractChestedHorse1.isAlive() && !abstractChestedHorse1.hasChest())) {
                    if (!abstractChestedHorse.isTamed()) continue;
                    net.minecraft.world.item.ItemStack singleCopy = item.copyWithCount(1);
                    ServerLevel world = blockSource.level();
                    CraftBlock block = CraftBlock.at(world, blockSource.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(singleCopy);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)abstractChestedHorse.getBukkitLivingEntity());
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.setSuccess(false);
                        return item;
                    }
                    boolean shrink = true;
                    if (!event.getItem().equals((Object)craftItem)) {
                        shrink = false;
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                        DispenseItemBehavior dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack);
                        if (dispenseBehavior != NOOP && dispenseBehavior != this) {
                            dispenseBehavior.dispense(blockSource, eventStack);
                            return item;
                        }
                    }
                    abstractChestedHorse.getSlot(499).set(CraftItemStack.asNMSCopy(event.getItem()));
                    if (shrink) {
                        item.shrink(1);
                    }
                    this.setSuccess(true);
                    return item;
                }
                return super.execute(blockSource, item);
            }
        });
        DispenserBlock.registerBehavior(Items.OAK_BOAT, new BoatDispenseItemBehavior(EntityType.OAK_BOAT));
        DispenserBlock.registerBehavior(Items.SPRUCE_BOAT, new BoatDispenseItemBehavior(EntityType.SPRUCE_BOAT));
        DispenserBlock.registerBehavior(Items.BIRCH_BOAT, new BoatDispenseItemBehavior(EntityType.BIRCH_BOAT));
        DispenserBlock.registerBehavior(Items.JUNGLE_BOAT, new BoatDispenseItemBehavior(EntityType.JUNGLE_BOAT));
        DispenserBlock.registerBehavior(Items.DARK_OAK_BOAT, new BoatDispenseItemBehavior(EntityType.DARK_OAK_BOAT));
        DispenserBlock.registerBehavior(Items.ACACIA_BOAT, new BoatDispenseItemBehavior(EntityType.ACACIA_BOAT));
        DispenserBlock.registerBehavior(Items.CHERRY_BOAT, new BoatDispenseItemBehavior(EntityType.CHERRY_BOAT));
        DispenserBlock.registerBehavior(Items.MANGROVE_BOAT, new BoatDispenseItemBehavior(EntityType.MANGROVE_BOAT));
        DispenserBlock.registerBehavior(Items.PALE_OAK_BOAT, new BoatDispenseItemBehavior(EntityType.PALE_OAK_BOAT));
        DispenserBlock.registerBehavior(Items.BAMBOO_RAFT, new BoatDispenseItemBehavior(EntityType.BAMBOO_RAFT));
        DispenserBlock.registerBehavior(Items.OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.SPRUCE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.SPRUCE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.BIRCH_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.BIRCH_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.JUNGLE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.JUNGLE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.DARK_OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.ACACIA_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.ACACIA_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.CHERRY_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.CHERRY_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.MANGROVE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.MANGROVE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.PALE_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.PALE_OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.BAMBOO_CHEST_RAFT, new BoatDispenseItemBehavior(EntityType.BAMBOO_CHEST_RAFT));
        DefaultDispenseItemBehavior dispenseItemBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            /*
             * Unable to fully structure code
             */
            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                dispensibleContainerItem = (DispensibleContainerItem)item.getItem();
                blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                level = blockSource.level();
                state = level.getBlockState(blockPos);
                dispensedItem = item;
                v0 = willEmptyContentsSolidBucketItem = dispensibleContainerItem instanceof SolidBucketItem != false && level.isInWorldBounds(blockPos) != false && state.isAir() != false;
                if (!(dispensibleContainerItem instanceof BucketItem)) ** GOTO lbl-1000
                bucketItem = (BucketItem)dispensibleContainerItem;
                if (bucketItem.content instanceof FlowingFluid && (state.isAir() || state.canBeReplaced(bucketItem.content) || (var12_10 = state.getBlock()) instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)var12_10).canPlaceLiquid(null, level, blockPos, state, bucketItem.content))) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = willEmptyBucketItem = false;
                }
                if (willEmptyContentsSolidBucketItem || willEmptyBucketItem) {
                    block = CraftBlock.at(level, blockSource.pos());
                    craftItem = CraftItemStack.asCraftMirror(item.copyWithCount(1));
                    event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), CraftVector.toBukkit(blockPos));
                    level.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return item;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != DispenseItemBehavior.NOOP && dispenseBehavior != this) {
                        dispenseBehavior.dispense(blockSource, eventStack);
                        return item;
                    }
                    dispensedItem = CraftItemStack.unwrap(event.getItem());
                    dispensibleContainerItem = (DispensibleContainerItem)dispensedItem.getItem();
                }
                if (dispensibleContainerItem.emptyContents(null, level, blockPos, null)) {
                    dispensibleContainerItem.checkExtraContent(null, level, dispensedItem, blockPos);
                    return this.consumeWithRemainder(blockSource, item, new net.minecraft.world.item.ItemStack(Items.BUCKET));
                }
                return this.defaultDispenseItemBehavior.dispense(blockSource, item);
            }
        };
        DispenserBlock.registerBehavior(Items.LAVA_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.WATER_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.POWDER_SNOW_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.SALMON_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.COD_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.PUFFERFISH_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.TROPICAL_FISH_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.AXOLOTL_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.TADPOLE_BUCKET, dispenseItemBehavior);
        DispenserBlock.registerBehavior(Items.BUCKET, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                BlockPos blockPos;
                ServerLevel levelAccessor = blockSource.level();
                net.minecraft.world.level.block.state.BlockState blockState = levelAccessor.getBlockState(blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING)));
                Block block = blockState.getBlock();
                if (block instanceof BucketPickup) {
                    BucketPickup bucketPickup = (BucketPickup)((Object)block);
                    net.minecraft.world.item.ItemStack itemStack = bucketPickup.pickupBlock(null, DummyGeneratorAccess.INSTANCE, blockPos, blockState);
                    if (itemStack.isEmpty()) {
                        return super.execute(blockSource, item);
                    }
                    levelAccessor.gameEvent(null, GameEvent.FLUID_PICKUP, blockPos);
                    Item item1 = itemStack.getItem();
                    net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                    if (result != null) {
                        return result;
                    }
                    itemStack = bucketPickup.pickupBlock(null, levelAccessor, blockPos, blockState);
                    return this.consumeWithRemainder(blockSource, item, new net.minecraft.world.item.ItemStack(item1));
                }
                return super.execute(blockSource, item);
            }
        });
        DispenserBlock.registerBehavior(Items.FLINT_AND_STEEL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                ServerLevel serverLevel = blockSource.level();
                this.setSuccess(true);
                Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                if (result != null) {
                    this.setSuccess(false);
                    return result;
                }
                net.minecraft.world.level.block.state.BlockState blockState = serverLevel.getBlockState(blockPos);
                if (BaseFireBlock.canBePlacedAt(serverLevel, blockPos, direction)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((Level)serverLevel, blockPos, blockSource.pos()).isCancelled()) {
                        serverLevel.setBlockAndUpdate(blockPos, BaseFireBlock.getState(serverLevel, blockPos));
                        serverLevel.gameEvent(null, GameEvent.BLOCK_PLACE, blockPos);
                    }
                } else if (CampfireBlock.canLight(blockState) || CandleBlock.canLight(blockState) || CandleCakeBlock.canLight(blockState)) {
                    serverLevel.setBlockAndUpdate(blockPos, (net.minecraft.world.level.block.state.BlockState)blockState.setValue(BlockStateProperties.LIT, true));
                    serverLevel.gameEvent(null, GameEvent.BLOCK_CHANGE, blockPos);
                } else if (blockState.getBlock() instanceof TntBlock) {
                    if (TntBlock.prime(serverLevel, blockPos, () -> CraftEventFactory.callTNTPrimeEvent(serverLevel, blockPos, TNTPrimeEvent.PrimeCause.DISPENSER, null, blockSource.pos()))) {
                        serverLevel.removeBlock(blockPos, false);
                    } else {
                        this.setSuccess(false);
                    }
                } else {
                    this.setSuccess(false);
                }
                if (this.isSuccess()) {
                    item.hurtAndBreak(1, serverLevel, null, item1 -> {});
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior(Items.BONE_MEAL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                this.setSuccess(true);
                ServerLevel level = blockSource.level();
                BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                if (result != null) {
                    this.setSuccess(false);
                    return result;
                }
                level.captureTreeGeneration = true;
                if (!BoneMealItem.growCrop(item, level, blockPos) && !BoneMealItem.growWaterPlant(item, level, blockPos, null)) {
                    this.setSuccess(false);
                } else if (!level.isClientSide) {
                    level.levelEvent(1505, blockPos, 15);
                }
                level.captureTreeGeneration = false;
                if (!level.capturedBlockStates.isEmpty()) {
                    TreeType treeType = SaplingBlock.treeType;
                    SaplingBlock.treeType = null;
                    Location location = CraftLocation.toBukkit(blockPos, (World)level.getWorld());
                    ArrayList<CraftBlockState> states = new ArrayList<CraftBlockState>(level.capturedBlockStates.values());
                    level.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, states);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, states);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockState : states) {
                            CraftBlockState craftBlockState = (CraftBlockState)blockState;
                            craftBlockState.place(craftBlockState.getFlags());
                            blockSource.level().checkCapturedTreeStateForObserverNotify(blockPos, craftBlockState);
                        }
                    }
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior(Blocks.TNT, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                ServerLevel serverLevel = blockSource.level();
                if (!serverLevel.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
                    this.setSuccess(false);
                    return item;
                }
                BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                net.minecraft.world.item.ItemStack singleItemStack = item.copyWithCount(1);
                CraftBlock block = CraftBlock.at(serverLevel, blockSource.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(singleItemStack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5));
                serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return item;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack);
                    if (dispenseBehavior != NOOP && dispenseBehavior != this) {
                        dispenseBehavior.dispense(blockSource, eventStack);
                        return item;
                    }
                }
                PrimedTnt primedTnt = new PrimedTnt(serverLevel, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                serverLevel.addFreshEntity(primedTnt);
                serverLevel.playSound(null, primedTnt.getX(), primedTnt.getY(), primedTnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverLevel.gameEvent(null, GameEvent.ENTITY_PLACE, CraftVector.toBlockPos(event.getVelocity()));
                if (shrink) {
                    item.shrink(1);
                }
                this.setSuccess(true);
                return item;
            }
        });
        DispenserBlock.registerBehavior(Items.WITHER_SKELETON_SKULL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                ServerLevel level = blockSource.level();
                Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                if (result != null) {
                    this.setSuccess(false);
                    return result;
                }
                if (level.isEmptyBlock(blockPos) && WitherSkullBlock.canSpawnMob(level, blockPos, item)) {
                    level.setBlock(blockPos, (net.minecraft.world.level.block.state.BlockState)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(SkullBlock.ROTATION, RotationSegment.convertToSegment(direction)), 3);
                    level.gameEvent(null, GameEvent.BLOCK_PLACE, blockPos);
                    BlockEntity blockEntity = level.getBlockEntity(blockPos);
                    if (blockEntity instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn(level, blockPos, (SkullBlockEntity)blockEntity);
                    }
                    item.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(blockSource, item, this));
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior(Blocks.CARVED_PUMPKIN, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                ServerLevel level = blockSource.level();
                BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                CarvedPumpkinBlock carvedPumpkinBlock = (CarvedPumpkinBlock)Blocks.CARVED_PUMPKIN;
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                if (result != null) {
                    this.setSuccess(false);
                    return result;
                }
                if (level.isEmptyBlock(blockPos) && carvedPumpkinBlock.canSpawnGolem(level, blockPos)) {
                    if (!level.isClientSide) {
                        level.setBlock(blockPos, carvedPumpkinBlock.defaultBlockState(), 3);
                        level.gameEvent(null, GameEvent.BLOCK_PLACE, blockPos);
                    }
                    item.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(blockSource, item, this));
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior(Blocks.SHULKER_BOX.asItem(), new ShulkerBoxDispenseBehavior());
        for (DyeColor dyeColor : DyeColor.values()) {
            DispenserBlock.registerBehavior(ShulkerBoxBlock.getBlockByColor(dyeColor).asItem(), new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.registerBehavior(Items.GLASS_BOTTLE.asItem(), new OptionalDispenseItemBehavior(){

            private net.minecraft.world.item.ItemStack takeLiquid(BlockSource blockSource, net.minecraft.world.item.ItemStack itemStack, net.minecraft.world.item.ItemStack itemStack1) {
                blockSource.level().gameEvent(null, GameEvent.FLUID_PICKUP, blockSource.pos());
                return this.consumeWithRemainder(blockSource, itemStack, itemStack1);
            }

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                this.setSuccess(false);
                ServerLevel serverLevel = blockSource.level();
                BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                net.minecraft.world.level.block.state.BlockState blockState = serverLevel.getBlockState(blockPos);
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                if (result != null) {
                    return result;
                }
                if (blockState.is(BlockTags.BEEHIVES, blockStateBase -> blockStateBase.hasProperty(BeehiveBlock.HONEY_LEVEL) && blockStateBase.getBlock() instanceof BeehiveBlock) && blockState.getValue(BeehiveBlock.HONEY_LEVEL) >= 5) {
                    ((BeehiveBlock)blockState.getBlock()).releaseBeesAndResetHoneyLevel(serverLevel, blockState, blockPos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(blockSource, item, new net.minecraft.world.item.ItemStack(Items.HONEY_BOTTLE));
                }
                if (serverLevel.getFluidState(blockPos).is(FluidTags.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(blockSource, item, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute(blockSource, item);
            }
        });
        DispenserBlock.registerBehavior(Items.GLOWSTONE, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                ServerLevel level = blockSource.level();
                net.minecraft.world.level.block.state.BlockState blockState = level.getBlockState(blockPos);
                this.setSuccess(true);
                if (blockState.is(Blocks.RESPAWN_ANCHOR)) {
                    if (blockState.getValue(RespawnAnchorBlock.CHARGE) != 4) {
                        net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                        if (result != null) {
                            this.setSuccess(false);
                            return result;
                        }
                        RespawnAnchorBlock.charge(null, level, blockPos, blockState);
                        item.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return item;
                }
                return super.execute(blockSource, item);
            }
        });
        DispenserBlock.registerBehavior(Items.SHEARS.asItem(), new ShearsDispenseItemBehavior());
        DispenserBlock.registerBehavior(Items.BRUSH.asItem(), new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior dispenseItemBehavior;
                BlockPos blockPos;
                ServerLevel serverLevel = blockSource.level();
                List<Entity> entitiesOfClass = serverLevel.getEntitiesOfClass(Armadillo.class, new AABB(blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
                if (entitiesOfClass.isEmpty()) {
                    this.setSuccess(false);
                    return item;
                }
                CraftBlock block = CraftBlock.at(serverLevel, blockSource.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(item);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((Armadillo)entitiesOfClass.get(0)).getBukkitLivingEntity());
                serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.setSuccess(false);
                    return item;
                }
                if (!event.getItem().equals((Object)craftItem) && (dispenseItemBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != NOOP && dispenseItemBehavior != this) {
                    dispenseItemBehavior.dispense(blockSource, eventStack);
                    return item;
                }
                for (Armadillo armadillo : entitiesOfClass) {
                    if (!armadillo.brushOffScute()) continue;
                    item.hurtAndBreak(16, serverLevel, null, item1 -> {});
                    return item;
                }
                this.setSuccess(false);
                return item;
            }
        });
        DispenserBlock.registerBehavior(Items.HONEYCOMB, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                ServerLevel level = blockSource.level();
                net.minecraft.world.level.block.state.BlockState blockState = level.getBlockState(blockPos);
                Optional<net.minecraft.world.level.block.state.BlockState> waxed = HoneycombItem.getWaxed(blockState);
                if (waxed.isPresent()) {
                    net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos, item, this);
                    if (result != null) {
                        this.setSuccess(false);
                        return result;
                    }
                    level.setBlockAndUpdate(blockPos, waxed.get());
                    level.levelEvent(3003, blockPos, 0);
                    item.shrink(1);
                    this.setSuccess(true);
                    return item;
                }
                return super.execute(blockSource, item);
            }
        });
        DispenserBlock.registerBehavior(Items.POTION, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
                PotionContents potionContents = item.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!potionContents.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense(blockSource, item);
                }
                ServerLevel serverLevel = blockSource.level();
                BlockPos blockPos = blockSource.pos();
                BlockPos blockPos1 = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
                if (!serverLevel.getBlockState(blockPos1).is(BlockTags.CONVERTABLE_TO_MUD)) {
                    return this.defaultDispenseItemBehavior.dispense(blockSource, item);
                }
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(blockSource, blockPos1, item, this);
                if (result != null) {
                    return result;
                }
                if (!serverLevel.isClientSide) {
                    for (int i = 0; i < 5; ++i) {
                        serverLevel.sendParticles(ParticleTypes.SPLASH, (double)blockPos.getX() + serverLevel.random.nextDouble(), blockPos.getY() + 1, (double)blockPos.getZ() + serverLevel.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                serverLevel.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverLevel.gameEvent(null, GameEvent.FLUID_PLACE, blockPos);
                serverLevel.setBlockAndUpdate(blockPos1, Blocks.MUD.defaultBlockState());
                return this.consumeWithRemainder(blockSource, item, new net.minecraft.world.item.ItemStack(Items.GLASS_BOTTLE));
            }
        });
        DispenserBlock.registerBehavior(Items.MINECART, new MinecartDispenseItemBehavior(EntityType.MINECART));
        DispenserBlock.registerBehavior(Items.CHEST_MINECART, new MinecartDispenseItemBehavior(EntityType.CHEST_MINECART));
        DispenserBlock.registerBehavior(Items.FURNACE_MINECART, new MinecartDispenseItemBehavior(EntityType.FURNACE_MINECART));
        DispenserBlock.registerBehavior(Items.TNT_MINECART, new MinecartDispenseItemBehavior(EntityType.TNT_MINECART));
        DispenserBlock.registerBehavior(Items.HOPPER_MINECART, new MinecartDispenseItemBehavior(EntityType.HOPPER_MINECART));
        DispenserBlock.registerBehavior(Items.COMMAND_BLOCK_MINECART, new MinecartDispenseItemBehavior(EntityType.COMMAND_BLOCK_MINECART));
    }
}

