/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ShearsDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
        net.minecraft.world.item.ItemStack eventStack;
        DispenseItemBehavior dispenseBehavior;
        ServerLevel serverLevel = blockSource.level();
        CraftBlock bukkitBlock = CraftBlock.at(serverLevel, blockSource.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(item);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
        serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.setSuccess(false);
            return item;
        }
        if (!event.getItem().equals((Object)craftItem) && (dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != DispenseItemBehavior.NOOP && dispenseBehavior != this) {
            dispenseBehavior.dispense(blockSource, eventStack);
            return item;
        }
        if (!serverLevel.isClientSide()) {
            BlockPos blockPos = blockSource.pos().relative(blockSource.state().getValue(DispenserBlock.FACING));
            this.setSuccess(ShearsDispenseItemBehavior.tryShearBeehive(serverLevel, blockPos) || ShearsDispenseItemBehavior.tryShearLivingEntity(serverLevel, blockPos, item, bukkitBlock, craftItem));
            if (this.isSuccess()) {
                item.hurtAndBreak(1, serverLevel, null, item1 -> {});
            }
        }
        return item;
    }

    private static boolean tryShearBeehive(ServerLevel level, BlockPos pos) {
        int honeyLevelValue;
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(BlockTags.BEEHIVES, blockStateBase -> blockStateBase.hasProperty(BeehiveBlock.HONEY_LEVEL) && blockStateBase.getBlock() instanceof BeehiveBlock) && (honeyLevelValue = blockState.getValue(BeehiveBlock.HONEY_LEVEL).intValue()) >= 5) {
            level.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneycomb(level, pos);
            ((BeehiveBlock)blockState.getBlock()).releaseBeesAndResetHoneyLevel(level, blockState, pos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            level.gameEvent(null, GameEvent.SHEAR, pos);
            return true;
        }
        return false;
    }

    private static boolean tryShearLivingEntity(ServerLevel level, BlockPos pos, net.minecraft.world.item.ItemStack stack, Block bukkitBlock, CraftItemStack craftItem) {
        for (LivingEntity livingEntity : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos), EntitySelector.NO_SPECTATORS)) {
            BlockShearEntityEvent event;
            Shearable shearable;
            if (!(livingEntity instanceof Shearable) || !(shearable = (Shearable)((Object)livingEntity)).readyForShearing() || (event = CraftEventFactory.callBlockShearEntityEvent(livingEntity, bukkitBlock, craftItem, shearable.generateDefaultDrops(level, stack))).isCancelled()) continue;
            shearable.shear(level, SoundSource.BLOCKS, stack, CraftItemStack.asNMSCopy(event.getDrops()));
            level.gameEvent(null, GameEvent.SHEAR, pos);
            return true;
        }
        return false;
    }
}

