/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class ShulkerBoxDispenseBehavior
extends OptionalDispenseItemBehavior {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
        this.setSuccess(false);
        Item item1 = item.getItem();
        if (item1 instanceof BlockItem) {
            net.minecraft.world.item.ItemStack eventStack;
            DispenseItemBehavior dispenseBehavior;
            Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
            BlockPos blockPos = blockSource.pos().relative(direction);
            Direction direction1 = blockSource.level().isEmptyBlock(blockPos.below()) ? direction : Direction.UP;
            CraftBlock bukkitBlock = CraftBlock.at(blockSource.level(), blockSource.pos());
            CraftItemStack craftItem = CraftItemStack.asCraftMirror(item.copyWithCount(1));
            BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), CraftVector.toBukkit(blockPos));
            blockSource.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return item;
            }
            if (!event.getItem().equals((Object)craftItem) && (dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != DispenseItemBehavior.NOOP && dispenseBehavior != this) {
                dispenseBehavior.dispense(blockSource, eventStack);
                return item;
            }
            try {
                this.setSuccess(((BlockItem)item1).place(new DirectionalPlaceContext((Level)blockSource.level(), blockPos, direction, CraftItemStack.asNMSCopy(event.getItem()), direction1)).consumesAction());
                if (this.isSuccess()) {
                    item.shrink(1);
                }
            }
            catch (Exception var8) {
                LOGGER.error("Error trying to place shulker box at {}", (Object)blockPos, (Object)var8);
            }
        }
        return item;
    }
}

