/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.slf4j.Logger;

public class StructureUpdater
implements SnbtToNbt.Filter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PREFIX = PackType.SERVER_DATA.getDirectory() + "/minecraft/structure/";

    @Override
    public CompoundTag apply(String structureLocationPath, CompoundTag tag) {
        return structureLocationPath.startsWith(PREFIX) ? StructureUpdater.update(structureLocationPath, tag) : tag;
    }

    public static CompoundTag update(String structureLocationPath, CompoundTag tag) {
        StructureTemplate structureTemplate = new StructureTemplate();
        int dataVersion = NbtUtils.getDataVersion(tag, 500);
        int i = 4292;
        if (dataVersion < 4292) {
            LOGGER.warn("SNBT Too old, do not forget to update: {} < {}: {}", new Object[]{dataVersion, 4292, structureLocationPath});
        }
        CompoundTag compoundTag = DataFixTypes.STRUCTURE.updateToCurrentVersion(DataFixers.getDataFixer(), tag, dataVersion);
        structureTemplate.load(BuiltInRegistries.BLOCK, compoundTag);
        return structureTemplate.save(new CompoundTag());
    }
}

