/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestListener {
    private int attempts = 0;
    private int successes = 0;

    @Override
    public void testStructureLoaded(GameTestInfo testInfo) {
        ++this.attempts;
    }

    private void handleRetry(GameTestInfo testInfo, GameTestRunner runner, boolean passed) {
        RetryOptions retryOptions = testInfo.retryOptions();
        Object string = String.format("[Run: %4d, Ok: %4d, Fail: %4d", this.attempts, this.successes, this.attempts - this.successes);
        if (!retryOptions.unlimitedTries()) {
            string = (String)string + String.format(", Left: %4d", retryOptions.numberOfTries() - this.attempts);
        }
        string = (String)string + "]";
        String string1 = String.valueOf(testInfo.id()) + " " + (passed ? "passed" : "failed") + "! " + testInfo.getRunTime() + "ms";
        String string2 = String.format("%-53s%s", string, string1);
        if (passed) {
            ReportGameListener.reportPassed(testInfo, string2);
        } else {
            ReportGameListener.say(testInfo.getLevel(), ChatFormatting.RED, string2);
        }
        if (retryOptions.hasTriesLeft(this.attempts, this.successes)) {
            runner.rerunTest(testInfo);
        }
    }

    @Override
    public void testPassed(GameTestInfo test, GameTestRunner runner) {
        ++this.successes;
        if (test.retryOptions().hasRetries()) {
            this.handleRetry(test, runner, true);
        } else if (!test.isFlaky()) {
            ReportGameListener.reportPassed(test, String.valueOf(test.id()) + " passed! (" + test.getRunTime() + "ms)");
        } else if (this.successes >= test.requiredSuccesses()) {
            ReportGameListener.reportPassed(test, String.valueOf(test) + " passed " + this.successes + " times of " + this.attempts + " attempts.");
        } else {
            ReportGameListener.say(test.getLevel(), ChatFormatting.GREEN, "Flaky test " + String.valueOf(test) + " succeeded, attempt: " + this.attempts + " successes: " + this.successes);
            runner.rerunTest(test);
        }
    }

    @Override
    public void testFailed(GameTestInfo test, GameTestRunner runner) {
        if (!test.isFlaky()) {
            ReportGameListener.reportFailure(test, test.getError());
            if (test.retryOptions().hasRetries()) {
                this.handleRetry(test, runner, false);
            }
        } else {
            GameTestInstance test1 = test.getTest();
            String string = "Flaky test " + String.valueOf(test) + " failed, attempt: " + this.attempts + "/" + test1.maxAttempts();
            if (test1.requiredSuccesses() > 1) {
                string = string + ", successes: " + this.successes + " (" + test1.requiredSuccesses() + " required)";
            }
            ReportGameListener.say(test.getLevel(), ChatFormatting.YELLOW, string);
            if (test.maxAttempts() - this.attempts + this.successes >= test.requiredSuccesses()) {
                runner.rerunTest(test);
            } else {
                ReportGameListener.reportFailure(test, new ExhaustedAttemptsException(this.attempts, this.successes, test));
            }
        }
    }

    @Override
    public void testAddedForRerun(GameTestInfo oldTest, GameTestInfo newTest, GameTestRunner runner) {
        newTest.addListener(this);
    }

    public static void reportPassed(GameTestInfo testInfo, String message) {
        ReportGameListener.getTestInstanceBlockEntity(testInfo).ifPresent(blockEntity -> blockEntity.setSuccess());
        ReportGameListener.visualizePassedTest(testInfo, message);
    }

    private static void visualizePassedTest(GameTestInfo testInfo, String message) {
        ReportGameListener.say(testInfo.getLevel(), ChatFormatting.GREEN, message);
        GlobalTestReporter.onTestSuccess(testInfo);
    }

    protected static void reportFailure(GameTestInfo testInfo, Throwable error) {
        Component description;
        if (error instanceof GameTestAssertException) {
            GameTestAssertException gameTestAssertException = (GameTestAssertException)error;
            description = gameTestAssertException.getDescription();
        } else {
            description = Component.literal(Util.describeError(error));
        }
        ReportGameListener.getTestInstanceBlockEntity(testInfo).ifPresent(blockEntity -> blockEntity.setErrorMessage(description));
        ReportGameListener.visualizeFailedTest(testInfo, error);
    }

    protected static void visualizeFailedTest(GameTestInfo testInfo, Throwable error) {
        String string = error.getMessage() + (String)(error.getCause() == null ? "" : " cause: " + Util.describeError(error.getCause()));
        String string1 = (testInfo.isRequired() ? "" : "(optional) ") + String.valueOf(testInfo.id()) + " failed! " + string;
        ReportGameListener.say(testInfo.getLevel(), testInfo.isRequired() ? ChatFormatting.RED : ChatFormatting.YELLOW, string1);
        Throwable throwable = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)error), (Object)error);
        if (throwable instanceof GameTestAssertPosException) {
            GameTestAssertPosException gameTestAssertPosException = (GameTestAssertPosException)throwable;
            ReportGameListener.showRedBox(testInfo.getLevel(), gameTestAssertPosException.getAbsolutePos(), gameTestAssertPosException.getMessageToShowAtBlock());
        }
        GlobalTestReporter.onTestFailed(testInfo);
    }

    private static Optional<TestInstanceBlockEntity> getTestInstanceBlockEntity(GameTestInfo testInfo) {
        ServerLevel level = testInfo.getLevel();
        Optional<BlockPos> optional = Optional.ofNullable(testInfo.getTestBlockPos());
        return optional.flatMap(pos -> level.getBlockEntity((BlockPos)pos, BlockEntityType.TEST_INSTANCE_BLOCK));
    }

    protected static void say(ServerLevel serverLevel, ChatFormatting formatting, String message) {
        serverLevel.getPlayers(player -> true).forEach(player -> player.sendSystemMessage(Component.literal(message).withStyle(formatting)));
    }

    private static void showRedBox(ServerLevel serverLevel, BlockPos pos, String displayMessage) {
        DebugPackets.sendGameTestAddMarker(serverLevel, pos, displayMessage, -2130771968, Integer.MAX_VALUE);
    }
}

