/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.datafixers.DataFixUtils;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.HashedPatchMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface HashedStack {
    public static final HashedStack EMPTY = new HashedStack(){

        public String toString() {
            return "<empty>";
        }

        @Override
        public boolean matches(ItemStack stack, HashedPatchMap.HashGenerator hashGenerator, boolean simplifyMatching) {
            return stack.isEmpty();
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, HashedStack> STREAM_CODEC = ByteBufCodecs.optional(ActualItem.STREAM_CODEC).map(optional -> (HashedStack)DataFixUtils.orElse((Optional)optional, (Object)EMPTY), hashedStack -> {
        Optional<Object> optional;
        if (hashedStack instanceof ActualItem) {
            ActualItem actualItem = (ActualItem)hashedStack;
            optional = Optional.of(actualItem);
        } else {
            optional = Optional.empty();
        }
        return optional;
    });

    public boolean matches(ItemStack var1, HashedPatchMap.HashGenerator var2, boolean var3);

    public static HashedStack create(ItemStack stack, HashedPatchMap.HashGenerator hashGenerator) {
        return stack.isEmpty() ? EMPTY : new ActualItem(stack.getItemHolder(), stack.getCount(), HashedPatchMap.create(stack.getComponentsPatch(), hashGenerator));
    }

    public record ActualItem(Holder<Item> item, int count, HashedPatchMap components) implements HashedStack
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, ActualItem> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ITEM), ActualItem::item, ByteBufCodecs.VAR_INT, ActualItem::count, HashedPatchMap.STREAM_CODEC, ActualItem::components, ActualItem::new);

        @Override
        public boolean matches(ItemStack stack, HashedPatchMap.HashGenerator hashGenerator, boolean simplifyMatching) {
            return this.count == stack.getCount() && this.item.equals(stack.getItemHolder()) && (simplifyMatching || this.components.matches(stack.getComponentsPatch(), hashGenerator));
        }
    }
}

