/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;

public class VarLong {
    private static final int MAX_VARLONG_SIZE = 10;
    private static final int DATA_BITS_MASK = 127;
    private static final int CONTINUATION_BIT_MASK = 128;
    private static final int DATA_BITS_PER_BYTE = 7;

    public static int getByteSize(long data) {
        for (int i = 1; i < 10; ++i) {
            if ((data & -1L << i * 7) != 0L) continue;
            return i;
        }
        return 10;
    }

    public static boolean hasContinuationBit(byte data) {
        return (data & 0x80) == 128;
    }

    public static long read(ByteBuf buffer) {
        byte _byte;
        long l = 0L;
        int i = 0;
        do {
            _byte = buffer.readByte();
            l |= (long)(_byte & 0x7F) << i++ * 7;
            if (i <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while (VarLong.hasContinuationBit(_byte));
        return l;
    }

    public static ByteBuf write(ByteBuf buffer, long value) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        buffer.writeByte((int)value);
        return buffer;
    }
}

