/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.authlib.GameProfile;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.chat.SignedMessageValidator;
import net.minecraft.util.SignatureValidator;
import net.minecraft.world.entity.player.ProfilePublicKey;

public record RemoteChatSession(UUID sessionId, ProfilePublicKey profilePublicKey) {
    public SignedMessageValidator createMessageValidator(Duration duration) {
        return new SignedMessageValidator.KeyBased(this.profilePublicKey.createSignatureValidator(), () -> this.profilePublicKey.data().hasExpired(duration));
    }

    public SignedMessageChain.Decoder createMessageDecoder(UUID sender) {
        return new SignedMessageChain(sender, this.sessionId).decoder(this.profilePublicKey);
    }

    public Data asData() {
        return new Data(this.sessionId, this.profilePublicKey.data());
    }

    public boolean hasExpired() {
        return this.profilePublicKey.data().hasExpired();
    }

    public record Data(UUID sessionId, ProfilePublicKey.Data profilePublicKey) {
        public static Data read(FriendlyByteBuf buffer) {
            return new Data(buffer.readUUID(), new ProfilePublicKey.Data(buffer));
        }

        public static void write(FriendlyByteBuf buffer, Data data) {
            buffer.writeUUID(data.sessionId);
            data.profilePublicKey.write(buffer);
        }

        public RemoteChatSession validate(GameProfile profile, SignatureValidator signatureValidator) throws ProfilePublicKey.ValidationException {
            return new RemoteChatSession(this.sessionId, ProfilePublicKey.createValidated(signatureValidator, profile.getId(), this.profilePublicKey));
        }
    }
}

