/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;
import org.slf4j.Logger;

public class PacketUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T processor, ServerLevel level) throws RunningOnDifferentThreadException {
        PacketUtils.ensureRunningOnSameThread(packet, processor, level.getServer());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T processor, BlockableEventLoop<?> executor) throws RunningOnDifferentThreadException {
        if (!executor.isSameThread()) {
            executor.executeIfPossible(() -> {
                packetProcessing.push(processor);
                try {
                    if (processor instanceof ServerCommonPacketListenerImpl) {
                        ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)processor;
                        if (serverCommonPacketListener.processedDisconnect) {
                            return;
                        }
                    }
                    if (processor.shouldHandleMessage(packet)) {
                        try {
                            packet.handle(processor);
                        }
                        catch (Exception var4) {
                            ReportedException reportedException;
                            if (var4 instanceof ReportedException && (reportedException = (ReportedException)var4).getCause() instanceof OutOfMemoryError) {
                                throw PacketUtils.makeReportedException(var4, packet, processor);
                            }
                            processor.onPacketError(packet, var4);
                        }
                    } else {
                        LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                    }
                }
                finally {
                    totalMainThreadPacketsProcessed.getAndIncrement();
                    packetProcessing.pop();
                }
            });
            throw RunningOnDifferentThreadException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public static <T extends PacketListener> ReportedException makeReportedException(Exception exception, Packet<T> packet, T packetListener) {
        if (exception instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)exception;
            PacketUtils.fillCrashReport(reportedException.getReport(), packetListener, packet);
            return reportedException;
        }
        CrashReport crashReport = CrashReport.forThrowable(exception, "Main thread packet handler");
        PacketUtils.fillCrashReport(crashReport, packetListener, packet);
        return new ReportedException(crashReport);
    }

    public static <T extends PacketListener> void fillCrashReport(CrashReport crashReport, T packetListener, @Nullable Packet<T> packet) {
        if (packet != null) {
            CrashReportCategory crashReportCategory = crashReport.addCategory("Incoming Packet");
            crashReportCategory.setDetail("Type", () -> packet.type().toString());
            crashReportCategory.setDetail("Is Terminal", () -> Boolean.toString(packet.isTerminal()));
            crashReportCategory.setDetail("Is Skippable", () -> Boolean.toString(packet.isSkippable()));
        }
        packetListener.fillCrashReport(crashReport);
    }

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> listeners = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            listeners.add(listener);
        }
        return listeners;
    }
}

