/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Queues;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundCommandsPacket> STREAM_CODEC = Packet.codec(ClientboundCommandsPacket::write, ClientboundCommandsPacket::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public ClientboundCommandsPacket(RootCommandNode<SharedSuggestionProvider> root) {
        Object2IntMap<CommandNode<SharedSuggestionProvider>> map = ClientboundCommandsPacket.enumerateNodes(root);
        this.entries = ClientboundCommandsPacket.createEntries(map);
        this.rootIndex = map.getInt(root);
    }

    private ClientboundCommandsPacket(FriendlyByteBuf buffer) {
        this.entries = buffer.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = buffer.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    private void write(FriendlyByteBuf buffer) {
        buffer.writeCollection(this.entries, (buffer1, value) -> value.write((FriendlyByteBuf)((Object)buffer1)));
        buffer.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> entries, BiPredicate<Entry, IntSet> validator) {
        IntOpenHashSet set = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)entries.size()));
        while (!set.isEmpty()) {
            boolean flag = set.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(validator, entries, (IntSet)set, arg_0));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> entries) {
        ClientboundCommandsPacket.validateEntries(entries, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(entries, Entry::canResolve);
    }

    private static Object2IntMap<CommandNode<SharedSuggestionProvider>> enumerateNodes(RootCommandNode<SharedSuggestionProvider> rootNode) {
        CommandNode commandNode;
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        ArrayDeque arrayDeque = Queues.newArrayDeque();
        arrayDeque.add(rootNode);
        while ((commandNode = (CommandNode)arrayDeque.poll()) != null) {
            if (map.containsKey((Object)commandNode)) continue;
            int size = map.size();
            map.put((Object)commandNode, size);
            arrayDeque.addAll(commandNode.getChildren());
            if (commandNode.getRedirect() == null) continue;
            arrayDeque.add(commandNode.getRedirect());
        }
        return map;
    }

    private static List<Entry> createEntries(Object2IntMap<CommandNode<SharedSuggestionProvider>> nodes) {
        ObjectArrayList list = new ObjectArrayList(nodes.size());
        list.size(nodes.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(nodes)) {
            list.set(entry.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode)entry.getKey(), nodes));
        }
        return list;
    }

    private static Entry readNode(FriendlyByteBuf buffer) {
        byte _byte = buffer.readByte();
        int[] varIntArray = buffer.readVarIntArray();
        int i = (_byte & 8) != 0 ? buffer.readVarInt() : 0;
        NodeStub nodeStub = ClientboundCommandsPacket.read(buffer, _byte);
        return new Entry(nodeStub, _byte, i, varIntArray);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf buffer, byte flags) {
        int i = flags & 3;
        if (i == 2) {
            String utf = buffer.readUtf();
            int varInt = buffer.readVarInt();
            ArgumentTypeInfo argumentTypeInfo = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(varInt);
            if (argumentTypeInfo == null) {
                return null;
            }
            Object template = argumentTypeInfo.deserializeFromNetwork(buffer);
            ResourceLocation resourceLocation = (flags & 0x10) != 0 ? buffer.readResourceLocation() : null;
            return new ArgumentNodeStub(utf, (ArgumentTypeInfo.Template<?>)template, resourceLocation);
        }
        if (i == 1) {
            String utf = buffer.readUtf();
            return new LiteralNodeStub(utf);
        }
        return null;
    }

    private static Entry createEntry(CommandNode<SharedSuggestionProvider> node, Object2IntMap<CommandNode<SharedSuggestionProvider>> nodes) {
        NodeStub nodeStub;
        int _int;
        int i = 0;
        if (node.getRedirect() != null) {
            i |= 8;
            _int = nodes.getInt(node.getRedirect());
        } else {
            _int = 0;
        }
        if (node.getCommand() != null) {
            i |= 4;
        }
        if (node instanceof RootCommandNode) {
            i |= 0;
            nodeStub = null;
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
            nodeStub = new ArgumentNodeStub(argumentCommandNode);
            i |= 2;
            if (argumentCommandNode.getCustomSuggestions() != null) {
                i |= 0x10;
            }
        } else {
            if (!(node instanceof LiteralCommandNode)) {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(node));
            }
            LiteralCommandNode literalCommandNode = (LiteralCommandNode)node;
            nodeStub = new LiteralNodeStub(literalCommandNode.getLiteral());
            i |= 1;
        }
        int[] ints = node.getChildren().stream().mapToInt(arg_0 -> nodes.getInt(arg_0)).toArray();
        return new Entry(nodeStub, i, _int, ints);
    }

    @Override
    public PacketType<ClientboundCommandsPacket> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    public void handle(ClientGamePacketListener handler) {
        handler.handleCommands(this);
    }

    public RootCommandNode<SharedSuggestionProvider> getRoot(CommandBuildContext context) {
        return (RootCommandNode)new NodeResolver(context, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate validator, List entries, IntSet set, int i) {
        return validator.test((Entry)entries.get(i), set);
    }

    static class Entry {
        @Nullable
        final NodeStub stub;
        final int flags;
        final int redirect;
        final int[] children;

        Entry(@Nullable NodeStub stub, int flags, int redirect, int[] children) {
            this.stub = stub;
            this.flags = flags;
            this.redirect = redirect;
            this.children = children;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte(this.flags);
            buffer.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                buffer.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(buffer);
            }
        }

        public boolean canBuild(IntSet children) {
            return (this.flags & 8) == 0 || !children.contains(this.redirect);
        }

        public boolean canResolve(IntSet children) {
            for (int i : this.children) {
                if (!children.contains(i)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext var1);

        public void write(FriendlyByteBuf var1);
    }

    static class ArgumentNodeStub
    implements NodeStub {
        private final String id;
        private final ArgumentTypeInfo.Template<?> argumentType;
        @Nullable
        private final ResourceLocation suggestionId;

        @Nullable
        private static ResourceLocation getSuggestionId(@Nullable SuggestionProvider<SharedSuggestionProvider> provider) {
            return provider != null ? SuggestionProviders.getName(provider) : null;
        }

        ArgumentNodeStub(String id, ArgumentTypeInfo.Template<?> argumentType, @Nullable ResourceLocation suggestionId) {
            this.id = id;
            this.argumentType = argumentType;
            this.suggestionId = suggestionId;
        }

        public ArgumentNodeStub(ArgumentCommandNode<SharedSuggestionProvider, ?> argumentNode) {
            this(argumentNode.getName(), ArgumentTypeInfos.unpack(argumentNode.getType()), ArgumentNodeStub.getSuggestionId((SuggestionProvider<SharedSuggestionProvider>)argumentNode.getCustomSuggestions()));
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext context) {
            Object argumentType = this.argumentType.instantiate(context);
            RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)this.id, argumentType);
            if (this.suggestionId != null) {
                requiredArgumentBuilder.suggests(SuggestionProviders.getProvider(this.suggestionId));
            }
            return requiredArgumentBuilder;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(buffer, this.argumentType);
            if (this.suggestionId != null) {
                buffer.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf buffer, ArgumentTypeInfo.Template<A> argumentInfoTemplate) {
            ArgumentNodeStub.serializeCap(buffer, argumentInfoTemplate.type(), argumentInfoTemplate);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf buffer, ArgumentTypeInfo<A, T> argumentInfo, ArgumentTypeInfo.Template<A> argumentInfoTemplate) {
            buffer.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(argumentInfo));
            argumentInfo.serializeToNetwork(argumentInfoTemplate, buffer);
        }
    }

    static class LiteralNodeStub
    implements NodeStub {
        private final String id;

        LiteralNodeStub(String id) {
            this.id = id;
        }

        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext context) {
            return LiteralArgumentBuilder.literal((String)this.id);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.id);
        }
    }

    static class NodeResolver {
        private final CommandBuildContext context;
        private final List<Entry> entries;
        private final List<CommandNode<SharedSuggestionProvider>> nodes;

        NodeResolver(CommandBuildContext context, List<Entry> entries) {
            this.context = context;
            this.entries = entries;
            ObjectArrayList list = new ObjectArrayList();
            list.size(entries.size());
            this.nodes = list;
        }

        public CommandNode<SharedSuggestionProvider> resolve(int index) {
            Object commandNode1;
            CommandNode<SharedSuggestionProvider> commandNode = this.nodes.get(index);
            if (commandNode != null) {
                return commandNode;
            }
            Entry entry = this.entries.get(index);
            if (entry.stub == null) {
                commandNode1 = new RootCommandNode();
            } else {
                ArgumentBuilder<SharedSuggestionProvider, ?> argumentBuilder = entry.stub.build(this.context);
                if ((entry.flags & 8) != 0) {
                    argumentBuilder.redirect(this.resolve(entry.redirect));
                }
                if ((entry.flags & 4) != 0) {
                    argumentBuilder.executes((Command<SharedSuggestionProvider>)((Command)commandContext -> 0));
                }
                commandNode1 = argumentBuilder.build();
            }
            this.nodes.set(index, (CommandNode<SharedSuggestionProvider>)commandNode1);
            for (int i : entry.children) {
                CommandNode<SharedSuggestionProvider> commandNode2 = this.resolve(i);
                if (commandNode2 instanceof RootCommandNode) continue;
                ((CommandNode)commandNode1).addChild(commandNode2);
            }
            return commandNode1;
        }
    }
}

