/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class ClientboundSectionBlocksUpdatePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundSectionBlocksUpdatePacket> STREAM_CODEC = Packet.codec(ClientboundSectionBlocksUpdatePacket::write, ClientboundSectionBlocksUpdatePacket::new);
    private static final int POS_IN_SECTION_BITS = 12;
    private final SectionPos sectionPos;
    private final short[] positions;
    private final BlockState[] states;

    public ClientboundSectionBlocksUpdatePacket(SectionPos sectionPos, ShortSet positions, LevelChunkSection section) {
        this.sectionPos = sectionPos;
        int size = positions.size();
        this.positions = new short[size];
        this.states = new BlockState[size];
        int i = 0;
        ShortIterator shortIterator = positions.iterator();
        while (shortIterator.hasNext()) {
            short s;
            this.positions[i] = s = ((Short)shortIterator.next()).shortValue();
            this.states[i] = section != null ? section.getBlockState(SectionPos.sectionRelativeX(s), SectionPos.sectionRelativeY(s), SectionPos.sectionRelativeZ(s)) : Blocks.AIR.defaultBlockState();
            ++i;
        }
    }

    public ClientboundSectionBlocksUpdatePacket(SectionPos sectionposition, ShortSet shortset, BlockState[] states) {
        this.sectionPos = sectionposition;
        this.positions = shortset.toShortArray();
        this.states = states;
    }

    public ClientboundSectionBlocksUpdatePacket(SectionPos sectionPos, Short2ObjectMap<BlockState> blockChanges) {
        this.sectionPos = sectionPos;
        this.positions = blockChanges.keySet().toShortArray();
        this.states = (BlockState[])blockChanges.values().toArray((Object[])new BlockState[0]);
    }

    private ClientboundSectionBlocksUpdatePacket(FriendlyByteBuf buffer) {
        this.sectionPos = SectionPos.of(buffer.readLong());
        int varInt = buffer.readVarInt();
        this.positions = new short[varInt];
        this.states = new BlockState[varInt];
        for (int i = 0; i < varInt; ++i) {
            long varLong = buffer.readVarLong();
            this.positions[i] = (short)(varLong & 0xFFFL);
            this.states[i] = Block.BLOCK_STATE_REGISTRY.byId((int)(varLong >>> 12));
        }
    }

    private void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.sectionPos.asLong());
        buffer.writeVarInt(this.positions.length);
        for (int i = 0; i < this.positions.length; ++i) {
            buffer.writeVarLong((long)Block.getId(this.states[i]) << 12 | (long)this.positions[i]);
        }
    }

    @Override
    public PacketType<ClientboundSectionBlocksUpdatePacket> type() {
        return GamePacketTypes.CLIENTBOUND_SECTION_BLOCKS_UPDATE;
    }

    @Override
    public void handle(ClientGamePacketListener handler) {
        handler.handleChunkBlocksUpdate(this);
    }

    public void runUpdates(BiConsumer<BlockPos, BlockState> consumer) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.positions.length; ++i) {
            short s = this.positions[i];
            mutableBlockPos.set(this.sectionPos.relativeToBlockX(s), this.sectionPos.relativeToBlockY(s), this.sectionPos.relativeToBlockZ(s));
            consumer.accept(mutableBlockPos, this.states[i]);
        }
    }
}

