/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ServerboundInteractPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundInteractPacket> STREAM_CODEC = Packet.codec(ServerboundInteractPacket::write, ServerboundInteractPacket::new);
    private final int entityId;
    private final Action action;
    private final boolean usingSecondaryAction;
    static final Action ATTACK_ACTION = new Action(){

        @Override
        public ActionType getType() {
            return ActionType.ATTACK;
        }

        @Override
        public void dispatch(Handler handler) {
            handler.onAttack();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
        }
    };

    private ServerboundInteractPacket(int entityId, boolean usingSecondaryAction, Action action) {
        this.entityId = entityId;
        this.action = action;
        this.usingSecondaryAction = usingSecondaryAction;
    }

    public static ServerboundInteractPacket createAttackPacket(Entity entity, boolean usingSecondaryAction) {
        return new ServerboundInteractPacket(entity.getId(), usingSecondaryAction, ATTACK_ACTION);
    }

    public static ServerboundInteractPacket createInteractionPacket(Entity entity, boolean usingSecondaryAction, InteractionHand hand) {
        return new ServerboundInteractPacket(entity.getId(), usingSecondaryAction, new InteractionAction(hand));
    }

    public static ServerboundInteractPacket createInteractionPacket(Entity entity, boolean usingSecondaryAction, InteractionHand hand, Vec3 interactionLocation) {
        return new ServerboundInteractPacket(entity.getId(), usingSecondaryAction, new InteractionAtLocationAction(hand, interactionLocation));
    }

    private ServerboundInteractPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readVarInt();
        ActionType actionType = buffer.readEnum(ActionType.class);
        this.action = actionType.reader.apply(buffer);
        this.usingSecondaryAction = buffer.readBoolean();
    }

    private void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.entityId);
        buffer.writeEnum(this.action.getType());
        this.action.write(buffer);
        buffer.writeBoolean(this.usingSecondaryAction);
    }

    @Override
    public PacketType<ServerboundInteractPacket> type() {
        return GamePacketTypes.SERVERBOUND_INTERACT;
    }

    @Override
    public void handle(ServerGamePacketListener handler) {
        handler.handleInteract(this);
    }

    @Nullable
    public Entity getTarget(ServerLevel level) {
        return level.getEntityOrPart(this.entityId);
    }

    public boolean isUsingSecondaryAction() {
        return this.usingSecondaryAction;
    }

    public void dispatch(Handler handler) {
        this.action.dispatch(handler);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isAttack() {
        return this.action.getType() == ActionType.ATTACK;
    }

    static interface Action {
        public ActionType getType();

        public void dispatch(Handler var1);

        public void write(FriendlyByteBuf var1);
    }

    static class InteractionAction
    implements Action {
        private final InteractionHand hand;

        InteractionAction(InteractionHand hand) {
            this.hand = hand;
        }

        private InteractionAction(FriendlyByteBuf buffer) {
            this.hand = buffer.readEnum(InteractionHand.class);
        }

        @Override
        public ActionType getType() {
            return ActionType.INTERACT;
        }

        @Override
        public void dispatch(Handler handler) {
            handler.onInteraction(this.hand);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeEnum(this.hand);
        }
    }

    static class InteractionAtLocationAction
    implements Action {
        private final InteractionHand hand;
        private final Vec3 location;

        InteractionAtLocationAction(InteractionHand hand, Vec3 location) {
            this.hand = hand;
            this.location = location;
        }

        private InteractionAtLocationAction(FriendlyByteBuf buffer) {
            this.location = new Vec3(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            this.hand = buffer.readEnum(InteractionHand.class);
        }

        @Override
        public ActionType getType() {
            return ActionType.INTERACT_AT;
        }

        @Override
        public void dispatch(Handler handler) {
            handler.onInteraction(this.hand, this.location);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeFloat((float)this.location.x);
            buffer.writeFloat((float)this.location.y);
            buffer.writeFloat((float)this.location.z);
            buffer.writeEnum(this.hand);
        }
    }

    static enum ActionType {
        INTERACT(InteractionAction::new),
        ATTACK(buffer -> ATTACK_ACTION),
        INTERACT_AT(InteractionAtLocationAction::new);

        final Function<FriendlyByteBuf, Action> reader;

        private ActionType(Function<FriendlyByteBuf, Action> reader) {
            this.reader = reader;
        }
    }

    public static interface Handler {
        public void onInteraction(InteractionHand var1);

        public void onInteraction(InteractionHand var1, Vec3 var2);

        public void onAttack();
    }
}

