/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import java.util.Iterator;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public interface PlaceRecipeHelper {
    public static <T> void placeRecipe(int width, int height, Recipe<?> recipe, Iterable<T> ingredients, Output<T> output) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            PlaceRecipeHelper.placeRecipe(width, height, shapedRecipe.getWidth(), shapedRecipe.getHeight(), ingredients, output);
        } else {
            PlaceRecipeHelper.placeRecipe(width, height, width, height, ingredients, output);
        }
    }

    public static <T> void placeRecipe(int gridWidth, int gridHeight, int width, int height, Iterable<T> ingredients, Output<T> output) {
        Iterator<T> iterator = ingredients.iterator();
        int i = 0;
        block0: for (int i1 = 0; i1 < gridHeight; ++i1) {
            boolean flag = (float)height < (float)gridHeight / 2.0f;
            int floor = Mth.floor((float)gridHeight / 2.0f - (float)height / 2.0f);
            if (flag && floor > i1) {
                i += gridWidth;
                ++i1;
            }
            for (int i2 = 0; i2 < gridWidth; ++i2) {
                boolean flag1;
                if (!iterator.hasNext()) {
                    return;
                }
                flag = (float)width < (float)gridWidth / 2.0f;
                floor = Mth.floor((float)gridWidth / 2.0f - (float)width / 2.0f);
                int i3 = width;
                boolean bl = flag1 = i2 < width;
                if (flag) {
                    i3 = floor + width;
                    boolean bl2 = flag1 = floor <= i2 && i2 < floor + width;
                }
                if (flag1) {
                    output.addItemToSlot(iterator.next(), i, i2, i1);
                } else if (i3 == i2) {
                    i += gridWidth - i2;
                    continue block0;
                }
                ++i;
            }
        }
    }

    @FunctionalInterface
    public static interface Output<T> {
        public void addItemToSlot(T var1, int var2, int var3, int var4);
    }
}

