/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DelegatingOps<T> {
    public final RegistryInfoLookup lookupProvider;

    public static <T> RegistryOps<T> create(DynamicOps<T> delegate, HolderLookup.Provider registries) {
        return RegistryOps.create(delegate, new HolderLookupAdapter(registries));
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> delegate, RegistryInfoLookup lookupProvider) {
        return new RegistryOps<T>(delegate, lookupProvider);
    }

    public static <T> Dynamic<T> injectRegistryContext(Dynamic<T> dynamic, HolderLookup.Provider registries) {
        return new Dynamic(registries.createSerializationContext(dynamic.getOps()), dynamic.getValue());
    }

    private RegistryOps(DynamicOps<T> delegate, RegistryInfoLookup lookupProvider) {
        super(delegate);
        this.lookupProvider = lookupProvider;
    }

    public <U> RegistryOps<U> withParent(DynamicOps<U> ops) {
        return ops == this.delegate ? this : new RegistryOps<U>(ops, this.lookupProvider);
    }

    public <E> Optional<HolderOwner<E>> owner(ResourceKey<? extends Registry<? extends E>> registryKey) {
        return this.lookupProvider.lookup(registryKey).map(RegistryInfo::owner);
    }

    public <E> Optional<HolderGetter<E>> getter(ResourceKey<? extends Registry<? extends E>> registryKey) {
        return this.lookupProvider.lookup(registryKey).map(RegistryInfo::getter);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            RegistryOps registryOps = (RegistryOps)other;
            return this.delegate.equals(registryOps.delegate) && this.lookupProvider.equals(registryOps.lookupProvider);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + this.lookupProvider.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> retrieveGetter(ResourceKey<? extends Registry<? extends E>> registryOps) {
        return ExtraCodecs.retrieveContext(dynamicOps -> {
            DataResult dataResult;
            if (dynamicOps instanceof RegistryOps) {
                RegistryOps registryOps1 = (RegistryOps)dynamicOps;
                dataResult = registryOps1.lookupProvider.lookup(registryOps).map(registryInfo -> DataResult.success(registryInfo.getter(), (Lifecycle)registryInfo.elementsLifecycle())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(registryOps)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(object -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.Reference<E>> retrieveElement(ResourceKey<E> key) {
        ResourceKey resourceKey = ResourceKey.createRegistryKey(key.registry());
        return ExtraCodecs.retrieveContext(dynamicOps -> {
            DataResult dataResult;
            if (dynamicOps instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)dynamicOps;
                dataResult = registryOps.lookupProvider.lookup(resourceKey).flatMap(registryInfo -> registryInfo.getter().get(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(key)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(object -> null);
    }

    public static final class HolderLookupAdapter
    implements RegistryInfoLookup {
        private final HolderLookup.Provider lookupProvider;
        private final Map<ResourceKey<? extends Registry<?>>, Optional<? extends RegistryInfo<?>>> lookups = new ConcurrentHashMap();

        public HolderLookupAdapter(HolderLookup.Provider lookupProvider) {
            this.lookupProvider = lookupProvider;
        }

        public <E> Optional<RegistryInfo<E>> lookup(ResourceKey<? extends Registry<? extends E>> registryKey) {
            return this.lookups.computeIfAbsent(registryKey, this::createLookup);
        }

        private Optional<RegistryInfo<Object>> createLookup(ResourceKey<? extends Registry<?>> registryKey) {
            return this.lookupProvider.lookup(registryKey).map(RegistryInfo::fromRegistryLookup);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof HolderLookupAdapter)) return false;
            HolderLookupAdapter holderLookupAdapter = (HolderLookupAdapter)other;
            if (!this.lookupProvider.equals(holderLookupAdapter.lookupProvider)) return false;
            return true;
        }

        public int hashCode() {
            return this.lookupProvider.hashCode();
        }
    }

    public static interface RegistryInfoLookup {
        public <T> Optional<RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);
    }

    public record RegistryInfo<T>(HolderOwner<T> owner, HolderGetter<T> getter, Lifecycle elementsLifecycle) {
        public static <T> RegistryInfo<T> fromRegistryLookup(HolderLookup.RegistryLookup<T> registryLookup) {
            return new RegistryInfo<T>(registryLookup, registryLookup, registryLookup.registryLifecycle());
        }
    }
}

