/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.papermc.paper.configuration.PaperConfigurations;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.SignatureValidator;

public record Services(MinecraftSessionService sessionService, ServicesKeySet servicesKeySet, GameProfileRepository profileRepository, GameProfileCache profileCache, @Nullable PaperConfigurations paperConfigurations) {
    @Nullable
    private final PaperConfigurations paperConfigurations;
    public static final String USERID_CACHE_FILE = "usercache.json";

    public Services(MinecraftSessionService sessionService, ServicesKeySet servicesKeySet, GameProfileRepository profileRepository, GameProfileCache profileCache) {
        this(sessionService, servicesKeySet, profileRepository, profileCache, null);
    }

    public PaperConfigurations paperConfigurations() {
        return Objects.requireNonNull(this.paperConfigurations);
    }

    public static Services create(YggdrasilAuthenticationService authenticationService, File profileRepository, File userCacheFile, OptionSet optionSet) throws Exception {
        MinecraftSessionService minecraftSessionService = authenticationService.createMinecraftSessionService();
        GameProfileRepository gameProfileRepository = authenticationService.createProfileRepository();
        GameProfileCache gameProfileCache = new GameProfileCache(gameProfileRepository, userCacheFile);
        Path legacyConfigPath = ((File)optionSet.valueOf("paper-settings")).toPath();
        Path configDirPath = ((File)optionSet.valueOf("paper-settings-directory")).toPath();
        PaperConfigurations paperConfigurations = PaperConfigurations.setup(legacyConfigPath, configDirPath, profileRepository.toPath(), (File)optionSet.valueOf("spigot-settings"));
        return new Services(minecraftSessionService, authenticationService.getServicesKeySet(), gameProfileRepository, gameProfileCache, paperConfigurations);
    }

    @Nullable
    public SignatureValidator profileKeySignatureValidator() {
        return SignatureValidator.from(this.servicesKeySet, ServicesKeyType.PROFILE_KEY);
    }

    public boolean canValidateProfileKeys() {
        return !this.servicesKeySet.keys(ServicesKeyType.PROFILE_KEY).isEmpty();
    }
}

