/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.advancements;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.DisplayInfo;

public class AdvancementVisibilityEvaluator {
    private static final int VISIBILITY_DEPTH = 2;

    private static VisibilityRule evaluateVisibilityRule(Advancement advancement, boolean alwaysShow) {
        Optional<DisplayInfo> optional = advancement.display();
        if (optional.isEmpty()) {
            return VisibilityRule.HIDE;
        }
        if (alwaysShow) {
            return VisibilityRule.SHOW;
        }
        return optional.get().isHidden() ? VisibilityRule.HIDE : VisibilityRule.NO_CHANGE;
    }

    private static boolean evaluateVisiblityForUnfinishedNode(Stack<VisibilityRule> visibilityRules) {
        for (int i = 0; i <= 2; ++i) {
            VisibilityRule visibilityRule = (VisibilityRule)((Object)visibilityRules.peek(i));
            if (visibilityRule == VisibilityRule.SHOW) {
                return true;
            }
            if (visibilityRule != VisibilityRule.HIDE) continue;
            return false;
        }
        return false;
    }

    private static boolean evaluateVisibility(AdvancementNode advancement, Stack<VisibilityRule> visibilityRules, Predicate<AdvancementNode> predicate, Output output) {
        boolean flag = predicate.test(advancement);
        VisibilityRule visibilityRule = AdvancementVisibilityEvaluator.evaluateVisibilityRule(advancement.advancement(), flag);
        boolean flag1 = flag;
        visibilityRules.push((Object)visibilityRule);
        for (AdvancementNode advancementNode : advancement.children()) {
            flag1 |= AdvancementVisibilityEvaluator.evaluateVisibility(advancementNode, visibilityRules, predicate, output);
        }
        boolean flag2 = flag1 || AdvancementVisibilityEvaluator.evaluateVisiblityForUnfinishedNode(visibilityRules);
        visibilityRules.pop();
        output.accept(advancement, flag2);
        return flag1;
    }

    public static void evaluateVisibility(AdvancementNode advancement, Predicate<AdvancementNode> predicate, Output output) {
        AdvancementNode advancementNode = advancement.root();
        ObjectArrayList stack = new ObjectArrayList();
        for (int i = 0; i <= 2; ++i) {
            stack.push((Object)VisibilityRule.NO_CHANGE);
        }
        AdvancementVisibilityEvaluator.evaluateVisibility(advancementNode, (Stack<VisibilityRule>)stack, predicate, output);
    }

    static enum VisibilityRule {
        SHOW,
        HIDE,
        NO_CHANGE;

    }

    @FunctionalInterface
    public static interface Output {
        public void accept(AdvancementNode var1, boolean var2);
    }
}

