/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.adventure.PaperAdventure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;

public class DefaultGameModeCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("defaultgamemode").requires(source -> source.hasPermission(2))).then(Commands.argument("gamemode", GameModeArgument.gameMode()).executes(context -> DefaultGameModeCommands.setMode((CommandSourceStack)context.getSource(), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)context, "gamemode"))))));
    }

    private static int setMode(CommandSourceStack commandSource, GameType gamemode) {
        int i = 0;
        MinecraftServer server = commandSource.getServer();
        server.setDefaultGameType(gamemode);
        GameType forcedGameType = server.getForcedGameType();
        if (forcedGameType != null) {
            for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
                PlayerGameModeChangeEvent event = serverPlayer.setGameMode(gamemode, PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.empty());
                if (event != null && event.isCancelled()) {
                    commandSource.sendSuccess(() -> PaperAdventure.asVanilla(event.cancelMessage()), false);
                }
                ++i;
            }
        }
        commandSource.sendSuccess(() -> Component.translatable("commands.defaultgamemode.success", gamemode.getLongDisplayName()), true);
        return i;
    }
}

