/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.SlotsArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;

public class ExecuteCommand {
    private static final int MAX_TEST_AREA = 32768;
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> Component.translatableEscape("commands.execute.blocks.toobig", maxBlocks, specifiedBlocks));
    private static final SimpleCommandExceptionType ERROR_CONDITIONAL_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType ERROR_CONDITIONAL_FAILED_COUNT = new DynamicCommandExceptionType(count -> Component.translatableEscape("commands.execute.conditional.fail_count", count));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType ERROR_FUNCTION_CONDITION_INSTANTATION_FAILURE = new Dynamic2CommandExceptionType((function, message) -> Component.translatableEscape("commands.execute.function.instantiationFailure", function, message));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_PREDICATE = (context, suggestions) -> {
        ReloadableServerRegistries.Holder holder = ((CommandSourceStack)context.getSource()).getServer().reloadableRegistries();
        return SharedSuggestionProvider.suggestResource(holder.getKeys(Registries.PREDICATE), suggestions);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralCommandNode<CommandSourceStack> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("execute").requires(source -> source.hasPermission(2))));
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("execute").requires(source -> source.hasPermission(2))).then(Commands.literal("run").redirect(dispatcher.getRoot()))).then(ExecuteCommand.addConditionals(literalCommandNode, Commands.literal("if"), true, buildContext))).then(ExecuteCommand.addConditionals(literalCommandNode, Commands.literal("unless"), false, buildContext))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withEntity(entity));
            }
            return list;
        })))).then(Commands.literal("at").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withLevel((ServerLevel)entity.level()).withPosition(entity.position()).withRotation(entity.getRotationVector()));
            }
            return list;
        })))).then(((LiteralArgumentBuilder)Commands.literal("store").then(ExecuteCommand.wrapStores(literalCommandNode, Commands.literal("result"), true))).then(ExecuteCommand.wrapStores(literalCommandNode, Commands.literal("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("positioned").then(Commands.argument("pos", Vec3Argument.vec3()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "pos")).withAnchor(EntityAnchorArgument.Anchor.FEET)))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withPosition(entity.position()));
            }
            return list;
        })))).then(Commands.literal("over").then(Commands.argument("heightmap", HeightmapTypeArgument.heightmap()).redirect(literalCommandNode, context -> {
            Vec3 position = ((CommandSourceStack)context.getSource()).getPosition();
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            double x = position.x();
            double z = position.z();
            if (!level.hasChunk(SectionPos.blockToSectionCoord(x), SectionPos.blockToSectionCoord(z))) {
                throw BlockPosArgument.ERROR_NOT_LOADED.create();
            }
            int height = level.getHeight(HeightmapTypeArgument.getHeightmap((CommandContext<CommandSourceStack>)context, "heightmap"), Mth.floor(x), Mth.floor(z));
            return ((CommandSourceStack)context.getSource()).withPosition(new Vec3(x, height, z));
        }))))).then(((LiteralArgumentBuilder)Commands.literal("rotated").then(Commands.argument("rot", RotationArgument.rotation()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withRotation(RotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rot").getRotation((CommandSourceStack)context.getSource()))))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).withRotation(entity.getRotationVector()));
            }
            return list;
        }))))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(Commands.argument("targets", EntityArgument.entities()).then(Commands.argument("anchor", EntityAnchorArgument.anchor()).fork(literalCommandNode, context -> {
            ArrayList list = Lists.newArrayList();
            EntityAnchorArgument.Anchor anchor = EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)context, "anchor");
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "targets")) {
                list.add(((CommandSourceStack)context.getSource()).facing(entity, anchor));
            }
            return list;
        }))))).then(Commands.argument("pos", Vec3Argument.vec3()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).facing(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "pos")))))).then(Commands.literal("align").then(Commands.argument("axes", SwizzleArgument.swizzle()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withPosition(((CommandSourceStack)context.getSource()).getPosition().align(SwizzleArgument.getSwizzle((CommandContext<CommandSourceStack>)context, "axes"))))))).then(Commands.literal("anchored").then(Commands.argument("anchor", EntityAnchorArgument.anchor()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withAnchor(EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)context, "anchor")))))).then(Commands.literal("in").then(Commands.argument("dimension", DimensionArgument.dimension()).redirect(literalCommandNode, context -> ((CommandSourceStack)context.getSource()).withLevel(DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context, "dimension")))))).then(Commands.literal("summon").then(Commands.argument("entity", ResourceArgument.resource(buildContext, Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).redirect(literalCommandNode, context -> ExecuteCommand.spawnEntityAndRedirect((CommandSourceStack)context.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandSourceStack>)context, "entity")))))).then(ExecuteCommand.createRelationOperations(literalCommandNode, Commands.literal("on")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapStores(LiteralCommandNode<CommandSourceStack> parent, LiteralArgumentBuilder<CommandSourceStack> literal, boolean storingResult) {
        literal.then(Commands.literal("score").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).redirect(parent, context -> ExecuteCommand.storeValue((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"), storingResult)))));
        literal.then(Commands.literal("bossbar").then(((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests(BossBarCommands.SUGGEST_BOSS_BAR).then(Commands.literal("value").redirect(parent, context -> ExecuteCommand.storeValue((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), true, storingResult)))).then(Commands.literal("max").redirect(parent, context -> ExecuteCommand.storeValue((CommandSourceStack)context.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)context), false, storingResult)))));
        for (DataCommands.DataProvider dataProvider : DataCommands.TARGET_PROVIDERS) {
            dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)literal, argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).then(Commands.literal("int").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), i -> IntTag.valueOf((int)((double)i * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(Commands.literal("float").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), i -> FloatTag.valueOf((float)((double)i * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(Commands.literal("short").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), i -> ShortTag.valueOf((short)((double)i * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(Commands.literal("long").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), i -> LongTag.valueOf((long)((double)i * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))).then(Commands.literal("double").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), i -> DoubleTag.valueOf((double)i * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")), storingResult))))).then(Commands.literal("byte").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)parent, context -> ExecuteCommand.storeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), i -> ByteTag.valueOf((byte)((double)i * DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))), storingResult))))));
        }
        return literal;
    }

    private static CommandSourceStack storeValue(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, boolean storingResult) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        return source.withCallback((success, result) -> {
            for (ScoreHolder scoreHolder : targets) {
                ScoreAccess playerScore = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
                int i = storingResult ? result : (success ? 1 : 0);
                playerScore.set(i);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandSourceStack storeValue(CommandSourceStack source, CustomBossEvent bar, boolean storingValue, boolean storingResult) {
        return source.withCallback((success, result) -> {
            int i;
            int n = storingResult ? result : (i = success ? 1 : 0);
            if (storingValue) {
                bar.setValue(i);
            } else {
                bar.setMax(i);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandSourceStack storeData(CommandSourceStack source, DataAccessor accessor, NbtPathArgument.NbtPath path, IntFunction<Tag> tagConverter, boolean storingResult) {
        return source.withCallback((success, result) -> {
            try {
                CompoundTag data = accessor.getData();
                int i = storingResult ? result : (success ? 1 : 0);
                path.set(data, (Tag)tagConverter.apply(i));
                accessor.setData(data);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }, CommandResultCallback::chain);
    }

    private static boolean isChunkLoaded(ServerLevel level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk chunkNow = level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
        return chunkNow != null && chunkNow.getFullStatus() == FullChunkStatus.ENTITY_TICKING && level.areEntitiesLoaded(chunkPos.toLong());
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditionals(CommandNode<CommandSourceStack> parent, LiteralArgumentBuilder<CommandSourceStack> literal, boolean isIf, CommandBuildContext buildContext) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literal.then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(ExecuteCommand.addConditional(parent, Commands.argument("block", BlockPredicateArgument.blockPredicate(buildContext)), isIf, context -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)context, "block").test(new BlockInWorld(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), true))))))).then(Commands.literal("biome").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(ExecuteCommand.addConditional(parent, Commands.argument("biome", ResourceOrTagArgument.resourceOrTag(buildContext, Registries.BIOME)), isIf, context -> ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandSourceStack>)context, "biome", Registries.BIOME).test(((CommandSourceStack)context.getSource()).getLevel().getBiome(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos")))))))).then(Commands.literal("loaded").then(ExecuteCommand.addConditional(parent, Commands.argument("pos", BlockPosArgument.blockPos()), isIf, context -> ExecuteCommand.isChunkLoaded(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getBlockPos((CommandContext<CommandSourceStack>)context, "pos")))))).then(Commands.literal("dimension").then(ExecuteCommand.addConditional(parent, Commands.argument("dimension", DimensionArgument.dimension()), isIf, context -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)context, "dimension") == ((CommandSourceStack)context.getSource()).getLevel())))).then(Commands.literal("score").then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targetObjective", ObjectiveArgument.objective()).then(Commands.literal("=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(parent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), isIf, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int value1, int value2) -> value1 == value2)))))).then(Commands.literal("<").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(parent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), isIf, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int value1, int value2) -> value1 < value2)))))).then(Commands.literal("<=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(parent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), isIf, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int value1, int value2) -> value1 <= value2)))))).then(Commands.literal(">").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(parent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), isIf, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int value1, int value2) -> value1 > value2)))))).then(Commands.literal(">=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(parent, Commands.argument("sourceObjective", ObjectiveArgument.objective()), isIf, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, (int value1, int value2) -> value1 >= value2)))))).then(Commands.literal("matches").then(ExecuteCommand.addConditional(parent, Commands.argument("range", RangeArgument.intRange()), isIf, context -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)context, RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)context, "range"))))))))).then(Commands.literal("blocks").then(Commands.argument("start", BlockPosArgument.blockPos()).then(Commands.argument("end", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("destination", BlockPosArgument.blockPos()).then(ExecuteCommand.addIfBlocksConditional(parent, Commands.literal("all"), isIf, false))).then(ExecuteCommand.addIfBlocksConditional(parent, Commands.literal("masked"), isIf, true))))))).then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("entities", EntityArgument.entities()).fork(parent, context -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)context, isIf, !EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "entities").isEmpty()))).executes(ExecuteCommand.createNumericConditionalHandler(isIf, context -> EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)context, "entities").size()))))).then(Commands.literal("predicate").then(ExecuteCommand.addConditional(parent, Commands.argument("predicate", ResourceOrIdArgument.lootPredicate(buildContext)).suggests(SUGGEST_PREDICATE), isIf, context -> ExecuteCommand.checkCustomPredicate((CommandSourceStack)context.getSource(), ResourceOrIdArgument.getLootPredicate((CommandContext<CommandSourceStack>)context, "predicate")))))).then(Commands.literal("function").then(Commands.argument("name", FunctionArgument.functions()).suggests(FunctionCommand.SUGGEST_FUNCTION).fork(parent, (RedirectModifier)new ExecuteIfFunctionCustomModifier(isIf))))).then(((LiteralArgumentBuilder)Commands.literal("items").then(Commands.literal("entity").then(Commands.argument("entities", EntityArgument.entities()).then(Commands.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)Commands.argument("item_predicate", ItemPredicateArgument.itemPredicate(buildContext)).fork(parent, commandContext -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)commandContext, isIf, ExecuteCommand.countItems(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandContext, "entities"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)commandContext, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)commandContext, "item_predicate")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(isIf, context -> ExecuteCommand.countItems(EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "entities"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)context, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)context, "item_predicate"))))))))).then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(Commands.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)Commands.argument("item_predicate", ItemPredicateArgument.itemPredicate(buildContext)).fork(parent, commandContext -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)commandContext, isIf, ExecuteCommand.countItems((CommandSourceStack)commandContext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "pos"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)commandContext, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)commandContext, "item_predicate")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(isIf, context -> ExecuteCommand.countItems((CommandSourceStack)context.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context, "pos"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)context, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)context, "item_predicate")))))))));
        for (DataCommands.DataProvider dataProvider : DataCommands.SOURCE_PROVIDERS) {
            literal.then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("data"), argumentBuilder -> argumentBuilder.then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).fork(parent, commandContext -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)commandContext, isIf, ExecuteCommand.checkMatchingData(dataProvider.access((CommandContext<CommandSourceStack>)commandContext), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)commandContext, "path")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(isIf, context -> ExecuteCommand.checkMatchingData(dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path")))))));
        }
        return literal;
    }

    private static int countItems(Iterable<? extends Entity> targets, SlotRange slotRange, Predicate<ItemStack> filter) {
        int i = 0;
        for (Entity entity : targets) {
            IntList list = slotRange.slots();
            for (int i1 = 0; i1 < list.size(); ++i1) {
                int _int = list.getInt(i1);
                SlotAccess slot = entity.getSlot(_int);
                ItemStack itemStack = slot.get();
                if (!filter.test(itemStack)) continue;
                i += itemStack.getCount();
            }
        }
        return i;
    }

    private static int countItems(CommandSourceStack source, BlockPos pos, SlotRange slotRange, Predicate<ItemStack> filter) throws CommandSyntaxException {
        int i = 0;
        Container container = ItemCommands.getContainer(source, pos, ItemCommands.ERROR_SOURCE_NOT_A_CONTAINER);
        int containerSize = container.getContainerSize();
        IntList list = slotRange.slots();
        for (int i1 = 0; i1 < list.size(); ++i1) {
            ItemStack item;
            int _int = list.getInt(i1);
            if (_int < 0 || _int >= containerSize || !filter.test(item = container.getItem(_int))) continue;
            i += item.getCount();
        }
        return i;
    }

    private static Command<CommandSourceStack> createNumericConditionalHandler(boolean isIf, CommandNumericPredicate predicate) {
        return isIf ? context -> {
            int i = predicate.test((CommandContext<CommandSourceStack>)context);
            if (i > 0) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass_count", i), false);
                return i;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        } : context -> {
            int i = predicate.test((CommandContext<CommandSourceStack>)context);
            if (i == 0) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)i);
        };
    }

    private static int checkMatchingData(DataAccessor accessor, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        return path.countMatching(accessor.getData());
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> source, IntBiPredicate predicate) throws CommandSyntaxException {
        ScoreHolder name = ScoreHolderArgument.getName(source, "target");
        Objective objective = ObjectiveArgument.getObjective(source, "targetObjective");
        ScoreHolder name1 = ScoreHolderArgument.getName(source, "source");
        Objective objective1 = ObjectiveArgument.getObjective(source, "sourceObjective");
        ServerScoreboard scoreboard = ((CommandSourceStack)source.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.getPlayerScoreInfo(name, objective);
        ReadOnlyScoreInfo playerScoreInfo1 = scoreboard.getPlayerScoreInfo(name1, objective1);
        return playerScoreInfo != null && playerScoreInfo1 != null && predicate.test(playerScoreInfo.value(), playerScoreInfo1.value());
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> context, MinMaxBounds.Ints bounds) throws CommandSyntaxException {
        ScoreHolder name = ScoreHolderArgument.getName(context, "target");
        Objective objective = ObjectiveArgument.getObjective(context, "targetObjective");
        ServerScoreboard scoreboard = ((CommandSourceStack)context.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo playerScoreInfo = scoreboard.getPlayerScoreInfo(name, objective);
        return playerScoreInfo != null && bounds.matches(playerScoreInfo.value());
    }

    private static boolean checkCustomPredicate(CommandSourceStack source, Holder<LootItemCondition> condition) {
        ServerLevel level = source.getLevel();
        LootParams lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, source.getPosition()).withOptionalParameter(LootContextParams.THIS_ENTITY, source.getEntity()).create(LootContextParamSets.COMMAND);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        lootContext.pushVisitedElement(LootContext.createVisitedEntry(condition.value()));
        return condition.value().test(lootContext);
    }

    private static Collection<CommandSourceStack> expect(CommandContext<CommandSourceStack> context, boolean actual, boolean expected) {
        return expected == actual ? Collections.singleton((CommandSourceStack)context.getSource()) : Collections.emptyList();
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditional(CommandNode<CommandSourceStack> commandNode, ArgumentBuilder<CommandSourceStack, ?> builder, boolean value, CommandPredicate test) {
        return ((ArgumentBuilder)builder.fork(commandNode, (RedirectModifier<CommandSourceStack>)((RedirectModifier)context -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)context, value, test.test((CommandContext<CommandSourceStack>)context))))).executes(context -> {
            if (value == test.test((CommandContext<CommandSourceStack>)context)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addIfBlocksConditional(CommandNode<CommandSourceStack> commandNode, ArgumentBuilder<CommandSourceStack, ?> literal, boolean isIf, boolean isMasked) {
        return ((ArgumentBuilder)literal.fork(commandNode, (RedirectModifier<CommandSourceStack>)((RedirectModifier)context -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)context, isIf, ExecuteCommand.checkRegions((CommandContext<CommandSourceStack>)context, isMasked).isPresent())))).executes(isIf ? context -> ExecuteCommand.checkIfRegions((CommandContext<CommandSourceStack>)context, isMasked) : context -> ExecuteCommand.checkUnlessRegions((CommandContext<CommandSourceStack>)context, isMasked));
    }

    private static int checkIfRegions(CommandContext<CommandSourceStack> context, boolean isMasked) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.checkRegions(context, isMasked);
        if (optionalInt.isPresent()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw ERROR_CONDITIONAL_FAILED.create();
    }

    private static int checkUnlessRegions(CommandContext<CommandSourceStack> context, boolean isMasked) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.checkRegions(context, isMasked);
        if (optionalInt.isPresent()) {
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)optionalInt.getAsInt());
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt checkRegions(CommandContext<CommandSourceStack> context, boolean isMasked) throws CommandSyntaxException {
        return ExecuteCommand.checkRegions(((CommandSourceStack)context.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos(context, "start"), BlockPosArgument.getLoadedBlockPos(context, "end"), BlockPosArgument.getLoadedBlockPos(context, "destination"), isMasked);
    }

    private static OptionalInt checkRegions(ServerLevel level, BlockPos begin, BlockPos end, BlockPos destination, boolean isMasked) throws CommandSyntaxException {
        BoundingBox boundingBox = BoundingBox.fromCorners(begin, end);
        BoundingBox boundingBox1 = BoundingBox.fromCorners(destination, destination.offset(boundingBox.getLength()));
        BlockPos blockPos = new BlockPos(boundingBox1.minX() - boundingBox.minX(), boundingBox1.minY() - boundingBox.minY(), boundingBox1.minZ() - boundingBox.minZ());
        int i = boundingBox.getXSpan() * boundingBox.getYSpan() * boundingBox.getZSpan();
        if (i > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)i);
        }
        RegistryAccess registryAccess = level.registryAccess();
        int i1 = 0;
        for (int z = boundingBox.minZ(); z <= boundingBox.maxZ(); ++z) {
            for (int y = boundingBox.minY(); y <= boundingBox.maxY(); ++y) {
                for (int x = boundingBox.minX(); x <= boundingBox.maxX(); ++x) {
                    BlockPos blockPos1 = new BlockPos(x, y, z);
                    BlockPos blockPos2 = blockPos1.offset(blockPos);
                    BlockState blockState = level.getBlockState(blockPos1);
                    if (isMasked && blockState.is(Blocks.AIR)) continue;
                    if (blockState != level.getBlockState(blockPos2)) {
                        return OptionalInt.empty();
                    }
                    BlockEntity blockEntity = level.getBlockEntity(blockPos1);
                    BlockEntity blockEntity1 = level.getBlockEntity(blockPos2);
                    if (blockEntity != null) {
                        CompoundTag compoundTag1;
                        if (blockEntity1 == null) {
                            return OptionalInt.empty();
                        }
                        if (blockEntity1.getType() != blockEntity.getType()) {
                            return OptionalInt.empty();
                        }
                        if (!blockEntity.components().equals(blockEntity1.components())) {
                            return OptionalInt.empty();
                        }
                        CompoundTag compoundTag = blockEntity.saveCustomOnly(registryAccess);
                        if (!compoundTag.equals(compoundTag1 = blockEntity1.saveCustomOnly(registryAccess))) {
                            return OptionalInt.empty();
                        }
                    }
                    ++i1;
                }
            }
        }
        return OptionalInt.of(i1);
    }

    private static RedirectModifier<CommandSourceStack> expandOneToOneEntityRelation(Function<Entity, Optional<Entity>> relation) {
        return context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            Entity entity = commandSourceStack.getEntity();
            return entity == null ? List.of() : (Collection)((Optional)relation.apply(entity)).filter(entity1 -> !entity1.isRemoved()).map(entity1 -> List.of(commandSourceStack.withEntity((Entity)entity1))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandSourceStack> expandOneToManyEntityRelation(Function<Entity, Stream<Entity>> relation) {
        return context -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            Entity entity = commandSourceStack.getEntity();
            return entity == null ? List.of() : ((Stream)relation.apply(entity)).filter(entity1 -> !entity1.isRemoved()).map(commandSourceStack::withEntity).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createRelationOperations(CommandNode<CommandSourceStack> node, LiteralArgumentBuilder<CommandSourceStack> argumentBuilder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)argumentBuilder.then(Commands.literal("owner").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)((Object)entity);
                optional = Optional.ofNullable(ownableEntity.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("leasher").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                optional = Optional.ofNullable(leashable.getLeashHolder());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("target").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof Targeting) {
                Targeting targeting = (Targeting)((Object)entity);
                optional = Optional.ofNullable(targeting.getTarget());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("attacker").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof Attackable) {
                Attackable attackable = (Attackable)((Object)entity);
                optional = Optional.ofNullable(attackable.getLastAttacker());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("vehicle").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> Optional.ofNullable(entity.getVehicle()))))).then(Commands.literal("controller").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> Optional.ofNullable(entity.getControllingPassenger()))))).then(Commands.literal("origin").fork(node, ExecuteCommand.expandOneToOneEntityRelation(entity -> {
            Optional<Object> optional;
            if (entity instanceof TraceableEntity) {
                TraceableEntity traceableEntity = (TraceableEntity)((Object)entity);
                optional = Optional.ofNullable(traceableEntity.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("passengers").fork(node, ExecuteCommand.expandOneToManyEntityRelation(entity -> entity.getPassengers().stream())));
    }

    private static CommandSourceStack spawnEntityAndRedirect(CommandSourceStack source, Holder.Reference<EntityType<?>> entityType) throws CommandSyntaxException {
        Entity entity = SummonCommand.createEntity(source, entityType, source.getPosition(), new CompoundTag(), true);
        return source.withEntity(entity);
    }

    /*
     * Exception decompiling
     */
    public static <T extends ExecutionCommandSource<T>> void scheduleFunctionConditionsAndTest(T originalSource, List<T> sources, Function<T, T> sourceModifier, IntPredicate successCheck, ContextChain<T> contextChain, @Nullable CompoundTag arguments, ExecutionControl<T> executionControl, InCommandFunction<CommandContext<T>, Collection<CommandFunction<T>>> functionsGetter, ChainModifiers chainModifiers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$scheduleFunctionConditionsAndTest$89(List list1, ExecutionCommandSource executionCommandSource1, ExecutionControl control) {
        for (InstantiatedFunction instantiatedFunction : list1) {
            control.queueNext(new CallFunction<ExecutionCommandSource>(instantiatedFunction, control.currentFrame().returnValueConsumer(), true).bind(executionCommandSource1));
        }
        control.queueNext(FallthroughTask.instance());
    }

    private static /* synthetic */ void lambda$scheduleFunctionConditionsAndTest$88(IntPredicate successCheck, List list, ExecutionCommandSource executionCommandSource, boolean success, int result) {
        if (successCheck.test(result)) {
            list.add(executionCommandSource);
        }
    }

    @FunctionalInterface
    static interface CommandPredicate {
        public boolean test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface CommandNumericPredicate {
        public int test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    static class ExecuteIfFunctionCustomModifier
    implements CustomModifierExecutor.ModifierAdapter<CommandSourceStack> {
        private final IntPredicate check;

        ExecuteIfFunctionCustomModifier(boolean invert) {
            this.check = invert ? i -> i != 0 : i -> i == 0;
        }

        @Override
        public void apply(CommandSourceStack originalSource, List<CommandSourceStack> soruces, ContextChain<CommandSourceStack> contextChain, ChainModifiers chainModifiers, ExecutionControl<CommandSourceStack> executionControl) {
            ExecuteCommand.scheduleFunctionConditionsAndTest(originalSource, soruces, FunctionCommand::modifySenderForExecution, this.check, contextChain, null, executionControl, input -> FunctionArgument.getFunctions((CommandContext<CommandSourceStack>)input, "name"), chainModifiers);
        }
    }

    @FunctionalInterface
    static interface IntBiPredicate {
        public boolean test(int var1, int var2);
    }
}

