/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;

public class OpCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_OP = new SimpleCommandExceptionType((Message)Component.translatable("commands.op.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("op").requires(source -> source.hasPermission(3))).then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((context, builder) -> {
            PlayerList playerList = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerList.getPlayers().stream().filter(player -> !playerList.isOp(player.getGameProfile())).map(player -> player.getGameProfile().getName()), builder);
        }).executes(context -> OpCommand.opPlayers((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)context, "targets"))))));
    }

    private static int opPlayers(CommandSourceStack source, Collection<GameProfile> gameProfiles) throws CommandSyntaxException {
        PlayerList playerList = source.getServer().getPlayerList();
        int i = 0;
        for (GameProfile gameProfile : gameProfiles) {
            if (playerList.isOp(gameProfile)) continue;
            playerList.op(gameProfile);
            ++i;
            source.sendSuccess(() -> Component.translatable("commands.op.success", gameProfile.getName()), true);
        }
        if (i == 0) {
            throw ERROR_ALREADY_OP.create();
        }
        return i;
    }
}

