/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class ParticleCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.particle.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("particle").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument("name", ParticleArgument.particle(context)).executes(context1 -> ParticleCommand.sendParticles((CommandSourceStack)context1.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)context1, "name"), ((CommandSourceStack)context1.getSource()).getPosition(), Vec3.ZERO, 0.0f, 0, false, ((CommandSourceStack)context1.getSource()).getServer().getPlayerList().getPlayers()))).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(context1 -> ParticleCommand.sendParticles((CommandSourceStack)context1.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)context1, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "pos"), Vec3.ZERO, 0.0f, 0, false, ((CommandSourceStack)context1.getSource()).getServer().getPlayerList().getPlayers()))).then(Commands.argument("delta", Vec3Argument.vec3(false)).then(Commands.argument("speed", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("count", IntegerArgumentType.integer((int)0)).executes(context1 -> ParticleCommand.sendParticles((CommandSourceStack)context1.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)context1, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "delta"), FloatArgumentType.getFloat((CommandContext)context1, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), false, ((CommandSourceStack)context1.getSource()).getServer().getPlayerList().getPlayers()))).then(((LiteralArgumentBuilder)Commands.literal("force").executes(context1 -> ParticleCommand.sendParticles((CommandSourceStack)context1.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)context1, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "delta"), FloatArgumentType.getFloat((CommandContext)context1, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), true, ((CommandSourceStack)context1.getSource()).getServer().getPlayerList().getPlayers()))).then(Commands.argument("viewers", EntityArgument.players()).executes(context1 -> ParticleCommand.sendParticles((CommandSourceStack)context1.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)context1, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "delta"), FloatArgumentType.getFloat((CommandContext)context1, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), true, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context1, "viewers")))))).then(((LiteralArgumentBuilder)Commands.literal("normal").executes(context1 -> ParticleCommand.sendParticles((CommandSourceStack)context1.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)context1, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "delta"), FloatArgumentType.getFloat((CommandContext)context1, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), false, ((CommandSourceStack)context1.getSource()).getServer().getPlayerList().getPlayers()))).then(Commands.argument("viewers", EntityArgument.players()).executes(context1 -> ParticleCommand.sendParticles((CommandSourceStack)context1.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)context1, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context1, "delta"), FloatArgumentType.getFloat((CommandContext)context1, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), false, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context1, "viewers"))))))))))));
    }

    private static int sendParticles(CommandSourceStack source, ParticleOptions particleData, Vec3 pos, Vec3 delta, float speed, int count, boolean force, Collection<ServerPlayer> viewers) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : viewers) {
            if (!source.getLevel().sendParticles(serverPlayer, particleData, force, false, pos.x, pos.y, pos.z, count, delta.x, delta.y, delta.z, speed)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_FAILED.create();
        }
        source.sendSuccess(() -> Component.translatable("commands.particle.success", BuiltInRegistries.PARTICLE_TYPE.getKey(particleData.getType()).toString()), true);
        return i;
    }
}

